<?php
/** 
* Plugin Name: WAO License Manager
* Description: Auto dispatch software keys at completed order email.(Envia correo completed a admin) 
* Version: 2.3.3 (Solo muestra version si el producto es variable. Error no muestra llaves en la Thankyou page corregido. Traduccion despacho automático.
*				  Despachos erraticos corregidos, Servidor de llaves central) 
* Author: Arturo Zubieta 
* Author URI: https://winandoffice.com/ 
* Text Domain: waolicensemanager
* WC requires at least: 3.2.0 
* WC tested up to: 3.3.0 
* License: GPL-2.0+ 
* License URI: https://www.gnu.org/licenses/gpl-2.0.txt 
*/
// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/** 
* Define constants 
*/
if ( ! defined( 'WAOLM_PLUGIN_VERSION' ) ) {
	define( 'WAOLM_PLUGIN_VERSION', '2.0' );
}
if ( ! defined( 'WAOLM_PLUGIN_DIR_PATH' ) ) {
	define( 'WAOLM_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

function waolicensemanager_load_textdomain() {
    load_plugin_textdomain( 'waolicensemanager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}

add_action( 'plugins_loaded', 'waolicensemanager_load_textdomain' );

if(soy_waolm_servidor()){
	include('waolm-server-functions.php');//FUNCIONES:waolicensemanager_init()->waolm-cpt.php->wao_settings_page()
	require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt.php' );
	add_action( 'plugins_loaded', 'waolicensemanager_init' );
}
if(soy_waolm_cliente()){
	require('waolm-client-functions.php');//FUNCIONES:waolm_pestanias_init;inserta_llave_en_thankyoupage();susllaves();
	require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-pestana-en-producto.php' );
	add_action( 'plugins_loaded', 'waolm_pestanias_init' );//Instancia de clase en waolm-client-functions.php
	include( 'classes/waolm-insert-keys-on-customer-email.php' );
	//add_action( 'woocommerce_thankyou_ppec_paypal', 'inserta_llave_en_thankyoupage' );
}

/*
 * INCLUIR FUNCIONES PARA ENVIAR LAS LLAVES  EN EL CORREO ELECTRONICO Y 
 * REGISTRA LAS MISMAS EN POST META DE LA ORDER
*/
//include( 'classes/noclass-skoe-admin.php' );

/*
 * FUNCIONES GENERALES
 *
 */

function admin_style() {
echo "<style>.column-title {width:300px;}
	.order_details{border:solid 2px black!important; background-color:#eeeeee!important;}
</stile>";
}
add_action('admin_enqueue_scripts', 'admin_style');


/* ESTRUCTURA DE LAS VARIABLES USADAS EN EL PLUGIN
 * wp_options
 * 	_waolm_server_id (se graba cuando el cliente activa soy_servidor. Por defecto será la 1)
 * 	_waolm_server_url (id) (es util? si tenemos 'home' o 'url' en options) ****** NOOOOO
 * 
 * wp_{server_id}_options
 * 	CPT waolm
 * 		waolm-ID
 * 		waolm-key (toda la información de las llaves por SKU)
 * 	_waolm_server_options
 * 		url_of_server_when_server_is_outside (only show 'home' option in configuration tab)
 * 		
 * 
 * wp_{client_id}_options
 * 	_waolm_options
 * 		i_am_server true:false:external_server	(convert this site to server or external server) *** actua sobre 1:_waolm_server_id 
 * 		url_of_external_server	(copy from configuration of server)(if configured, client will search keys there) *** si tiene url, se prioriza sobre _waolm_server_id ***
*/

function soy_waolm_servidor(){
	//return true;
	if(is_multisite()){
		$current_blog_id=get_current_blog_id();
		if($current_blog_id==get_waolm_server_id()){
			return true;
		}else{
			return false;
		}
	}else{
		$waolm_options=get_option('_waolm_options');
		$i_am_server=$waolm_options['i_am_server'];
		if ($i_am_server=='S'){
			return true;
		}
	}
}

function get_waolm_server_option($option){//obtener _waolm_server_options[$option] 
	if (is_multisite()){
		$options=get_blog_option(get_waolm_server_id(),'_waolm_server_options');
	}else{
		$options=get_option('_waolm_server_options');
	}
	return $options[$option];
}

function get_waolm_client_option($option){//obtener _waolm_options[$option] 
	$options=get_option('_waolm_options');
	return $options[$option];
}

function get_waolm_server_key_information(){//obtener informacion de las llaves
}

function get_waolm_server_id(){//cambiar a 1 y obtener _waolm_server_id
	if(is_multisite()){
		return get_blog_option(1,'_waolm_server_id');
	}else{
		return get_option('_waolm_server_id'); //valores: x, 1, 0
	}
}

function get_server_prefix(){//cambiar a 1, obtener _waolm_server_id y devolver prefix adecuado
	if(is_multisite()){
		$prefix = get_blog_option(1,'_waolm_server_id');
		if ($prefix=1){
			return 'wp_';
		}else{
			return 'wp_'.$prefix.'_';
		}
	}else{
		return 'wp_';
	}
}

function soy_waolm_cliente(){
	return true;
}

function admin_style2(){
	echo "<style>.waolm-config {padding:20px;margin:5px;background-color:GhostWhite;border:solid 1px blac;border-radius:15px;box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);}
	             .waolmtitle {text-align:center;background-color:#e6f2ff;padding:30px;border:solid 1px white}
		  </style>";
}
add_action('admin_enqueue_scripts', 'admin_style2');

/*
  ______                   _                     ______                   
 / _____)        _     _  (_)                   (_____ \                  
( (____  _____ _| |_ _| |_ _ ____   ____  ___    _____) )____  ____ _____ 
 \____ \| ___ (_   _|_   _) |  _ \ / _  |/___)  |  ____(____ |/ _  | ___ |
 _____) ) ____| | |_  | |_| | | | ( (_| |___ |  | |    / ___ ( (_| | ____|
(______/|_____)  \__)  \__)_|_| |_|\___ (___/   |_|    \_____|\___ |_____)
                                  (_____|                    (_____|      
*/
{//grupo de lectura
function wao_settings_page(){
	if(soy_waolm_servidor()){
		$url=get_option('home')."/wp-admin/edit.php?post_type=licensemanagerwao&page=waolm_config";
	}else{
		$url=get_option('home')."/wp-admin/admin.php?page=waolm_config";
	}
	$url="options.php";
	?>
	<form action="<?php echo $url;?>" method="post">
		<?php 
		settings_fields( '_waolm_options' ); //Llamamos a la seccion de configuracion definida con register_setting()
		do_settings_sections( 'waolm_fields' ); //Mostramos la sección definida con add_settings_section
		?>
		<input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
		<hr>
  </form>
	<?php
} // function wao_settings_page() END
//////REGISTRANDO LOS CAMPOS O VARIABLES EN LA BASE DE DATOS [PASO 1]
function waolm_register_settings() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Windows And Office License Manager Settings', 'waolm_section_text', 'waolm_fields' );
	// 								$id, 			           $title,                                              $callback, 				$page, 			$section 	$args = array()
	add_settings_field( 'waolm_setting_urlmanuals', 'URL raiz para el enlace a manual de usuario y descargas', 'waolm_setting_urlmanuals', 'waolm_fields', 'waolm1_settings' );
	add_settings_field( 'waolm_setting_external_server', 'URL de un servidor externo', 'waolm_setting_external_server', 'waolm_fields', 'waolm1_settings' );
	if(!soy_waolm_servidor()){
		add_settings_field( 'waolm_setting_server', 'Configure este pais como servidor', 'waolm_setting_server', 'waolm_fields', 'waolm1_settings' );
	}
}
add_action( 'admin_init', 'waolm_register_settings' );
/////VALIDACION
function _waolm_options_validate( $input ) {
	$newinput['urlmanuals'] = trim( $input['urlmanuals'] );
	if ( ! preg_match( '/^[a-z0-9]{32}$/i', $newinput['urlmanuals'] ) ) {
	  $newinput['urlmanuals'] = '';
	}
	if ($input['soy_servidor']=="S") {
		if(is_multisite()){
			update_blog_option(1,'_waolm_server_id',get_current_blog_id());
		}else{
			update_option('_waolm_server_id',1);
		}
	}else{
		if(!is_multisite()){
			delete_option('_waolm_server_id');
		}
	}
  //return $newinput;
  if(is_multisite()){
	update_blog_option(1,"_depu",$depu);
  }else{
	update_option("_depu",$depu);
  }
  return $input;
}
/////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]
function waolm_section_text() {
  echo '<p>Configuracion de Parametros para WAO License Manager</p>';
}
function waolm_setting_urlmanuals() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_urlmanuals' name='_waolm_options[urlmanuals]' type='text' style='width:400px;' value='".esc_attr( $options['urlmanuals'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.)</i> ";
}
function waolm_setting_external_server() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_externalserver' name='_waolm_options[externalserver]' type='text' style='width:400px;'  value='".esc_attr( $options['externalserver'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.) (Activar SOLO SI el servidor está en otra web. Caso contrario dejar en blanco)</i> ";
}
function waolm_setting_server(){ //siempre en multisite
	if(is_multisite()){
		$waolm_server_id=get_waolm_server_id();
		switch_to_blog($waolm_server_id);
			$blog_name=get_option( 'blogname' );
		restore_current_blog();
		if(get_current_blog_id()==$waolm_server_id){
			$checked1="checked";
			$checked2="";
			$message = "";
		}else{
			$checked1="";
			$checked2="checked";
			$message="<span style='color:gray;font-size:12px;font-style: italic;'>(Servidor configurado es: <b>".$blog_name.")</b></span>";
		}
		echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="S" '.$checked1.'><label for="waolm_server_id">Si</label>&nbsp;&nbsp;&nbsp;'; 
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="N" '.$checked2.'><label for="waolm_server_id">No</label>'; 
		echo "</span>&nbsp;&nbsp;".$message;
	}
}//fin de funcion waolm_setting_server
function waolm_url($url){ //esto ya hace lo que debe
	$url=str_replace('http://','',$url);
	$url=str_replace('https://','',$url);
	$url="https://".$url;
	if(substr($url, -1)<>'/'){
		$url=$url."/";
	}
	return $url;
}

}//fin grupo de lectura
