<?php
/*
 * Funciones para migrar de metadato a tabla
 * Metadato a migrar: _keys
 * Tabla nueva: wp_waolm_dispatched_keys
 * ESTRUCTURA DE LA TABLA
 * ID|sku|product_name|customer_email|order_id|key|
*/

if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function update_main_option($name,$value){
	if(is_multisite()){
		switch_to_blog(1);
	}
	update_option($name,$value);
	if(is_multisite()){
		restore_current_blog();
	}
}
function get_main_option($name){
	if(is_multisite()){
		switch_to_blog(1);
	}
	$retorno=get_option($name);
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}

$migration_done = get_main_option('waolm_keys_migration_done');
if ($migration_done) {
	return;
}else{
    create_waolm_dispatched_keys_table(); 
    //migrate_keys_to_new_table();
    //update_order_meta_for_table_keys_with_wpdb();
}


// Crear la tabla wp_waolm_dispatched_keys si no existe (en site=1)
function create_waolm_dispatched_keys_table() {
	if(is_multisite()){
		switch_to_blog(1);
	}
    global $wpdb;
    $table_name = $wpdb->prefix . 'waolm_dispatched_keys';
    $charset_collate = $wpdb->get_charset_collate();
	$sql = "CREATE TABLE IF NOT EXISTS $table_name (
		ID bigint(20) NOT NULL AUTO_INCREMENT,
		sku varchar(255) DEFAULT NULL,
		product_name varchar(255) DEFAULT NULL,
		customer_email varchar(255) DEFAULT NULL,
		order_id bigint(20) DEFAULT NULL,
		`key` varchar(255) DEFAULT NULL, -- Usa comillas invertidas para evitar conflictos con palabras reservadas.
		date date DEFAULT NULL, -- Nueva columna para la fecha.
		site_id int(3) DEFAULT NULL, -- Nueva columna para el ID del sitio con tipo de dato int.
		site_url varchar(255) DEFAULT NULL,
		PRIMARY KEY (ID)
	) $charset_collate;";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
	if(is_multisite()){
		restore_current_blog();
	}
}

// Migrar de metadato _keys a tabla wp_waolm_dispatched_keys (de cada site)
function migrate_keys_to_new_table() {
    global $wpdb;
	if(is_multisite()){
		$init_site_id = get_current_blog_id();
		switch_to_blog(1);
		$sites = get_sites();
		$site_url = get_option('home');;
		foreach ( $sites as $site ) {
			switch_to_blog( $site->blog_id );
			$site_id = get_current_blog_id();
			$orders = wc_get_orders(array('limit' => -1));
			//$table_name = $wpdb->prefix . 'waolm_dispatched_keys';
			$table_name = 'wp_waolm_dispatched_keys';//la tabla reside en site_id=1
			foreach ($orders as $order) {
				$order_id = $order->get_id();
				$keys_meta = get_post_meta($order_id, '_keys', true);
				$date = $order->get_date_created()->format('Y-m-d');
				if ($keys_meta) {
					foreach ($keys_meta as $key_data) {
						if (is_array($key_data)) {
							foreach ($key_data as $key_object) {
								if (is_object($key_object)) {
									$sku = $key_object->product_sku;
									if($sku){
										$product_name = $key_object->productname;
										$customer_email = $order->get_billing_email();
										$key = $key_object->skey;

										$wpdb->insert(
											$table_name,
											array(
												'sku' => $sku,
												'product_name' => $product_name,
												'customer_email' => $customer_email,
												'order_id' => $order_id,
												'key' => $key,
												'date' => $date,
												'site_id' => $site_id,
												'site_url' => $site_url
											),
											array(
												'%s',
												'%s',
												'%s',
												'%d',
												'%s',
												'%s', // Para 'date' (si es una cadena de fecha en formato 'Y-m-d')
												'%d', // Para 'site_id'
												'%s'	// Para 'site_ulr'
											)
										);
									}//fin de if sku
								}
							}
						}
					}
				}
			}//fin de foreach orders
		}//fin de foreach sites
		switch_to_blog($init_site_id);
	    update_main_option('waolm_keys_migration_done',1);
	}else{//else de si multisite
		$orders = wc_get_orders(array('limit' => -1));
		$table_name = 'wp_waolm_dispatched_keys';
		$site_url = get_option('home');;
		$site_id = 0;
		foreach ($orders as $order) {
			$order_id = $order->get_id();
			$keys_meta = get_post_meta($order_id, '_keys', true);
			$date = $order->get_date_created()->format('Y-m-d');
			if ($keys_meta) {
				foreach ($keys_meta as $key_data) {
					if (is_array($key_data)) {
						foreach ($key_data as $key_object) {
							if (is_object($key_object)) {
								$sku = $key_object->product_sku;
								if($sku){
									$product_name = $key_object->productname;
									$customer_email = $order->get_billing_email();
									$key = $key_object->skey;

									$wpdb->insert(
										$table_name,
										array(
											'sku' => $sku,
											'product_name' => $product_name,
											'customer_email' => $customer_email,
											'order_id' => $order_id,
											'key' => $key,
											'date' => $date,
											'site_id' => $site_id,
											'site_url' => $site_url
										),
										array(
											'%s',
											'%s',
											'%s',
											'%d',
											'%s',
											'%s',	// Para 'date' (si es una cadena de fecha en formato 'Y-m-d')
											'%d',   // Para 'site_id'
											'%s'	// Para 'site_ulr'
										)
									);
								}//fin de if sku
							}
						}
					}
				}
			}
		}//fin de foreach orders
	    update_main_option('waolm_keys_migration_done',1);
	}//fin de si multisite
}

function update_order_meta_for_table_keys_with_wpdb() {
    global $wpdb;

    // Verifica si estamos en un entorno multisite
    if (is_multisite()) {
        // Guarda el ID del sitio actual
        $current_blog_id = get_current_blog_id();
        
        // Obtén todos los sitios de la red
        $sites = get_sites();

        foreach ($sites as $site) {
            switch_to_blog($site->blog_id);

            // Obtener todos los IDs de las órdenes que tienen el metadato _table_keys
            $order_ids = $wpdb->get_col("
                SELECT post_id
                FROM {$wpdb->prefix}postmeta
                WHERE meta_key = '_table_keys'
            ");

            // Recorrer cada ID de la orden
            foreach ($order_ids as $order_id) {
                // Verificar que el metadato _table_keys tenga un valor
                $table_keys = get_post_meta($order_id, '_table_keys', true);

                if (!empty($table_keys)) {
                    // Crear el metadato llaves_enviadas = yes
                    update_post_meta($order_id, 'llaves_enviadas', 'yes');
                }
            }
        }

        // Restaurar el sitio original
        switch_to_blog($current_blog_id);
    } else {
        // Si no es un entorno multisite, ejecutar en el sitio actual
        $order_ids = $wpdb->get_col("
            SELECT post_id
            FROM {$wpdb->prefix}postmeta
            WHERE meta_key = '_table_keys'
        ");

        foreach ($order_ids as $order_id) {
            $table_keys = get_post_meta($order_id, '_table_keys', true);

            if (!empty($table_keys)) {
                update_post_meta($order_id, 'llaves_enviadas', 'yes');
            }
        }
    }
}

// Crear la vista licensemanagerwao_view, para tratar las llaves desde post y postmeta como una tabla
function create_licensemanagerwao_view() {
    global $wpdb;

    // Comprobar si la vista ya existe
    $view_exists = $wpdb->get_var("
        SELECT COUNT(*) 
        FROM information_schema.tables 
        WHERE table_type = 'VIEW' 
        AND table_schema = '{$wpdb->dbname}' 
        AND table_name = '{$wpdb->prefix}licensemanagerwao_view'
    ");

    // Si la vista no existe, crearla
    if ($view_exists == 0) {
        $sql = "
        CREATE OR REPLACE VIEW {$wpdb->prefix}licensemanagerwao_view AS
        SELECT 
            p.menu_order AS nro,
            p.ID AS license_id,
            p.post_title AS title,
            MAX(CASE WHEN pm.meta_key = '_key' THEN pm.meta_value END) AS _key,
            MAX(CASE WHEN pm.meta_key = '_product' THEN pm.meta_value END) AS _product,
            MAX(CASE WHEN pm.meta_key = '_product_name' THEN pm.meta_value END) AS _product_name,
            MAX(CASE WHEN pm.meta_key = '_activations' THEN pm.meta_value END) AS _activations,
            MAX(CASE WHEN pm.meta_key = '_dispatched' THEN pm.meta_value END) AS _dispatched,
            MAX(CASE WHEN pm.meta_key = '_priority' THEN pm.meta_value END) AS _priority,
            MAX(CASE WHEN pm.meta_key = '_waolm_sku' THEN pm.meta_value END) AS _waolm_sku
        FROM 
            {$wpdb->prefix}posts p
        LEFT JOIN 
            {$wpdb->prefix}postmeta pm 
        ON 
            (p.ID = pm.post_id)
        WHERE 
            p.post_type = 'licensemanagerwao'
        GROUP BY 
            p.ID;
        ";

        // Ejecutar la consulta SQL
        $wpdb->query($sql);
        echo "La vista 'licensemanagerwao_view' ha sido creada.";
    } else {
        echo "La vista 'licensemanagerwao_view' ya existe.";
    }
}

// Guardar las llaves en la nueva tabla a partir de ahora
// Este procedimiento está en waolm-insert-keys-on-customer-email.php function update_table_waolm_dispatched_keys()
