<?php
/*
 * paso0: creacion de tablas 
 * paso1: migracion CPT -> wp_waolicensemanager_keys
 * paso2: migracion _keys -> wp_waolm_dispatched_keys
 * paso3: migracion wp_waolm_dispatched_keys -> wp_waolm_rel_orders wp_waolm_rel_orders_keys

 * waolm_mostrar_resumen_paso0
 * 	obtener_estado_creacion_tablas()
 * 	mostrar_boton_ejecutar_paso0()
 * 	mostrar_boton_reset_paso0()
 * waolm_mostrar_resumen_paso1
 * 	if(paso0){
 * 		obtener_estado_migracion_paso1()
 * 		mostrar_boton_ejecutar_paso1()
 * 		mostrar_boton_reset_paso1()
 * 	} 
 * waolm_mostrar_resumen_paso2
 * 	if(paso1){
 * 		obtener_estado_migracion_paso2()
 * 		mostrar_boton_ejecutar_paso2()
 * 		mostrar_boton_reset_paso2()
 * 	}
 * waolm_mostrar_resumen_paso3
 * 	if(paso2){
 * 		obtener_estado_migracion_paso3()
 * 		mostrar_boton_ejecutar_paso3()
 * 		mostrar_boton_reset_paso3()
 * 	}
 * 
 * waolm_procesar_reset_paso0
 * waolm_procesar_reset_paso1
 * waolm_procesar_reset_paso2
 * waolm_procesar_reset_paso3

 * waolm_procesar_migracion_paso0
 * waolm_procesar_migracion_paso1
 * waolm_procesar_migracion_paso2
 * waolm_procesar_migracion_paso3
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function procesar_botones2(){
	// 👇 Procesamiento del formulario (antes de mostrar el formulario)

	if (
		$_SERVER['REQUEST_METHOD'] === 'POST' &&
		isset($_POST['waolm_action'])
	) {
		$accion = sanitize_text_field($_POST['waolm_action']);
		$mensaje = '';

		if ($accion === 'Resetear creacion tablas') {
			$mensaje = waolm_procesar_reset_paso0();
		}

		if ($accion === 'Ejecutar creacion tablas') {
			$mensaje = waolm_procesar_migracion_paso0();
		}

		if ($accion === 'Resetear migracion CPT a wp_waolicensemanager_keys') {
			$mensaje = waolm_procesar_reset_paso1();
		}

		if ($accion === 'Ejecutar migracion CPT a wp_waolicensemanager_keys') {
			$mensaje = waolm_procesar_migracion_paso1();
		}

		if ($accion === 'Resetear migracion de dispatched_keys') {
			$mensaje = waolm_procesar_reset_paso2();
		}

		if ($accion === 'Ejecutar migracion _keys a wp_waolm_dispatched_keys') {
			$mensaje = waolm_procesar_migracion_paso2();
		}

		if ($accion === 'Resetear wp_waolm_dispatched_keys a wp_waolm_rel_orders') {
			$mensaje = waolm_procesar_reset_paso3();
		}

		if ($accion === 'Ejecutar wp_waolm_dispatched_keys a wp_waolm_rel_orders') {
			$mensaje = waolm_procesar_migracion_paso3();
		}
	}
	
	
}

// CONTENEDOR DE TODOS LOS RESUMENES
function waolm_setting_migrate_status1() {
    global $wpdb;
	procesar_botones2();

    $resumen_paso0 = waolm_mostrar_resumen_paso0();
	$resumen_paso1 = waolm_mostrar_resumen_paso1();
	$resumen_paso2 = waolm_mostrar_resumen_paso2();
	$resumen_paso3 = waolm_mostrar_resumen_paso3(); 

    $template = "<div style='border:solid 1px gray;padding:5px;border-radius:3px;background-color:#fcfefd;width:49%;'>
		<h3>Estado de creación de las tablas:</h3>
		<h3>Seguimiento de migraci&oacute;n:</h3>
		{$resumen_paso0}
		<ul>
            <li style='padding-left:15px;'>{$resumen_paso1}</li>
			<li style='padding-left:15px;'>{$resumen_paso2}</li>
			<li style='padding-left:15px;'>{$resumen_paso3}</li>
        </ul><hr>
		<hr>
		<br>
    </div>";
	//$template = str_replace('',$resumen_paso0,$template);
$a = paso1_concluido()?"si":"no";
    echo $template.$a;  
}

$migration = (is_multisite() && get_current_blog_id() != 1)
	? get_blog_option(1, 'waolm_migration', [])
	: get_option('waolm_migration', []);

if(!isset($migration['licensemanagerwao_view_created'])){
	create_licensemanagerwao_view();
}
// Crear la vista licensemanagerwao_view, para tratar las llaves desde post y postmeta como una tabla 
function create_licensemanagerwao_view() {
    global $wpdb;
    $migration = is_multisite()?get_blog_option(1,'waolm_migration', []):get_option('waolm_migration', []);
	if($migration['licensemanagerwao_view_created']){return;}
    // Comprobar si la vista ya existe
    $view_exists = $wpdb->get_var("
        SELECT COUNT(*) 
        FROM information_schema.tables 
        WHERE table_type = 'VIEW' 
        AND table_schema = '{$wpdb->dbname}' 
        AND table_name = '{$wpdb->base_prefix}licensemanagerwao_view'
    ");

    // Si la vista no existe, crearla
    if ($view_exists == 0) {
//            MAX(CASE WHEN pm.meta_key = '_key' THEN pm.meta_value END) AS _key,
        $sql = "
        CREATE OR REPLACE VIEW {$wpdb->base_prefix}licensemanagerwao_view AS
        SELECT 
            p.menu_order AS nro,
            p.ID AS license_id,
            p.post_title AS _key,
            MAX(CASE WHEN pm.meta_key = '_product' THEN pm.meta_value END) AS product,
            MAX(CASE WHEN pm.meta_key = '_product_name' THEN pm.meta_value END) AS product_name,
            MAX(CASE WHEN pm.meta_key = '_activations' THEN pm.meta_value END) AS activations,
            MAX(CASE WHEN pm.meta_key = '_dispatched' THEN pm.meta_value END) AS dispatched,
            MAX(CASE WHEN pm.meta_key = '_priority' THEN pm.meta_value END) AS priority,
            MAX(CASE WHEN pm.meta_key = '_waolm_sku' THEN pm.meta_value END) AS waolm_sku
        FROM 
            {$wpdb->base_prefix}posts p
        LEFT JOIN 
            {$wpdb->base_prefix}postmeta pm 
        ON 
            (p.ID = pm.post_id)
        WHERE 
            p.post_type = 'licensemanagerwao'
        GROUP BY 
            p.ID;
        ";

        // Ejecutar la consulta SQL
        $wpdb->query($sql);
        echo "La vista 'licensemanagerwao_view' ha sido creada.";
    } else {
        echo "La vista 'licensemanagerwao_view' ya existe.";
    }

    // Obtener opción de migración desde el blog 1 o actual
    $migration = is_multisite()?get_blog_option(1, 'waolm_migration', []):get_option('waolm_migration', []);
    $migration['licensemanagerwao_view_created'] = true;
    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

// paso0: creacion de tablas 

function waolm_mostrar_resumen_paso0(){
	$status = obtener_estado_creacion_tablas();
	$si0=$si1='';
	if($status['waolicensemanager_keys']=='SI'&&$status['waolm_dispatched_keys']=='SI'&&$status['waolm_rel_orders']=='SI'&&$status['waolm_rel_orders_keys']=='SI'){
			$si1 = 'display: none;';
	}else{
			$si0 = 'display: none;';
	}

    $blogs = waolm_mostrar_migracion_por_blogs();

    if (!empty($blogs)) {$si0 = 'display: none;';}


	$template = "
			<ul style='padding-left:10px;'>
				<li>Vista licensemanagerwao_view creada:  {$status['licensemanagerwao_view']}</li>
				<li>Tabla waolicensemanager_keys creada:  {$status['waolicensemanager_keys']}</li>
				<li>Tabla waolm_dispatched_keys creada: {$status['waolm_dispatched_keys']}</li>
				<li>Tabla waolm_rel_orders creada: {$status['waolm_rel_orders']}</li>
				<li>Tabla waolm_rel_orders_keys creada: {$status['waolm_rel_orders_keys']}</li>
			</ul>
		<input type='submit' name='waolm_action' value='Resetear creacion tablas' class='button' style='margin-top:10px;{$si0};color:red;border-color:red;'>
		<input type='submit' name='waolm_action' value='Ejecutar creacion tablas' class='button' style='margin-top:10px;{$si1};'>
	";
	return $template;
}

function obtener_estado_creacion_tablas() {
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    return [
        'licensemanagerwao_view' => !empty($migration['licensemanagerwao_view_created']) ? 'SI' : 'NO',
        'waolicensemanager_keys' => !empty($migration['table_wp_waolicensemanager_keys_created']) ? 'SI' : 'NO',
        'waolm_dispatched_keys' => !empty($migration['table_wp_waolm_dispatched_keys_created']) ? 'SI' : 'NO',
        'waolm_rel_orders'      => !empty($migration['wp_waolm_rel_orders_created']) ? 'SI' : 'NO',
        'waolm_rel_orders_keys' => !empty($migration['wp_waolm_rel_orders_keys_created']) ? 'SI' : 'NO',
    ];
}

function waolm_procesar_reset_paso0() {
    global $wpdb;

    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    $tables = [
        'wp_waolicensemanager_keys',
        'wp_waolm_dispatched_keys',
        'wp_waolm_rel_orders_keys',
        'wp_waolm_rel_orders',
    ];

    $tables_flags = [
        'table_wp_waolicensemanager_keys_created',
        'table_wp_waolm_dispatched_keys_created',
        'wp_waolm_rel_orders_created',
        'wp_waolm_rel_orders_keys_created',
    ];

    foreach ($tables as $table) {
        $wpdb->query("DROP TABLE IF EXISTS {$table}");
    }
    foreach ($tables_flags as $table) {
		unset($migration[$table]);
    }
	if (is_multisite()) {
		update_blog_option(1,'waolm_migration', $migration);
	} else {
		update_option('waolm_migration', $migration);
	}		

    return '🗑️ Todas las tablas de migración han sido eliminadas.';
}

function waolm_procesar_migracion_paso0() {
	if(paso0_concluido()){return;}
    waolm_create_table_waolicensemanager_keys();
    waolm_create_table_waolm_dispatched_keys();
    waolm_create_table_waolm_rel_orders();
    waolm_create_table_waolm_rel_orders_keys();
}

function waolm_create_table_waolicensemanager_keys() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolicensemanager_keys';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde el blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['table_wp_waolicensemanager_keys_created'])) return;

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        _key TEXT NOT NULL,
        product BIGINT NOT NULL,
        product_name VARCHAR(255),
        activations INT DEFAULT 0,
        dispatched INT DEFAULT 0,
        priority INT DEFAULT 0,
        waolm_sku VARCHAR(100),
        status VARCHAR(20) DEFAULT 'publish',
        PRIMARY KEY (id),
        KEY product (product),
        KEY waolm_sku (waolm_sku),
        KEY status (status)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['table_wp_waolicensemanager_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_dispatched_keys() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_dispatched_keys';
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        sku VARCHAR(100),
        product_name VARCHAR(255),
        customer_email VARCHAR(255),
        order_id BIGINT NOT NULL,
        `key` TEXT NOT NULL,
        date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        site_id INT NOT NULL,
        site_url VARCHAR(255) NOT NULL,
        PRIMARY KEY (id),
        KEY order_id (order_id),
        KEY site_id (site_id)
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	$sql_drop = "DROP TABLE $table_name";
    dbDelta($sql_drop);
    dbDelta($sql);
	
    // Obtener opción desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    $migration['table_wp_waolm_dispatched_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_rel_orders() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_rel_orders';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['wp_waolm_rel_orders_created'])) return; 

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        order_id BIGINT NOT NULL,
        customer_email VARCHAR(255) NOT NULL,
        site_id INT NOT NULL,
        site_url VARCHAR(255) NULL,
        date DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        sended TINYINT(1),
        PRIMARY KEY (id),
        KEY order_id (order_id),
        KEY customer_email (customer_email)
    ) $charset_collate;";
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['wp_waolm_rel_orders_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

function waolm_create_table_waolm_rel_orders_keys() {
    global $wpdb;
    $table_name = $wpdb->base_prefix . 'waolm_rel_orders_keys';
    $orders_table = $wpdb->base_prefix . 'waolm_rel_orders';
    $charset_collate = $wpdb->get_charset_collate();

    // Obtener opción de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['wp_waolm_rel_orders_keys_created'])) return;

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        rel_order_id BIGINT UNSIGNED NOT NULL,
        sku VARCHAR(100),
        product_name VARCHAR(255),
        `key` TEXT NOT NULL,
        dispatched TINYINT(1) DEFAULT 0,
        priority INT DEFAULT 0,
        PRIMARY KEY (id),
        KEY rel_order_id (rel_order_id),
        CONSTRAINT fk_rel_order_id FOREIGN KEY (rel_order_id) REFERENCES $orders_table(id) ON DELETE CASCADE
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    $migration['wp_waolm_rel_orders_keys_created'] = true;

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $migration);
    } else {
        update_option('waolm_migration', $migration);
    }
}

// paso1: migracion de CPT licensemanagerwao -> wp_waolicensemanager_keys
// Resumen de migracion por sitio CPT -> waolicensemanager_keys (TABLA 1)

function waolm_mostrar_resumen_paso1() {
	$status = obtener_estado_creacion_tablas();

	if($status['waolicensemanager_keys']=='SI'&&$status['waolm_dispatched_keys']=='SI'&&$status['waolm_rel_orders']=='SI'&&$status['waolm_rel_orders_keys']=='SI'){
	}else{
		return;
	}


	//if(get_migration_status('wp_waolicensemanager_keys_migrated') <> 1 ){$si0="display:none";}
	$si0=get_migration_status('wp_waolicensemanager_keys_migrated') == 1?"display:none":"";

	$migration_option = get_option( 'waolm_migration', [] );
    if (!isset($migration_option['dispatched_keys_migration_done'])) {$si0="";} // mostrar boton 

	//mostrar_mensaje_admin_1();

    $blogs = waolm_mostrar_migracion_por_blogs();

    if (empty($blogs)) {
		return "<div style='background:#fff;border:solid 1px #e37113; border-left-width:4px;padding:1px 12px'>No hay datos de migración registrados.</div>
		<input type='submit' name='waolm_action' value='Ejecutar migracion CPT a wp_waolicensemanager_keys' class='button' style='margin-top:10px;'>";

    }
	$template = "<hr><h3>Migraci&oacute;n de CPT a waolicensemanager_keys</h3> 
		<h4>Resumen de migración por sitio.</h4>
		<table class='widefat fixed striped' style='max-width:700px;'>
		<thead>
			<tr>
				<th style='width:80px;'>Site ID</th>
				<th>Total Encontrados</th>
				<th>Total Migrados</th>
				<th>Total Ignoradas</th>
				<th>Estado</th>
			</tr>
		</thead>
		<tbody>{filas}
		</tbody></table>
		{nonce}
		<small><i>- ❌ No migrado por falta de SKU</i></small><br>
		<input type='submit' name='waolm_action' value='Resetear migracion CPT a wp_waolicensemanager_keys' class='button' style='margin-top:10px;color:red;border-color:red;{$si0}'>
		";

	$filas="";
    foreach ($blogs as $site_id => $info) {
        $encontrados = intval($info['post_encontrados']);
        $migrados    = intval($info['migrados']);
        $ignoradas   = isset($info['ignoradas']) ? intval($info['ignoradas']) : 0;

        $estado = ($encontrados === $migrados)
            ? '✔️ Completo'
            : (($migrados === 0) ? '❌ No migrado' : '⚠️ Parcial');

        $filas .= "<tr>
            <td>$site_id</td>
            <td>$encontrados</td>
            <td>$migrados</td>
            <td>$ignoradas</td>
            <td>$estado</td>
        </tr>";
    }

    $template = str_replace('{filas}',$filas,$template);
	$template = str_replace('{nonce}',wp_nonce_field('waolm_migracion_acciones0', 'waolm_migracion_nonce0'),$template);

    return $template;
}

function waolm_mostrar_migracion_por_blogs() {
    $is_multisite = is_multisite();

    $data = ($is_multisite && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (empty($data['blogs']) || !is_array($data['blogs'])) {
        return [];
    }

    return $data['blogs'];
}

function waolm_procesar_migracion_paso1() {// EJECUTA BUCLE DE MIGRACION DE CPT A TABLA
	if(paso1_concluido()){return;}
    global $wpdb;

    // Obtener bandera de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    if (!empty($migration['wp_waolicensemanager_keys_migrated'])) {
		organizar_waolm_options_0(); 
        return;
    }

    $table = 'wp_waolicensemanager_keys';

    if (!is_multisite()) {
        _waolm_migrate_licensemanagerwao_blog(1, $table);
    } else {
        $sites = get_sites(['limit' => 0]);
        foreach ($sites as $site) {
            switch_to_blog($site->blog_id);
            _waolm_migrate_licensemanagerwao_blog($site->blog_id, $table);
            restore_current_blog();
        }
    }
    // Obtener nuevamente bandera de migración desde blog 1 o actual
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    // Marcar como migrado
    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', array_merge($migration, [
            'wp_waolicensemanager_keys_migrated' => 1,
        ]));
    } else {
        update_option('waolm_migration', array_merge($migration, [
            'wp_waolicensemanager_keys_migrated' => 1,
        ]));
    }

}

function _waolm_migrate_licensemanagerwao_blog($site_id, $table) { // EJECUTA MIGRACION DE CPT A TABLA POR UN SITIO
    global $wpdb;

    $posts = get_posts([
        'post_type'      => 'licensemanagerwao',
        'post_status'    => ['publish', 'draft', 'pending', 'future', 'private'],
        'numberposts'    => -1,
        'fields'         => 'ids',
        'no_found_rows'  => true,
    ]);

    $total_encontrados = count($posts);
    $total_migrados = 0;
    $total_ignoradas = 0;

    if (!empty($posts)) {
        foreach ($posts as $post_id) {
            $post_title    = get_the_title($post_id);
            $product       = get_post_meta($post_id, '_product', true);
            $product_name  = get_post_meta($post_id, '_product_name', true);
            $activations   = get_post_meta($post_id, '_activations', true);
            $dispatched    = get_post_meta($post_id, '_dispatched', true);
            $priority      = get_post_meta($post_id, '_priority', true);
            $waolm_sku     = get_post_meta($post_id, '_waolm_sku', true);
            $status        = get_post_status($post_id);

            if (empty($post_title)) continue;

            // Si no tiene SKU, se ignora
            if (empty($waolm_sku)) {
                $total_ignoradas++;
                continue;
            }

            $inserted = $wpdb->insert($table, [
                '_key'         => $post_title,
                'product'      => $product,
                'product_name' => $product_name,
                'activations'  => $activations,
                'dispatched'   => $dispatched,
                'priority'     => $priority,
                'waolm_sku'    => $waolm_sku,
                'status'       => $status,
            ]);

            if ($inserted) {
                $total_migrados++;
            }
        }
    }

    // Guardar información en la opción waolm_migration (siempre en blog 1)
    $option_data = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);

    $option_data['blogs'][$site_id] = [
        'post_encontrados' => $total_encontrados,
        'migrados'         => $total_migrados,
        'ignoradas'        => $total_ignoradas
    ];

    if (is_multisite() && get_current_blog_id() != 1) {
        update_blog_option(1, 'waolm_migration', $option_data);
    } else {
        update_option('waolm_migration', $option_data);
    }
}

function waolm_procesar_reset_paso1() { // BORRAR LA TABLA wp_waolicensemanager_keys Y BANDERAS
	global $wpdb; 

	// Eliminar tabla wp_waolicensemanager_keys si existe
	$table_name = 'wp_waolicensemanager_keys';
	//$wpdb->query("DROP TABLE IF EXISTS $table_name");
	$wpdb->query("DELETE FROM $table_name");
	$wpdb->query("ALTER TABLE $table_name AUTO_INCREMENT = 1");

	// Obtener la opción de migración
	$migration = get_option('waolm_migration', []);

	// Eliminar banderas relacionadas con paso 1 y datos por blogs
	//	$migration['table_wp_waolicensemanager_keys_created'],
	unset(
		$migration['wp_waolicensemanager_keys_migrated'],
		$migration['blogs']
	);

	// Actualizar la opción (si queda vacía, la eliminamos)
	if (empty($migration)) {
		delete_option('waolm_migration');
	} else {
		update_option('waolm_migration', $migration);
	}
}

// paso2: migracion de _keys a tablas normalizadas (wp_waolm_rel_orders y wp_waolm_rel_orders_keys) por subsites
// obtener el estado de migración de _keys a wp_waolm_dispatched_keys por subsites
function waolm_mostrar_resumen_paso2() {

	if(get_migration_status('wp_waolicensemanager_keys_migrated') <> 1 ){return;}
	
	//mostrar_mensaje_admin_2();
    global $wpdb;

    $sites = is_multisite() ? get_sites(['fields' => 'ids']) : [1];
    $status = [];

	$template =  '<hr><h3>Migración de _keys a waolm_dispatched_keys.</h3>
	<table border="1" cellpadding="5" cellspacing="0">
	<table class="widefat fixed striped" style="max-width:700px;">
	<tr>
		<th width="10%">Site ID</th>
		<th width="30%">Site URL</th>
		<th width="10%">Migrables</th>
		<th width="10%">Ordenes Migradas</th>
		<th width="10%">Total Llaves</th>
		<th width="30">Estado</th>
	</tr>
		{filas}
	</table>
	{nonce}
	<input type="submit" name="waolm_action" value="Resetear migracion de dispatched_keys" class="button" style="margin-top:10px;color:red;border-color:red;{si0}">
	<input type="submit" name="waolm_action" value="Ejecutar migracion _keys a wp_waolm_dispatched_keys" class="button" style="margin-top:10px;{si1}">
	';
    foreach ( $sites as $site_id ) {
        if ( is_multisite() ) {
            switch_to_blog( $site_id );
        }

        // Cantidad de órdenes migrables (con _keys y sin bandera)
        $migrables = waolm_contar_migrables();

        // Cantidad de órdenes migradas (con bandera)
        $migradas = waolm_contar_migradas();
		$llaves = waolm_contar_llaves($site_id);
        $status[] = [
            'site_id'     => $site_id,
            'site_url'    => get_site_url( $site_id ),
            'migrables'   => intval( $migrables ),
            'migradas'    => intval( $migradas ),
            'llaves'    => intval( $llaves ),
        ];

        if ( is_multisite() ) {
            restore_current_blog();
        }
    }

	$filas = "";
	foreach ( $status as $row ) {
        // Estado
        if ( $row['migrables'] == 0 && $row['migradas'] > 0 ) {
            $estado = '✅ Completo';
        } elseif ( $row['migrables'] > 0 ) {
            $estado = '⚠️ Parcial';
        } else {
            $estado = '❌ Sin datos';
        }
		$filas .= '<tr><td>' . esc_html( $row['site_id'] ) . '</td><td>' . esc_html( $row['site_url'] ) . '</td><td>' . esc_html( $row['migrables'] ) . '</td><td>' . esc_html( $row['migradas'] ) . '</td><td>'.esc_html( $row['llaves'] ) .'</td><td>' . esc_html( $estado ) . '</td></tr>';
	}
	$si0=$si1=""; 
	$migration_option = get_option( 'waolm_migration', [] );
    if (isset($migration_option['dispatched_keys_migration_done']) && $migration_option['dispatched_keys_migration_done'] == 1) {$si1="display:none";}else{$si0="display:none";}
    if (isset($migration_option['ID_migrated_to_normalized_tables'])) {$si0="display:none";}

	$template = str_replace('{filas}',$filas,$template);
	$template = str_replace('{nonce}',wp_nonce_field('waolm_migracion_acciones', 'waolm_migracion_nonce'),$template);
	$template = str_replace('{si0}',$si0,$template);
	$template = str_replace('{si1}',$si1,$template);
	
    return $template;
}

function get_migration_status($clave){
    $migration = (is_multisite() && get_current_blog_id() != 1)
        ? get_blog_option(1, 'waolm_migration', [])
        : get_option('waolm_migration', []);
	return isset($migration[$clave])?$migration[$clave]:0;
}

function waolm_procesar_reset_paso2() {
    global $wpdb;

    // 1. Eliminar banderas en las órdenes de todos los subsites
    $sites = is_multisite() ? get_sites(['fields' => 'ids']) : [1];

    foreach ( $sites as $site_id ) {
        if ( is_multisite() ) {
            switch_to_blog( $site_id );
        }

        // Obtener las órdenes con la bandera _keys_migrated_to_table
        $order_ids = $wpdb->get_col(
            "
            SELECT post_id
            FROM {$wpdb->postmeta}
            WHERE meta_key = '_keys_migrated_to_table'
            "
        );

        // Eliminar la bandera de cada orden
        if ( ! empty( $order_ids ) ) {
            foreach ( $order_ids as $order_id ) {
                delete_post_meta( $order_id, '_keys_migrated_to_table' );
            }
        }

        if ( is_multisite() ) {
            restore_current_blog();
        }
    }


	// 2. borrar contenido de las tablas normalizadas

    $table_orders = 'wp_waolm_rel_orders';
    $table_keys   = 'wp_waolm_rel_orders_keys';

    // 3. Borrar contenido de claves primero (por FK ON DELETE CASCADE no es necesario, pero por si acaso)
    $wpdb->query("DELETE FROM {$table_keys}");
    $wpdb->query("ALTER TABLE {$table_keys} AUTO_INCREMENT = 1");

    // 4. Borrar contenido de órdenes
    $wpdb->query("DELETE FROM {$table_orders}");
    $wpdb->query("ALTER TABLE {$table_orders} AUTO_INCREMENT = 1");

    // 5. Limpiar banderas de progreso
    $migration = get_option('waolm_migration', []);
    // unset($migration['rows_migrated_to_normalized_tables']); // ya no necesitamos?
    unset( $migration['dispatched_keys_migration_done'] );
    unset( $migration['sitio_migrado'] );
    update_option( 'waolm_migration', $migration );
}

function waolm_procesar_migracion_paso2( $batch_size = 500 ) { // ahora migramos directamente a las tablas normalizadas
	$site_id = ultimo_sitio();

    $table_orders = 'wp_waolm_rel_orders';
    $table_keys = 'wp_waolm_rel_orders_keys';

	if($site_id==0){
		if(paso2_concluido()){return;}
		$migrables_global = 0; // Controlador global de migrables
		// Marcar bandera global si ya no hay migrables en ningún sitio
		$migration_option = get_option( 'waolm_migration', [] );
        $migration_option['dispatched_keys_migration_done'] = 1;
		update_option( 'waolm_migration', $migration_option );
	}else{
		global $wpdb;
		if ( is_multisite() ) {
			switch_to_blog( (int)$site_id );
		}

		$site_url = get_site_url( $site_id );

		// Verificar migrables en el sitio actual
		$migrables_count = waolm_contar_migrables(); // en site
		if ( $migrables_count <> 0 ) {
			// Obtener lote de órdenes para migrar
			$sql =$wpdb->prepare("SELECT p.ID, pm.meta_value AS keys_value, p.post_date
				FROM {$wpdb->posts} p
				INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_keys'
				LEFT JOIN {$wpdb->postmeta} pm2 ON p.ID = pm2.post_id AND pm2.meta_key = '_keys_migrated_to_table'
				WHERE p.post_type = 'shop_order' AND pm2.meta_value IS NULL
				LIMIT %d", $batch_size);
			$orders = $wpdb->get_results($sql);
			foreach ( $orders as $order ) { // bucle de orders en site correcto
				$order_id = $order->ID;

				$keys_data = maybe_unserialize( $order->keys_value );
				$order_date = date( 'Y-m-d', strtotime( $order->post_date ) );
				$customer_email = get_post_meta( $order_id, '_billing_email', true );

				if ( ! is_array( $keys_data ) ) {
					continue; // Saltar si no es array
				}


				if (isset($keys_data)) { //si existen llaves en _keys de la orden
					$wpdb->insert($table_orders, [
						'order_id'       => $order_id,
						'site_id'        => $site_id,
						'site_url'        => $site_url,
						'customer_email' => $customer_email,
						'date'           => $order_date,
						'sended'         => 1,
					]);
					$rel_order_id = $wpdb->insert_id;

					foreach ( $keys_data as $cantidad ) {
						if(is_object($cantidad)){
							$keys_obj1 = $cantidad;
							if(!isset($key_obj1->product_sku) || is_null($key_obj1->productname)||is_null($key_obj1->keyid)||is_null($key_obj1->skey)){
								continue;
							}
								
							$wpdb->insert($table_keys, [
								'rel_order_id' => $rel_order_id,
								'sku'           => $key_obj1->product_sku,
								'product_name'  => $key_obj1->productname,
								'key'           => $key_obj1->skey,
							]); 
						
						}else{

							foreach ($cantidad as $key_obj){
								if ( is_object( $key_obj ) ) { 

									if(!isset($key_obj->product_sku) || is_null($key_obj->productname)||is_null($key_obj->keyid)||is_null($key_obj->skey)){
										continue;
									}
										
									$wpdb->insert($table_keys, [
										'rel_order_id' => $rel_order_id,
										'sku'           => $key_obj->product_sku,
										'product_name'  => $key_obj->productname,
										'key'           => $key_obj->skey,
									]); 

									// Seguimiento del mayor ID procesado
									//$max_id_en_lote = max($max_id_en_lote, intval($clave->id));

								}else{
									foreach($key_obj as $key_obj1){
										if(!isset($key_obj1->product_sku) || is_null($key_obj1->productname)||is_null($key_obj1->keyid)||is_null($key_obj1->skey)){
											continue;
										}
											
										$wpdb->insert($table_keys, [
											'rel_order_id' => $rel_order_id,
											'sku'           => $key_obj1->product_sku,
											'product_name'  => $key_obj1->productname,
											'key'           => $key_obj1->skey,
										]); 
									}
								}
								
							}
							
						}

					}

				} // fin de si existen _keys

				// Marcar orden como migrada
				update_post_meta( $order_id, '_keys_migrated_to_table', 1 ); 
			}// bucle de ordenes (migrando a tabla)

			// Verificar migrables en el sitio actual
			$migrables_count = waolm_contar_migrables(); // cuenta en site _keys que no tengan __keys_migrated_to_table correcto
			if (!$migrables_count>0){// marcar sitio sitio cuando se hayan terminado las migrables
				marcar_sitio_completado($site_id);
			}
		
		}else{
			marcar_sitio_completado($site_id);
		}
		if ( is_multisite() ) {
			restore_current_blog();
		}
	}

    return; 
}

function waolm_contar_migrables(){
	global $wpdb;
	// Cantidad de órdenes migrables (con _keys y sin bandera)
	$migrables = $wpdb->get_var(
		"SELECT COUNT(*)
		 FROM {$wpdb->posts} p
		 INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_keys'
		 LEFT JOIN {$wpdb->postmeta} pm2 ON p.ID = pm2.post_id AND pm2.meta_key = '_keys_migrated_to_table'
		 WHERE p.post_type = 'shop_order' AND pm2.meta_value IS NULL"
	);
	return $migrables;
}

function waolm_contar_migrables_sitios(){
    $sites = is_multisite() ? get_sites(['fields' => 'ids']) : [1];
	$total = 0;
	foreach($sites as $site){
        if ( is_multisite() ) {
            switch_to_blog( $site );
        }
		$total += waolm_contar_migrables();
	}
	if ( is_multisite() ) {
		restore_current_blog();
	}
	
	return $total; 
}

function waolm_contar_migradas(){
	global $wpdb;
        // Cantidad de órdenes migradas (con bandera)
        $migradas = $wpdb->get_var(
            "SELECT COUNT(*)
             FROM {$wpdb->posts} p
             INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_keys_migrated_to_table'
             WHERE p.post_type = 'shop_order'"
        );
	return $migradas;
}

function waolm_contar_llaves($site_id){
	global $wpdb;
	
	// 3. Migradas (órdenes ya migradas)
	/*$migradas = $wpdb->get_var($wpdb->prepare("
		SELECT COUNT(*) FROM wp_waolm_rel_orders
		WHERE site_id = %d
	", $site_id));*/

	// 4. Nro. de llaves
	$nro_llaves = $wpdb->get_var($wpdb->prepare("
		SELECT COUNT(*) FROM wp_waolm_rel_orders_keys rok
		INNER JOIN wp_waolm_rel_orders ro ON rok.rel_order_id = ro.id
		WHERE ro.site_id = %d
	", $site_id));
	
	return $nro_llaves;
}

function ultimo_sitio(){
	$migrate_options = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
	$ultimo_sitio=isset($migrate_options['sitio_migrado'])?$migrate_options['sitio_migrado']:0;
	$esteeselultimo=false;
    //$sites = is_multisite() ? get_sites(['fields' => 'ids']) : [1];
	//$sites = array_merge([0],$sites);

	$sites = is_multisite()
		? array_map('intval', get_sites(['fields' => 'ids']))
		: [ (int) (get_current_blog_id() ?: 1) ];

	array_unshift($sites, 0); // => [0, 1, 2, 3, ...]

	foreach($sites as $site_id){
		if($esteeselultimo){return $site_id;}
		if($ultimo_sitio==$site_id){
			$esteeselultimo = true;
		}
	}
	return 0;
}

function marcar_sitio_completado($site_id){
		if(is_multisite()){
			$migrate_options = get_blog_option(1,'waolm_migration',[]);
			$migrate_options['sitio_migrado'] = $site_id;
			update_blog_option(1,'waolm_migration',$migrate_options);
		}else{
			$migrate_options = get_option('waolm_migration',[]);
			$migrate_options['sitio_migrado'] = $site_id;
			update_option('waolm_migration',$migrate_options);
		}
		return true;
}

function sitio_completo($site_id){

		$migrate_options = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
		$site_id1 = isset($migrate_options['sitio_migrado'])?$migrate_options['sitio_migrado']:0;
		return $site_id1 == $site_id;
}

function quitarx(){
		$migrate_options = get_option('waolm_migration',[]);
		unset($migrate_options['licensemanagerwao_view_created']);
		//$migrate_options['sitio_migrado'] = 1;
//		unset($migrate_options['dispatched_keys_migration_done']);
		update_option('waolm_migration',$migrate_options);
}
//quitarx(); 
function ponerx(){
		$migrate_options = get_option('waolm_migration',[]);
		$migrate_options['dispatched_keys_migration_done'] = 1;
//		unset($migrate_options['dispatched_keys_migration_done']);
		update_option('waolm_migration',$migrate_options);
}
//ponerx();  

// paso3: Migración de waolm_dispatched_keys → tablas normalizadas: migradas / total
function waolm_mostrar_resumen_paso3() {
    // Validar si el paso anterior de migración ya fue completado
    if ( (int)get_migration_status('dispatched_keys_migration_done') != 1 ) {
        return;
    }

    global $wpdb;

	$migration_option = get_option( 'waolm_migration', [] );
	$si0=$si1="";
    if (!isset($migration_option['rows_migrated_to_normalized_tables'])) {$si0="display:none";}else{$si1="display:none";}

    // 1. Obtener todos los site_id únicos desde wp_waolm_dispatched_keys
    $site_ids = $wpdb->get_col("
        SELECT DISTINCT site_id
        FROM wp_waolm_dispatched_keys
        ORDER BY site_id
    ");

    $filas = '';

    foreach ( $site_ids as $site_id ) {
        // 2. Migrables (órdenes únicas)
        $migrables = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(*) FROM (
                SELECT order_id
                FROM wp_waolm_dispatched_keys
                WHERE site_id = %d
                GROUP BY order_id
            ) AS sub
        ", $site_id));

        // 3. Migradas (órdenes ya migradas)
        $migradas = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(*) FROM wp_waolm_rel_orders
            WHERE site_id = %d
        ", $site_id));

        // 4. Nro. de llaves
        $nro_llaves = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(*) FROM wp_waolm_rel_orders_keys rok
            INNER JOIN wp_waolm_rel_orders ro ON rok.rel_order_id = ro.id
            WHERE ro.site_id = %d
        ", $site_id));

        // 5. Estado
        if ( $migrables == 0 ) {
            $estado = '—';
        } elseif ( $migradas >= $migrables ) {
            $estado = '✔ Completado';
        } else {
            $estado = '⏳ Parcial';
        }

        // Agregar fila 
        $filas .= '<tr><td>' . intval($site_id) . '</td><td>' . intval($migrables) . '</td><td>' . intval($migradas) . '</td><td>' . intval($nro_llaves) . '</td><td>' . esc_html($estado) . '</td></tr>';
    }

    // Tabla HTML
    $template = '
    <h3>Resumen de migración Paso 3</h3>
    <table class="widefat striped" style="max-width:800px;">
        <thead>
            <tr>
                <th>Site ID</th>
                <th>Órdenes migrables</th>
                <th>Órdenes migradas</th>
                <th>Total de llaves</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            {filas}
        </tbody>
    </table>
	<input type="submit" name="waolm_action" value="Resetear wp_waolm_dispatched_keys a wp_waolm_rel_orders" class="button" style="margin-top:10px;color:red;border-color:red;{si0}">
	<input type="submit" name="waolm_action" value="Ejecutar wp_waolm_dispatched_keys a wp_waolm_rel_orders" class="button" style="margin-top:10px;{si1}">
    '; 
	$template = str_replace('{filas}',$filas,$template);
	$template = str_replace('{si0}',$si0,$template);
	$template = str_replace('{si1}',$si1,$template);
    //return str_replace('{filas}', $filas_html, $template);
	return $template; 
}

function waolm_procesar_reset_paso3() {
    global $wpdb;

    $table_orders = 'wp_waolm_rel_orders';
    $table_keys   = 'wp_waolm_rel_orders_keys';

    // 1. Borrar contenido de claves primero (por FK ON DELETE CASCADE no es necesario, pero por si acaso)
    $wpdb->query("DELETE FROM {$table_keys}");
    $wpdb->query("ALTER TABLE {$table_keys} AUTO_INCREMENT = 1");

    // 2. Borrar contenido de órdenes
    $wpdb->query("DELETE FROM {$table_orders}");
    $wpdb->query("ALTER TABLE {$table_orders} AUTO_INCREMENT = 1");

    // 3. Limpiar bandera de progreso
    $migration = get_option('waolm_migration', []);
    unset($migration['ID_migrated_to_normalized_tables']);
    unset($migration['rows_migrated_to_normalized_tables']);
    update_option('waolm_migration', $migration);

    return '🧹 Tablas normalizadas reseteadas correctamente.';
}
 
function waolm_procesar_migracion_paso3($lote = 500) {
	if(paso3_concluido()){return;}
    global $wpdb;
    $table_dispatched = 'wp_waolm_dispatched_keys';
    $table_orders = 'wp_waolm_rel_orders';
    $table_keys = 'wp_waolm_rel_orders_keys';

    // Obtener el último ID migrado
    $migration = get_option('waolm_migration', []);
    $last_id = isset($migration['ID_migrated_to_normalized_tables']) ? intval($migration['ID_migrated_to_normalized_tables']) : 0;

    // Paso 1: obtener las siguientes $lote combinaciones únicas de order_id + site_id
    $distinct_orders = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT DISTINCT order_id, site_id
             FROM {$table_dispatched}
             WHERE ID > %d
             ORDER BY ID ASC
             LIMIT %d",
            $last_id,
            $lote
        )
    );

    if (paso2_concluido()&&empty($distinct_orders)) { 
        // Fin de migración


        $migration['rows_migrated_to_normalized_tables'] = 1;
        update_option('waolm_migration', $migration);
        return '✅ Migración finalizada. No hay más órdenes únicas por migrar.';
    }

    $max_id_en_lote = $last_id;

    foreach ($distinct_orders as $pedido) {

        $order_id = intval($pedido->order_id);
        $site_id  = intval($pedido->site_id);

        // Obtener todas las filas asociadas a esta combinación
        $claves = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM {$table_dispatched}
                 WHERE order_id = %d AND site_id = %d
                 ORDER BY ID ASC",
                $order_id,
                $site_id
            )
        );

        if (empty($claves)) {
            continue;
        }

        // Usamos la primera fila para obtener email y fecha
        $first = $claves[0];
        $customer_email = $first->customer_email;
        $fecha = $first->date;
        $site_url = $first->site_url;

        // Insertar en wp_waolm_rel_orders si no existe
        $rel_order_id = $wpdb->get_var($wpdb->prepare(
            "SELECT ID FROM {$table_orders} WHERE order_id = %d AND site_id = %d",
            $order_id,
            $site_id
        ));

        if (!$rel_order_id) {
            $wpdb->insert($table_orders, [
                'order_id'       => $order_id,
                'site_id'        => $site_id,
                'site_url'        => $site_url,
                'customer_email' => $customer_email,
                'date'           => $fecha,
                'sended'         => 1,
            ]);
            $rel_order_id = $wpdb->insert_id;
        }

        // Insertar todas las claves relacionadas en rel_orders_keys
        foreach ($claves as $clave) {
            $wpdb->insert($table_keys, [
                'rel_order_id' => $rel_order_id,
                'sku'           => $clave->sku,
                'product_name'  => $clave->product_name,
                'key'           => $clave->key,
            ]);

            // Seguimiento del mayor ID procesado
            $max_id_en_lote = max($max_id_en_lote, intval($clave->id));
        }
    }

    // Guardar el ID más alto migrado como bandera
    $migration['ID_migrated_to_normalized_tables'] = $max_id_en_lote;
    update_option('waolm_migration', $migration);

    return "🔁 Migración ejecutada hasta ID {$max_id_en_lote} ({$lote} órdenes únicas procesadas).";
} 

function tabla_wp_waolicensemanager_keys_creada(){
	//$migration_option = get_option( 'waolm_migration', [] );
	$migration_option = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
	return isset($migration_option['table_wp_waolicensemanager_keys_created'])?true:false;
}
function tabla_wp_waolm_dispatched_keys_creada(){
	$migration_option = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
	return isset($migration_option['table_wp_waolm_dispatched_keys_created'])?true:false;
}
function tabla_wp_waolm_rel_orders_creada(){
	$migration_option = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
	return isset($migration_option['wp_waolm_rel_orders_created'])?true:false;
}
function tabla_wp_waolm_rel_orders_keys_creada(){
	$migration_option = is_multisite()?get_blog_option(1,'waolm_migration',[]):get_option('waolm_migration',[]);
	return isset($migration_option['wp_waolm_rel_orders_keys_created'])?true:false;
}

function todas_las_tablas_creadas(){ 
	$si = tabla_wp_waolicensemanager_keys_creada()&&tabla_wp_waolm_dispatched_keys_creada()&&tabla_wp_waolm_rel_orders_creada()&&tabla_wp_waolm_rel_orders_keys_creada();
	return $si;
}

function paso0_concluido(){
	return todas_las_tablas_creadas();
}

function paso1_concluido(){
	$migration_option = is_multisite()?get_blog_option( 1,'waolm_migration', [] ):get_option( 'waolm_migration', [] );
	return isset($migration_option['wp_waolicensemanager_keys_migrated'])?true:false;
}
function paso1_concluidox(){
	$migration_option = is_multisite()?get_blog_option( 1,'waolm_migration', [] ):get_option( 'waolm_migration', [] );
	return isset($migration_option['wp_waolicensemanager_keys_migrated'])?true:false;
}

function paso2_concluido(){ //  esta función solo por existir hace fallar la web
	$migration_option = is_multisite()?get_blog_option( 1,'waolm_migration', [] ):get_option( 'waolm_migration', [] );
	return isset($migration_option['dispatched_keys_migration_done'])?true:false;
}

function paso3_concluido(){
	$migration_option = is_multisite()?get_blog_option( 1,'waolm_migration', [] ):get_option( 'waolm_migration', [] );
	return isset($migration_option['rows_migrated_to_normalized_tables'])?true:false;
}

/********************************************/

/**
 * WAO License Manager - Verificador de Órdenes (vista de control)
 * Pega este bloque en tu plugin (por ejemplo, en el archivo principal o incluido).
 */

// En tu plugin (cargado en admin), NO al nivel global.
// Esto asegura que wp_get_current_user() ya esté disponible.

//add_action('network_admin_menu', 'waolm_register_network_submenu',30);

function waolm_register_network_submenu() {
    // Si definiste la página en otro archivo, inclúyelo aquí.
    // Ajusta la ruta si la tienes en otra carpeta/archivo.
}   

function waolm_render_verify_orders_page123() {
    if ( ! current_user_can('manage_network') ) {
        wp_die(__('No tienes permisos suficientes.', 'waolm'));
    }

    $nonce_action = 'waolm_verify_orders_action';
    $nonce_name   = 'waolm_verify_orders_nonce';

    $result_rows = [];
    $site_used   = null;

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST[$nonce_name]) && wp_verify_nonce($_POST[$nonce_name], $nonce_action)) {

        $raw = isset($_POST['waolm_input']) ? trim(wp_unslash($_POST['waolm_input'])) : '';
        // Formato: "12|34|56*2" => orders: 12,34,56 ; site_id: 2
        $site_id = null;
        $orders  = [];

        if ($raw !== '') {
            $parts       = explode('*', $raw);
            $orders_part = trim($parts[0] ?? '');
            $site_part   = trim($parts[1] ?? '');

            if ($orders_part !== '') {
                $orders = array_filter(array_map(function($x){
                    $x = trim($x);
                    return ctype_digit($x) ? (int)$x : null;
                }, explode('|', $orders_part)));
                $orders = array_values(array_unique(array_filter($orders, fn($v) => $v !== null)));
            }

            if ($site_part !== '' && ctype_digit($site_part)) {
                $site_id = (int)$site_part;
            }
        }

        if (!is_multisite()) {
            $site_id = get_current_blog_id(); // en single, usar actual
        } elseif ($site_id === null) {
            $site_id = get_current_blog_id(); // si no se especifica, usar actual
        }
        $site_used = (int)$site_id;

        // Cambiar de sitio si aplica
        $switched = false;
        if (is_multisite() && (int)$site_id !== (int)get_current_blog_id()) {
            $blog_details = get_site($site_id);
            if ($blog_details) {
                switch_to_blog($site_id);
                $switched = true;
            }
        }

        global $wpdb;
        $table_dispatched = $wpdb->prefix . 'waolm_dispatched_keys';
        $table_rel_orders = $wpdb->prefix . 'waolm_rel_orders';
        $table_rel_keys   = $wpdb->prefix . 'waolm_rel_orders_keys';

        foreach ($orders as $order_id) {
            $result_rows[] = [
                'order_id'  => $order_id,
                // Columnas 2,3,4 en el MISMO formato: <ul><li><code>sku</code> | <code>key</code></li>...</ul>
                'keys_meta' => waolm_fetch_keys_from_meta($order_id),
                'dispatched'=> waolm_fetch_keys_from_dispatched($table_dispatched, $order_id),
                'rel'       => waolm_fetch_keys_from_rel($table_rel_orders, $table_rel_keys, $order_id),
            ];
        }

        if ($switched) {
            restore_current_blog();
        }
    }

    ?>
    <div class="wrap">
        <h1>WAO LM: Verificar órdenes</h1>

        <form method="post" style="margin-top:16px;max-width:900px;">
            <?php wp_nonce_field($nonce_action, $nonce_name); ?>
            <p>
                <label for="waolm_input"><strong>Ingresa órdenes y sitio</strong> (formato: <code>1201|1205|1310*2</code>)</label><br>
                <input type="text" id="waolm_input" name="waolm_input" class="regular-text" style="width:100%;" placeholder="Ej: 1201|1205|1310*2" value="<?php echo isset($_POST['waolm_input']) ? esc_attr($_POST['waolm_input']) : ''; ?>">
            </p>
            <p>
                <button type="submit" class="button button-primary">Enviar</button>
            </p>
        </form>

        <?php if (!empty($result_rows)): ?>
            <hr>
            <h2>Resultados <?php echo $site_used !== null ? '(Site ID: ' . esc_html($site_used) . ')' : ''; ?></h2>
            <table class="widefat striped" style="table-layout:fixed;word-break:break-word;">
                <thead>
                    <tr>
                        <th style="width:110px;">Order ID</th>
                        <th>_keys (meta) &mdash; <em>sku | key</em></th>
                        <th>waolm_dispatched_keys &mdash; <em>sku | key</em></th>
                        <th>rel_orders &harr; rel_orders_keys &mdash; <em>sku | key</em></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($result_rows as $row): ?>
                    <tr>
                        <td><code><?php echo esc_html($row['order_id']); ?></code></td>
                        <td><?php echo $row['keys_meta']; ?></td>
                        <td><?php echo $row['dispatched']; ?></td>
                        <td><?php echo $row['rel']; ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    <?php
}

/** =========================
 *  HELPERS: normalización a "sku | key"
 *  ========================= */

/**
 * Comprueba si una tabla existe en la BD actual
 */
function waolm_table_exists($table_name) {
    global $wpdb;
    // Evitar SQL directo con el nombre sin preparar puede ser problemático con prefijos; aquí usamos prepare.
    $sql = $wpdb->prepare(
        "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = %s",
        $table_name
    );
    $count = (int) $wpdb->get_var($sql);
    return $count > 0;
}

/**
 * Devuelve llaves desde meta '_keys', normalizadas a "<code>sku</code> | <code>key</code>"
 */
function waolm_fetch_keys_from_meta($order_id) {
    $raw = get_post_meta($order_id, '_keys', true);
    if (empty($raw)) {
        return '<em>sin llaves</em>';
    }

    $items = [];

    // 1) Intentar deserializar
    $maybe = maybe_unserialize($raw);
    if (is_array($maybe)) {
        foreach ($maybe as $uno) {
			foreach ($uno as $obj) {
				$sku = '';
				$key = '';

				if (is_object($obj)) {
					$sku = $obj->product_sku ?? ($obj->waolm_sku ?? '');
					$key = $obj->skey ?? ($obj->skey ?? '');
				} elseif (is_array($obj)) {
					$sku = $obj['product_sku'] ?? ($obj['waolm_sku'] ?? '');
					$key = $obj['skey'] ?? ($obj['skey'] ?? '');
				}

				if ($sku !== '' || $key !== '') {
					$items[] = sprintf('<code>%s</code> | <code>%s</code>', esc_html((string)$sku), esc_html((string)$key));
				}
			}
        }
    }
    // 2) Si no hubo resultados, intentar JSON
    if (empty($items)) {
        $json = json_decode($raw, true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($json)) {
            foreach ($json as $obj) {
                $sku = $obj['product_sku'] ?? ($obj['waolm_sku'] ?? '');
                $key = $obj['key'] ?? ($obj['license_key'] ?? '');
                if ($sku !== '' || $key !== '') {
                    $items[] = sprintf('<code>%s</code> | <code>%s</code>', esc_html((string)$sku), esc_html((string)$key));
                }
            }
        }
    }

    if (empty($items)) {
        // 3) Nada parseable: mostrar crudo de forma segura (por si viene un string de llaves)
        return '<pre style="white-space:pre-wrap;word-break:break-word;">' . esc_html((string)$raw) . '</pre>';
    }

    return '<ul style="margin:0;padding-left:1.2em;"><li>' . implode('</li><li>', $items) . '</li></ul>';
}

/**
 * Devuelve llaves desde wp_waolm_dispatched_keys (formato: "<code>sku</code> | <code>key</code>")
 */
function waolm_fetch_keys_from_dispatched($table_dispatched, $order_id) {
    global $wpdb;

    if (!waolm_table_exists($table_dispatched)) {
        return '<em>tabla no existe</em>';
    }

    $rows = $wpdb->get_results(
        $wpdb->prepare("SELECT sku, `key` FROM {$table_dispatched} WHERE order_id = %d ORDER BY id ASC", $order_id),
        ARRAY_A
    );

    if (!$rows) {
        return '<em>sin llaves</em>';
    }

    $items = [];
    foreach ($rows as $r) {
        $items[] = sprintf('<code>%s</code> | <code>%s</code>',
            esc_html((string)($r['sku'] ?? '')),
            esc_html((string)($r['key'] ?? ''))
        );
    }

    return '<ul style="margin:0;padding-left:1.2em;"><li>' . implode('</li><li>', $items) . '</li></ul>';
}

/**
 * Devuelve llaves desde waolm_rel_orders ↔ waolm_rel_orders_keys (formato: "<code>sku</code> | <code>key</code>")
 */
function waolm_fetch_keys_from_rel($table_rel_orders, $table_rel_keys, $order_id) {
    global $wpdb;

    if (!waolm_table_exists($table_rel_orders) || !waolm_table_exists($table_rel_keys)) {
        return '<em>tablas no existen</em>';
    }

    $rels = $wpdb->get_results(
        $wpdb->prepare("SELECT id FROM {$table_rel_orders} WHERE order_id = %d ORDER BY id ASC", $order_id),
        ARRAY_A
    );

    if (!$rels) {
        return '<em>sin llaves</em>';
    }

    $items = [];
    foreach ($rels as $ro) {
        $rel_order_id = (int)$ro['id'];
        $keys = $wpdb->get_results(
            $wpdb->prepare("SELECT sku, `key` FROM {$table_rel_keys} WHERE rel_order_id = %d ORDER BY id ASC", $rel_order_id),
            ARRAY_A
        );
        if ($keys) {
            foreach ($keys as $k) {
                $items[] = sprintf('<code>%s</code> | <code>%s</code>',
                    esc_html((string)($k['sku'] ?? '')),
                    esc_html((string)($k['key'] ?? ''))
                );
            }
        }
    }

    if (empty($items)) {
        return '<em>sin llaves</em>';
    }

    return '<ul style="margin:0;padding-left:1.2em;"><li>' . implode('</li><li>', $items) . '</li></ul>';
}

