<?php
/*
 * Menu de configuracion de wao license manager
 * Version 3.1: Guarda templates recursivamente. Configuracion con pestañas. Incluye templates. Opcion de desactivar muestra de llaves en thank you page. Pestaña de migración (La migración aún pendiente)
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function new_config_menu() {
    //                  page_title            menu_title             capability      menu_slug       callback             icon_url              position  
    add_menu_page('WAOLM License Manager', 'WAOLM Site Settings', 'manage_options', 'waolm_config', 'wao_settings_page', 'dashicons-admin-network', 25);
}
// Hook para registrar el menú en el admin
add_action('admin_menu', 'new_config_menu');


function wao_settings_page_old(){
	$url="options.php";
	laspestanias();
	?>
	<form action="<?php echo $url;?>" method="post">
		<?php 
		settings_fields( '_waolm_options' ); //Llamamos a la seccion de configuracion definida con register_setting()
		?>
        <div id="tab-url" class="tab-content active">
			<?php do_settings_sections( 'waolm_fields' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-templates" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_template' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-migration" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_migrate' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
        <div id="tab-checkout" class="tab-content">
			<?php do_settings_sections( 'waolm_fields_checkout' ); //Mostramos la sección definida con add_settings_section ?>
		</div>
		<input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
		<hr>
	</form>
	<?php
	cerrarlaspestanias();
	elscript();
} // function wao_settings_page() END


function wao_settings_page(){
	$url="options.php";
	$tab = isset($_GET['tab'])?$_GET['tab']:'templates';
	laspestanias(); 
	?>
	<form action="<?php echo $url;?>" method="post">
		<?php 
		settings_fields( '_waolm_options' ); //Llamamos a la seccion de configuracion definida con register_setting()
		?>
        <div id="tab-templates" class="tab-content <?php echo $tab=='templates'?'nav-tab-active':'';  ?>">
			<?php if($tab=='templates'){do_settings_sections( 'waolm_fields_template' ); //En waolm-tests.php ?>
			<input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
			<?php 
			ultimo_metodo_de_pago();  
			} ?>
			
		</div>
        <div id="tab-test" class="tab-content <?php echo $tab=='test'?'nav-tab-active':'';  ?>">
			<?php echo '<br>'; ?>
			<?php if($tab=='test'){test_llaves();} //En waolm-tests.php ?>
		</div>
		<hr>
	</form>
	<?php
	cerrarlaspestanias();
	//elscript();
} // function wao_settings_page() END
//////REGISTRANDO LOS CAMPOS O VARIABLES EN LA BASE DE DATOS [PASO 1]
function waolm_register_settings() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Windows And Office License Manager Settings', 'waolm_section_text', 'waolm_fields' );
	// 								$id, 			           $title,                                              $callback, 				$page, 			$section 	$args = array()
	add_settings_field( 'waolm_setting_urlmanuals', 'URL raiz para el enlace a manual de usuario y descargas', 'waolm_setting_urlmanuals', 'waolm_fields', 'waolm1_settings' );
	add_settings_field( 'waolm_setting_external_server', 'URL de un servidor externo', 'waolm_setting_external_server', 'waolm_fields', 'waolm1_settings' );
	//add_settings_field( 'waolm_llavesquemadas', 'Activar verificacion de llaves quemadas', 'waolm_llavesquemadas', 'waolm_fields', 'waolm1_settings', array( 'class' => 'custom-background'));
    $waolm_options = get_option('_waolm_options');
    if(isset($waolm_options['llavesquemadas'])){
		add_settings_field( 'waolm_tolerancia', 'Tolerancia de llaves quemadas', 'waolm_tolerancia', 'waolm_fields', 'waolm1_settings', array( 'class' => 'custom-background') );
	}
	add_settings_field( 'waolm_setting_payments', 'Metodos de pago que se mostrar&aacute;n en la ThankYou Page', 'waolm_setting_payments', 'waolm_fields', 'waolm1_settings' );
	add_settings_field( 'waolm_new_to', '<b>Completed Email</b> con copia a:', 'waolm_new_to', 'waolm_fields', 'waolm1_settings' );

}
function waolm_register_settings_template() {

	recusivo_checkout_template();
	recusivo_email_template();
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Templates', 'waolm_section_text', 'waolm_fields_template' );
	// 								$id, 			           $title,                                              $callback, 				$page, 			$section 	$args = array()

	add_settings_field( 'waolm_setting_email_template', 'Template para email', 'waolm_setting_email_template', 'waolm_fields_template', 'waolm1_settings' );
	add_settings_field( 'waolm_setting_checkout_template', 'Template para checkout page', 'waolm_setting_checkout_template', 'waolm_fields_template', 'waolm1_settings' );

}
function waolm_register_settings_migrate() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título										  $funcion titulo		$página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Estado de la migración', 'waolm_section_text', 'waolm_fields_migrate' );
	// 								$id, 			     $title,                               $callback, 				       $page, 			       $section 	$args = array()
	add_settings_field( 'waolm_setting_migrate_status', 'Estado de la migración de despachos', 'waolm_setting_migrate_status', 'waolm_fields_migrate', 'waolm1_settings' );
	
}
function waolm_register_settings_checkout() {
	//					$option_group	  option_name			args  =  array()  )
	register_setting( '_waolm_options', '_waolm_options', '_waolm_options_validate' );
	// 							$id				$título					$funcion titulo		 $página			$argumentos  =  matriz()   
	add_settings_section( 'waolm1_settings', 'Checkout Page', 'waolm_section_text', 'waolm_fields_checkout' );
	// 								$id, 			  $title,                                   $callback, 				     $page, 			      $section 	$args = array()
	add_settings_field( 'waolm_setting_on_checkout', 'Dejar de mostrar llaves en checkout', 'waolm_setting_on_checkout', 'waolm_fields_checkout', 'waolm1_settings' );
	
}
add_action( 'admin_init', 'waolm_register_settings' );
add_action( 'admin_init', 'waolm_register_settings_template' );
add_action( 'admin_init', 'waolm_register_settings_migrate' );
add_action( 'admin_init', 'waolm_register_settings_checkout' );
/////VALIDACION
function _waolm_options_validate( $input ) {

  return $input;
}
/////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]
// TITULO PARA TODAS LAS PESTAÑAS
function waolm_section_text() {
  echo '<p>Configuracion de Parametros para WAO License Manager</p>';
}
// PESTAÑA GENERAL
function waolm_setting_urlmanuals() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_urlmanuals' name='_waolm_options[urlmanuals]' type='text' style='width:400px;' value='".esc_attr( $options['urlmanuals'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.)</i> ";
}
function waolm_setting_external_server() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_externalserver' name='_waolm_options[externalserver]' type='text' style='width:400px;'  value='".esc_attr( $options['externalserver'] )."' /><i style='margin-left:20px;'>(Incluir <b>https://</b> y un slash al final.) (Activar SOLO SI el servidor está en otra web. Caso contrario dejar en blanco)</i> ";
}
function waolm_tolerancia() {
    // Obtener la opción desde la base de datos
    $waolm_options = get_option('_waolm_options');
    // Asignar el valor de tolerancia (si no existe, se usa un valor por defecto)
    $tolerancia = isset($waolm_options['tolerancia']) ? $waolm_options['tolerancia'] : 5; // valor por defecto 5

    // Crear el input numérico con botones para incrementar y disminuir
    echo '<input type="number" id="waolm_tolerancia" name="_waolm_options[tolerancia]" value="' . esc_attr($tolerancia) . '" min="0" max="100" step="1">
	<i style="margin-left:20px;">(Nro de llaves repetidas que se tolera enviar al mismo cliente)</i>
    ';
}
function waolm_llavesquemadas(){
    $waolm_options = get_option('_waolm_options');
    $llavesquemadas = isset($waolm_options['llavesquemadas']) ? "checked" : ""; // valor por defecto 5
	echo '<input type="checkbox" id="waolm_llavesquemadas" name="_waolm_options[llavesquemadas]" '.$llavesquemadas.'>';
	echo '<i style="margin-left:20px;">(En cada orden nueva, verificar si el cliente ya recibio mismas llaves)</i>';
}
function waolm_setting_server(){ //siempre en multisite BORRAR
	if(is_multisite()){
		$waolm_server_id=get_waolm_server_id();
		switch_to_blog($waolm_server_id);
			$blog_name=get_option( 'blogname' );
		restore_current_blog();
		if(get_current_blog_id()==$waolm_server_id){
			$checked1="checked";
			$checked2="";
			$message = "";
		}else{
			$checked1="";
			$checked2="checked";
			$message="<span style='color:gray;font-size:12px;font-style: italic;'>(Servidor configurado es: <b>".$blog_name.")</b></span>";
		}
		echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="S" '.$checked1.'><label for="waolm_server_id">Si</label>&nbsp;&nbsp;&nbsp;'; 
			echo '<input type="radio" id="waolm_soy_servidor" name="_waolm_options[soy_servidor]" value="N" '.$checked2.'><label for="waolm_server_id">No</label>'; 
		echo "</span>&nbsp;&nbsp;".$message;
	}
}//fin de funcion waolm_setting_server
function waolm_setting_payments() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );
	$ultimo_metodo_de_pago = get_option('ultimo_metodo_de_pago');
	$default_payments = 'cod|ppec_paypal|ppcp|ppcp-gateway|stripe|stripe_googlepay|stripe_applepay|stripe_cc|amazon_payments_advanced|woosa_adyen_credit_card|woosa_adyen_googlepay|woosa_adyen_applepay|woosa_adyen_klarna|woosa_adyen_wechatpay|woosa_adyen_alipay|emerchantpay_checkout';

	if (!isset($options['payments']) || empty($options['payments'])) {
		$options['payments'] = $default_payments;
		// Actualizar la opción en la base de datos
		update_option('_waolm_options', $options);
		$options = get_option( '_waolm_options' );
	}

	echo "<textarea id='waolm_payments' name='_waolm_options[payments]' style='width:400px;height:70px;'>".esc_attr( $options['payments'] )."</textarea><i style='margin-left:20px;'>(Los m&eacute;todos de pago que se mostrar&aacute;n en la ThankYou Page)</i> ";
	echo "<p>Puede copiar varios de la siguiente lista deben estar separados por el caracter pipe (|)</p>";
	echo "<h5>".$default_payments."</h5>";
	echo "<h5>El &uacute;ltimo m&eacute;todo de pago utilizado fu&eacute;: <b>".$ultimo_metodo_de_pago."</b></h5>";
	
}
function waolm_new_to (){
  $options = get_option( '_waolm_options' );
  echo "<input id='waolm_newfrom' name='_waolm_options[new_to]' type='text' style='width:400px;'  value='".esc_attr( $options['new_to'] )."' /><i style='margin-left:20px;'>(Email Completed Order con copia a esta dirección de correo)</i> ".htmlspecialchars($depu);	
}

// PESTAÑA TEMPLATES
function recusivo_email_template(){
	if (isset($_POST['email_template_recursive']) && $_POST['email_template_recursive'] === 'on') { 
		if (is_multisite()) {
			global $wpdb;
			$current_blog_id = get_current_blog_id(); // Guardar el ID del sitio actual
			$new_template_value = isset($_POST['_waolm_options']['email_template']) ? wp_unslash($_POST['_waolm_options']['email_template']) : '';

			// Obtener todos los sitios del multisite
			$blogs = get_sites(['fields' => 'ids']);
			
			foreach ($blogs as $blog_id) {
				switch_to_blog($blog_id);
				
				// Obtener las opciones actuales
				$waolm_options = get_option('_waolm_options', []);
				if (!is_array($waolm_options)) {
					$waolm_options = [];
				}

				// Actualizar el valor de checkout_template
				$waolm_options['email_template'] = $new_template_value;
				update_option('_waolm_options', $waolm_options);
			}

			// Volver al sitio original
			switch_to_blog($current_blog_id);
		}
	}
}
function waolm_setting_email_template() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );

	echo "<textarea id='waolm_email_template' name='_waolm_options[email_template]' style='width:50%;height:70px;'>".esc_attr( $options['email_template'] )."</textarea><i style='margin-left:20px;'>(Esto se adjunta a Completed email)</i> ";
	//echo "<br>&nbsp;&nbsp;&nbsp;&nbsp;Recursivo para todos los sitios:<input type='checkbox' name='email_template_recursive' id='email_template_recursive' >";

}
function recusivo_checkout_template(){
	if (isset($_POST['checkout_template_recursive']) && $_POST['checkout_template_recursive'] === 'on') { 
		if (is_multisite()) {
			global $wpdb;
			$current_blog_id = get_current_blog_id(); // Guardar el ID del sitio actual
			$new_template_value = isset($_POST['_waolm_options']['checkout_template']) ? wp_unslash($_POST['_waolm_options']['checkout_template']) : '';

			// Obtener todos los sitios del multisite
			$blogs = get_sites(['fields' => 'ids']);
			
			foreach ($blogs as $blog_id) {
				switch_to_blog($blog_id);
				
				// Obtener las opciones actuales
				$waolm_options = get_option('_waolm_options', []);
				if (!is_array($waolm_options)) {
					$waolm_options = [];
				}

				// Actualizar el valor de checkout_template
				$waolm_options['checkout_template'] = $new_template_value;
				update_option('_waolm_options', $waolm_options);
			}

			// Volver al sitio original
			switch_to_blog($current_blog_id);
		}
	}
}
function waolm_setting_checkout_template() { // los metodos de pago que se mostrarán en la thankyou page
	$options = get_option( '_waolm_options' );

	echo "<textarea id='waolm_checkout_template' name='_waolm_options[checkout_template]' style='width:50%;height:70px;'>".esc_attr( $options['checkout_template'] )."</textarea><i style='margin-left:20px;'>(Esto se muestra en la checkout page si activado)</i> ";
	//echo "<br>&nbsp;&nbsp;&nbsp;&nbsp;Recursivo para todos los sitios:<input type='checkbox' name='checkout_template_recursive' id='checkout_template_recursive' >";
}
function ultimo_metodo_de_pago() { // los metodos de pago que se mostrarán en la thankyou page
	$ultimo_metodo_de_pago = get_option('ultimo_metodo_de_pago');
	echo "<h5>El &uacute;ltimo m&eacute;todo de pago utilizado fu&eacute;: <b style='border:solid 1px gray;border-radius:3px;background-color:#e7e7e7;padding:3px;'>".$ultimo_metodo_de_pago."</b></h5>";
}

// PESTAÑA MIGRACION
function waolm_setting_migrate_status() {
    global $wpdb;
	$options = get_option( '_waolm_options' );
	$checked = isset($options['purgar_keys'])&&$options['purgar_keys']=='on'?'checked':'';
    
    // Obtener la cantidad de registros con la meta_key '_keys'
    $q = "SELECT COUNT(meta_value) FROM {$wpdb->postmeta} WHERE meta_key = '_keys'";
    $_keys = $wpdb->get_var($q);

    $q = "SELECT COUNT(meta_value) FROM {$wpdb->postmeta} WHERE meta_key = '_key_migrated'";
    $_keys_migrated = $wpdb->get_var($q);

	$sid = is_multisite()?get_current_blog_id():1;

    $q = "SELECT COUNT(ID) FROM wp_waolm_dispatched_keys WHERE site_id = {$sid}";
    $_keys_in_new_table = $wpdb->get_var($q);
	
    // Plantilla corregida con correcta asignación de variables
    $template = "<div style='border:solid 1px gray;padding:5px;border-radius:3px;background-color:#fcfefd;width:49%;'>
				<ul>
                    <li>Cantidad total de _keys: {$_keys}</li>
                    <li>Cantidad de _keys procesadas: {$_keys_migrated}</li>
                    <li>Cantidad de _keys en nueva tabla: {$_keys_in_new_table}</li>
                 </ul><hr>
				 <label for='purgar_keys'>Eliminar _keys de la tabla ordenes cuando completado.</label>
				 <input type='checkbox' {$checked} name='_waolm_options[purgar_keys]'><br>
				 <label for='forzar_keys'>Forzar la migraci&oacute;n. (Migrar al salvar)</label>
				 <input type='checkbox' ><br>
				 </div>";

    echo $template;
}

// PESTAÑA CHECKOUT PAGE
function waolm_setting_on_checkout() {
    $options = get_option('_waolm_options');
	$checked = $options['checkout_show_keys']=='on'?'checked':'';
    $template = "<input type='checkbox' id='waolm_checkout_show_keys' name='_waolm_options[checkout_show_keys]' {$checked}><label for='checkout_link'>Desactivar mostrar llaves en página checkout</label>";
    echo $template;
}

function waolm_url($url){ //esto ya hace lo que debe
	$url=str_replace('http://','',$url);
	$url=str_replace('https://','',$url);
	$url="https://".$url;
	if(substr($url, -1)<>'/'){
		$url=$url."/";
	}
	return $url;
}

function laspestanias(){
	$tab = isset($_GET['tab'])?$_GET['tab']:'templates';
?>	
    <div class="wrap">
        <h1>Configuración de Despacho automatico</h1>
        <h2 class="nav-tab-wrapper">
            <a href="?page=waolm_config&tab=templates" class="nav-tab <?php echo $tab=='templates'?'nav-tab-active':''; ?>" data-tab="tab-templates">Templates</a>
            <a href="?page=waolm_config&tab=test" class="nav-tab <?php echo $tab=='test'?'nav-tab-active':''; ?>" data-tab="tab-test">Test</a>
        </h2>
<?php }// fin pestañas
function laspestanias_old(){
?>	
    <div class="wrap">
        <h1>Configuración de Despacho automatico</h1>
        <h2 class="nav-tab-wrapper">
            <a href="#tab-url" class="nav-tab nav-tab-active" data-tab="tab-url">General</a>
            <a href="#tab-templates" class="nav-tab" data-tab="tab-templates">Templates</a>
            <a href="#tab-migration" class="nav-tab" data-tab="tab-migration">Migracion</a>
            <a href="#tab-checkout" class="nav-tab" data-tab="tab-checkout">Checkout page</a>
            <!--<a href="#tab-translations" class="nav-tab" data-tab="tab-translations">Traducciones</a>-->
        </h2>
<?php }// fin pestañas
function cerrarlaspestanias(){
	echo "</div>";
}
function elscript(){
	?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tabs = document.querySelectorAll('.nav-tab');
            var tabContents = document.querySelectorAll('.tab-content');
            var addTranslationRowButton = document.getElementById('add-translation-row');
            var addUrlRowButton = document.getElementById('add-url-row');
            var translationsTableBody = document.querySelector('#translations-table tbody');
            var urlsTableBody = document.querySelector('#urls-table tbody');

            tabs.forEach(function(tab) {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    tabs.forEach(function(t) { t.classList.remove('nav-tab-active'); });
                    tabContents.forEach(function(tc) { tc.classList.remove('active'); });

                    tab.classList.add('nav-tab-active');
                    document.querySelector(tab.getAttribute('href')).classList.add('active');
                });
            });

            addTranslationRowButton.addEventListener('click', function() {
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="translations_lang[]" /></td>
                    <td><input type="text" name="translations_key[]" /></td>
                    <td><input type="text" name="translations_value[]" /></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;
                translationsTableBody.appendChild(newRow);

                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });

            addUrlRowButton.addEventListener('click', function() {
				var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td><input type="text" name="met_pago[]" /></td>
                    <td><input type="text" name="url[]" /></td>
                    <td><button type="button" class="button remove-row">-</button></td>
                `;

                urlsTableBody.appendChild(newRow);
                var removeRowButtons = document.querySelectorAll('.remove-row');
                removeRowButtons.forEach(function(button) {
                    button.addEventListener('click', function() {
                        button.closest('tr').remove();
                    });
                });
            });


            var removeRowButtons = document.querySelectorAll('.remove-row');
            removeRowButtons.forEach(function(button) {
                button.addEventListener('click', function() {
                    button.closest('tr').remove();
                });
            });
        });
    </script>
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
 
<?php
 }// fin funcion elscript


