<?php 
/*
 * Consultas a las nuevas tablas y vista
 * vista: licensemanagerwao_view (lista de llaves desde wp_posts)(podría convertirse en tabla para proxima version)
 * tablas normalizadas:
 * - wp_waolm_rel_orders
 * - wp_waolm_rel_orders_keys
*/
defined( 'ABSPATH' ) or die; 
// APIS PARA DEVOLVER INFORMACION COMO SERVIDOR 
function waolm_register_license_manager_api() {
    register_rest_route('wao-license/v1', '/cuantas-llaves/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_cuantas_llaves_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/las-llaves/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_las_llaves_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/descontar-activaciones', array(
        'methods'  => 'GET',
        'callback' => 'waolm_descontar_activaciones',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/incrementar-despachados', array(
        'methods'  => 'GET',
        'callback' => 'waolm_incrementar_despachos',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/llaves-por-sku/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_llaves_por_sku_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/givemecomboproducts', array(
        'methods'  => 'GET',
        'callback' => 'waolm_products_with_ad_for_combo',
        'permission_callback' => '__return_true',
    ));

}

function waolm_validate_api_key($request) {
    $provided_key = sanitize_text_field($request->get_param('waolm_api_key'));
    // Obtener la API Key almacenada en el servidor
	$stored_key = get_waolm_server_option('waolm_server_api_key');
    if (empty($provided_key) || $provided_key !== $stored_key) {
		//echo '<div class="notice notice-error">Fallo en la autenticacion de API de despacho automatico!.</div>'; 
		return new WP_Error('api_auth_failed', 'Fallo en la autenticacion de API de despacho automatico!', ['status' => 401]);
    }
    return true;
}

add_action('rest_api_init', 'waolm_register_license_manager_api');

////////////////////////////
// DESCONTAR ACTIVACIONES //
////////////////////////////

function descontar_activaciones($key_id, $cuantas = 1){ // programar aqui
	return is_external_server_on()?json_decode(descontar_activaciones_api($key_id,$cuantas)):descontar_activaciones_bd($key_id,$cuantas);
}

function descontar_activaciones_bd($key_id, $cuantas = 1) {
    global $wpdb;
    // Obtener el valor actual de _activations

	if (paso1_concluido()){ // tabla creada y llaves migradas
		$activations = $wpdb->get_var($wpdb->prepare(
			"SELECT activations FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE id = %d",
			$key_id
		));
		// Convertir a número y descontar
		$activations = max(0, (int) $activations - (int) $cuantas);

		// Actualizar el valor en la base de datos
		$updated = $wpdb->update(
			"{$wpdb->base_prefix}waolicensemanager_keys",
			['activations' => $activations],
			['id' => $key_id],
			['%d'],
			['%d']
		);
	}else{ // obtener de CPT 
		$activations = $wpdb->get_var($wpdb->prepare(
			"SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_activations'",
			$key_id
		));
		// Convertir a número y descontar
		$activations = max(0, (int) $activations - (int) $cuantas);

		// Actualizar el valor en la base de datos
		$updated = $wpdb->update(
			"{$wpdb->prefix}postmeta",
			['meta_value' => $activations],
			['post_id' => $key_id, 'meta_key' => '_activations'],
			['%d'],
			['%d', '%s']
		);
	}

    return $updated !== false; // Devuelve true si la actualización fue exitosa
}

function descontar_activaciones_api($key_id, $cuantas = 1){ // programar aqui
	$url = external_server();
	$api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/descontar-activaciones?waolm_api_key='.$api_client.'&key_id='.$key_id.'&cuantas='.$cuantas;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);
	//echo $api_url."<br><br>";
    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);

    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return 1; // Devuelve 1 si exito
}

function waolm_descontar_activaciones($request) { // crear esquema de 4 funciones

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return $auth;

    $key_id = intval($request->get_param('key_id'));
    $cuantas = intval($request->get_param('cuantas'));

    if ($key_id <= 0 || $cuantas <= 0) {
        return new WP_Error('invalid_data', 'Datos inválidos', ['status' => 400]);
    }

    $success = json_encode(descontar_activaciones_bd($key_id, $cuantas));

    return rest_ensure_response($success);
}

///////////////////////////
// INCREMENTAR DESPACHOS //
///////////////////////////

function incrementar_despachados($key_id, $cuantas = 1) { // programar aqui
	return is_external_server_on()?json_decode(incrementar_despachados_api($key_id,$cuantas)):incrementar_despachados_bd($key_id,$cuantas);
}

function incrementar_despachados_bd($key_id, $cuantas = 1) {
    global $wpdb;
	// Dado el key_id, sumar $cuantas al metadato _dispatched 
    // Obtener el valor actual de _dispatched
	if (paso1_concluido()){ // tabla creada y llaves migradas
		$dispatched = $wpdb->get_var($wpdb->prepare(
			"SELECT dispatched FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE id = %d",
			$key_id
		));

		// Convertir a número y sumar
		//$dispatched = (int) $dispatched + (int) $cuantas;
		$dispatched = max(0, (int) $dispatched + (int) $cuantas);
		// Actualizar el valor en la base de datos
		$updated = $wpdb->update(
			"{$wpdb->base_prefix}waolicensemanager_keys",
			['dispatched' => $dispatched],
			['id' => $key_id],
			['%d'],
			['%d']
		);
		$updated = $wpdb->update(
			"{$wpdb->base_prefix}waolicensemanager_keys",
			['dispatched' => $dispatched],
			['id' => $key_id],
			['%d'],
			['%d']
		);
		
	}else{ // obtener de CPT 
		$dispatched = $wpdb->get_var($wpdb->prepare(
			"SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_dispatched'",
			$key_id
		));

		// Convertir a número y sumar
		$dispatched = (int) $dispatched + (int) $cuantas;

		// Actualizar el valor en la base de datos
		$updated = $wpdb->update(
			"{$wpdb->prefix}postmeta",
			['meta_value' => $dispatched],
			['post_id' => $key_id, 'meta_key' => '_dispatched'],
			['%d'],
			['%d', '%s']
		);
	}
    return $updated !== false; // Devuelve true si la actualización fue exitosa
}

function incrementar_despachados_api($key_id, $cuantas = 1) { // programar aqui
	$url = external_server();
	$api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/incrementar-despachados?waolm_api_key='.$api_client.'&key_id='.$key_id.'&cuantas='.$cuantas;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);
    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);

    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return 1; // Devuelve 1 si exito
}

function waolm_incrementar_despachos($request) { // crear esquema de 4 funciones

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return $auth;

    $key_id = intval($request->get_param('key_id'));
    $cuantas = intval($request->get_param('cuantas'));

    if ($key_id <= 0 || $cuantas <= 0) {
        return new WP_Error('invalid_data', 'Datos inválidos', ['status' => 400]);
    }

    $success = json_encode(incrementar_despachados_bd($key_id, $cuantas));

    return rest_ensure_response($success);
}

////////////////////////
// LAS LLAVES POR SKU //
////////////////////////

function llaves_por_sku($sku){
	return is_external_server_on()?json_decode(llaves_por_sku_api($sku)):llaves_por_sku_bd($sku);
}

function llaves_por_sku_bd($product_sku){ // consulta sobre view licensemanagerwao_view. 
	global $wpdb;

	if (paso1_concluido()){
		$q="SELECT * from {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = '{$product_sku}' ORDER BY priority ";	
	}else{
		$q="SELECT * from {$wpdb->base_prefix}licensemanagerwao_view WHERE waolm_sku = '{$product_sku}' ORDER BY priority ";	
	}
	$r = $wpdb->get_results($q);	  
	return $r;
}//function END

function llaves_por_sku_api($sku = 'O10PP') {
	$url = external_server();
	$api_client = external_server_api();
    //$api_url = $url.'wp-json/wao-license/v1/llaves-por-sku?sku='.$sku.'&waolm_api_key='.$api_client;
	$api_url = $url.'wp-json/wao-license/v1/llaves-por-sku/'.$sku.'?waolm_api_key='.$api_client;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; // 'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_llaves_por_sku_api($request){
    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;

    $sku = $request->get_param('sku');
    $llaves = json_encode(llaves_por_sku_bd($sku));

    return rest_ensure_response($llaves);	
}

////////////////////////////////
// PRODUCTS WITH AD FOR COMBO //
////////////////////////////////

function products_with_ad_for_combo(){
	return products_with_ad_for_combo_bd();
}

function products_with_ad_for_combo_bd(){
	global $wpdb;
	$q="SELECT p.ID, p.post_title
		FROM {$wpdb->prefix}posts p
		INNER JOIN {$wpdb->prefix}postmeta m1 ON p.ID = m1.post_id AND m1.meta_key = '_autodispatch_option' AND m1.meta_value = 'yes'
		INNER JOIN {$wpdb->prefix}postmeta m2 ON p.ID = m2.post_id AND m2.meta_key = '_combos_option' AND m2.meta_value = 'One'
		WHERE p.post_type = 'product'
		  AND p.post_status = 'publish'
		ORDER BY p.ID";
	$resultados=$wpdb->get_results($q);
	$retorno=array();
	$i=0;
	foreach ($resultados as $res){
		$fila[$i] = new stdClass();
		$fila[$i]->sku = get_post_meta($res->ID,'_sku',true);
		$fila[$i]->post_title = $res->post_title;
		$retorno[]=$fila[$i++];
	}
// Usar usort para ordenar el array
	usort($retorno, 'compararPorNombre');
	return $retorno;
}

////////////////
// LAS LLAVES // 
////////////////

function las_llaves($sku,$forxpcs){
	$llaves = is_external_server_on()?json_decode(las_llaves_api($sku, $forxpcs)):las_llaves_bd($sku, $forxpcs);
	return $llaves;
}

function las_llaves_bd($sku,$forxpcs){ // consulta sobre view licensemanagerwao_view. 
	global $wpdb;
	if (paso1_concluido()){ 
		$q = $wpdb->prepare("SELECT * from {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = '%s' AND activations > %d ORDER BY priority ", $sku, $forxpcs);	
	}else{
		$q = $wpdb->prepare("SELECT nro, license_id as id, _key as skey, product, product_name, activations, dispatched, priority, waolm_sku from {$wpdb->base_prefix}licensemanagerwao_view WHERE waolm_sku = '%s' AND activations > %d ORDER BY priority ", $sku, $forxpcs);	
	}
	$r = $wpdb->get_results($q);	  
	return $r;
}//function END

function las_llaves_api($sku = 'O10PP', $forxpcs) {
	$url = external_server();
    $api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/las-llaves/'.$sku.'?waolm_api_key='.$api_client.'&forxpcs='.$forxpcs;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API (funcion las_llaves_api).';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { 
        return 0; // client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_las_llaves_api($request) {

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;
    $sku = $request->get_param('sku');
    $forxpcs = sanitize_text_field($request->get_param('forxpcs'));
    $llaves = json_encode(las_llaves_bd($sku,$forxpcs));

    //return rest_ensure_response(['sku' => $sku, 'llaves' => $llaves]);
    return rest_ensure_response($llaves);
}


////////////////////
// CUANTAS LLAVES //
////////////////////

function cuantas_llaves($sku,$forxpcs){
	return is_external_server_on()?json_decode(cuantas_llaves_api($sku, $forxpcs)):cuantas_llaves_bd($sku, $forxpcs);
}

function cuantas_llaves_bd($sku, $forxpcs) {
    global $wpdb;
    // Consulta para contar cuántas llaves hay para un SKU específico 
	// Desde la view licensemanagerwao_view
	if (paso1_concluido()){
		$cantidad = $wpdb->get_var($wpdb->prepare(
			"SELECT COUNT(*) FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = %s AND activations > %d",
			$sku, $forxpcs
		));
	}else{
		$cantidad = $wpdb->get_var($wpdb->prepare(
			"SELECT COUNT(*) FROM {$wpdb->base_prefix}licensemanagerwao_view WHERE waolm_sku = %s AND activations > %d",
			$sku, $forxpcs
		));
	}
    return (int) $cantidad; // Devolver como entero
}

function cuantas_llaves_api($sku = 'O10PP',$forxpcs) {
	$url = external_server();
    $api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/cuantas-llaves/'.$sku.'?waolm_api_key='.$api_client.'&forxpcs='.$forxpcs; 
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API. (funcion cuantas_llaves_api)';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { // si la client_api_key no autentica
        return $body;
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_cuantas_llaves_api($request) {
    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;
    $sku = sanitize_text_field($request['sku']);
    $forxpcs = sanitize_text_field($request->get_param('forxpcs'));
    $cantidad = json_encode(cuantas_llaves_bd($sku,$forxpcs));
	return $cantidad;
    //return rest_ensure_response(['sku' => $sku, 'cantidad' => $cantidad]);
}


/////////////////////////////////////////////////////////////////////
// FUNCIONES GENERICAS PARA CONSULTA DE CONFIGURACIONES DE SERVIDOR//
/////////////////////////////////////////////////////////////////////
function get_waolm_option($key, $default="xxx"){
	$waolm_option = get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_waolm_server_option($key, $default="xxx"){
	//$waolm_option = get_option('_waolm_server_options');
	$waolm_option = is_multisite()?get_blog_option(1,'_waolm_server_options'):get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_waolm_client_option($key, $default="xxx"){
	$waolm_option = is_multisite()?get_blog_option(1,'_waolm_client_options'):get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_smart_waolm_client_option($key, $return="xxx"){
	if(is_multisite()){
		$waolm_option = get_option('_waolm_options');
		if(isset($waolm_option[$key])&&$waolm_option[$key]<>""){
			
		}else{
			$waolm_option = get_blog_option(1,'_waolm_client_options');
		}
	}else{
		$waolm_option = get_option('_waolm_options');
	}
	if(isset($waolm_option[$key])){
		$return = $waolm_option[$key];
	}
	return $return;
}

function is_external_server_on(){
	$is = get_waolm_client_option('external_server_on');
	return $is=='on'?true:false;
}

function external_server(){
	return get_waolm_client_option('externalserver');
}

function external_server_api(){
	return get_waolm_client_option('api_client','');
}

// Ordenar el array
function compararPorNombre($a, $b) {
    return strcmp($a->post_title, $b->post_title);
}

function mostrar_error($e){
	switch ($e){
		case 0: 
			$msg ="Error de autenticacion api servidor.";
			break;
		case -1: 
			$msg ="Error al obtener datos de la API.";
			break;
		case -2: 
			$msg ="No se encontraron llaves para el sku dato.";
			break;
		default:
			$msg ="Error no especificado";
	}
	return $e;
}

/////////////////////////////////////////////////////////////////////////////
// FUNCIONES PARA CONSULTAS EN LOCAL SOBRE wp_waolm_dispatched_keys (LOCAL)//
/////////////////////////////////////////////////////////////////////////////

function get_client_keys_by_order_id_site($order_id,$site_id){ // para sus llaves en edit order
	global $wpdb;

	if (paso2_concluido()){

		$q = $wpdb->prepare(
			"SELECT K.id, K.sku, K.product_name, O.customer_email, O.order_id, K.key, O.date, O.site_id, O.site_url
			 FROM {$wpdb->base_prefix}waolm_rel_orders O
			 LEFT JOIN {$wpdb->base_prefix}waolm_rel_orders_keys K ON O.ID = K.rel_order_id
			 WHERE O.order_id = %d AND O.site_id = %d",
			$order_id,
			$site_id
		);
		$res = $wpdb->get_results($q);
		return $res;
	}else{
		// obtener como antes nomas :)
		$res = get_client_keys_metadata($order_id,$site_id);
		return $res;
	}
}

function get_client_keys_metadata($order_id, $site_id) { //Cuando no se ha iniciado la migración
    $result = [];

    $keys_meta = get_post_meta($order_id, '_keys', true);
    if (!is_array($keys_meta)) {
        return $result;
    }

    $order = wc_get_order($order_id);
    $customer_email = $order ? $order->get_billing_email() : '';
    $date = $order && $order->get_date_created() ? $order->get_date_created()->format('Y-m-d H:i:s') : '';
    $site_url = get_site_url($site_id);

    foreach ($keys_meta as $subarray) {
        if (!is_array($subarray)) continue;

        foreach ($subarray as $obj) {
            if (!is_object($obj)) continue;

            $o = new stdClass();
            $o->sku            = $obj->waolm_sku ?? '';
            $o->product_name   = $obj->productname ?? '';
            $o->customer_email = $customer_email;
            $o->order_id       = $order_id;
            $o->key            = $obj->_key ?? $obj->skey ?? '';
            $o->date           = $date;
            $o->site_id        = $site_id;
            $o->site_url       = $site_url;

            $result[] = $o;
        }
    }

    return $result;
}


// obtener todas las llaves que compró este cliente.
function get_keys_purchased_by_email($customer_email) {
	// Obtener todas las llaves que compró $customer_email
    global $wpdb;
    // Preparar la consulta de manera segura
	if (paso2_concluido()){
		$query = $wpdb->prepare("SELECT K.id, K.sku, K.product_name, O.customer_email, O.order_id, K.key, O.date, O.site_id, O.site_url
			  FROM {$wpdb->base_prefix}waolm_rel_orders O
			  LEFT JOIN {$wpdb->base_prefix}waolm_rel_orders_keys K ON O.ID = K.rel_order_id 
			  WHERE O.customer_email = %s
			  AND O.sended = 1", 
			$customer_email 
		);
		$results = $wpdb->get_results($query);
	}else{
		$results = get_keys_purchased_by_email_metadata($customer_email);
	}

   // Ejecutar la consulta y obtener los resultados
    // Array para almacenar los resultados finales
    $response = array();
    // Verificar si se encontraron resultados
    if ( !empty($results) ) {
        foreach ( $results as $row ) {
            // Mapear los resultados a un formato de array específico
			if(is_multisite()){
				$order_site = get_site($row->site_id);
				if ($order_site) {
					$site_url = get_site_url($row->site_id);
				} else {
					$site_url = get_option('home');
				}
			}else{
				$site_url = get_option('home');
			}
            $response[] = array(
                'Fecha'    => date('Y-m-d', strtotime($row->date)),     // Columna 'date' de la base de datos
                'Producto' => $row->product_name, // Columna 'product_name' de la base de datos
                'Llave'    => $row->key,          // Columna 'key' de la base de datos
                'Orden'    => $row->order_id,     // Columna 'order_id' de la base de datos
                'Sku'      => $row->sku,           // Columna 'sku' de la base de datos
                'Site'     => $row->site_id,       // Columna 'site_id' de la base de datos
                'Siteurl'  => $row->site_url   		// Construido a partir de site_id
            );
        }
    } else {
        // Manejo del caso en que no se encuentren resultados
        //echo 'No se encontraron resultados para el correo electrónico y la clave proporcionados.';
    }
    // Devolver el array de respuesta
    return $response;
}

function get_keys_purchased_by_email_metadata($email) {//Cuando no se ha iniciado la migración
    global $wpdb;

    $results = [];

    // Detectar si es multisite
    $is_multisite = is_multisite();
    $site_ids = [];

    if ($is_multisite) {
        $site_ids = get_sites(['fields' => 'ids']);
    } else {
        $site_ids = [1]; // Solo sitio principal
    }

    foreach ($site_ids as $site_id) {
        if ($is_multisite) {
            switch_to_blog($site_id);
        }

        // 2. Buscar en pedidos antiguos (modelo con _keys)
        $args = [
            'limit'    => -1,
            'customer' => $email,
            'return'   => 'ids',
            'status'   => array_keys(wc_get_order_statuses()),
        ];

        $orders = wc_get_orders($args);

        foreach ($orders as $order_id) {
            $keys_meta = get_post_meta($order_id, '_keys', true);

            if (!is_array($keys_meta)) continue;

            $order = wc_get_order($order_id);
            if (!$order) continue;

            $date = $order->get_date_created() ? $order->get_date_created()->format('Y-m-d H:i:s') : '';
            $site_url = get_site_url($site_id);

            foreach ($keys_meta as $subarray) {
                if (!is_array($subarray)) continue;

                foreach ($subarray as $obj) {

                    /*$o['order_id']       = $order_id;
                    $o['site_id']        = $site_id;
                    $o['sku']            = $obj->waolm_sku ?? '';
                    $o['product_name']   = $obj->productname ?? '';
                    $o['key']            = $obj->_key ?? '';
                    $o['date']           = $date;
                    $o['customer_email'] = $email;
                    $o['site_url']       = $site_url;
                    $o['priority']       = $obj->priority ?? 0;*/


                    if (!is_object($obj)) continue;

                    $o = new stdClass();
                    $o->order_id       = $order_id;
                    $o->site_id        = $site_id;
                    $o->sku            = $obj->waolm_sku ?? $obj->product_sku ?? '';
                    $o->product_name   = $obj->productname ?? '';
                    $o->key            = $obj->_key ?? $obj->skey ?? '';
                    $o->date           = $date;
                    $o->customer_email = $email;
                    $o->site_url       = $site_url;
                    $o->priority       = $obj->priority ?? 0;

                    $results[] = $o;
                }
            }
        }

        if ($is_multisite) {
            restore_current_blog();
        }
    }

    return $results;
}

// 
function email_vs_key($customer_email, $sku) {
	// Evaluar si $customer_email ya compro una $vkey
	if(paso1_concluido()){
		global $wpdb;
		// Preparar la consulta de manera segura
		$query = $wpdb->prepare(
			"SELECT `key` AS skey FROM {$wpdb->base_prefix}waolm_dispatched_keys WHERE customer_email = %s AND `sku` = %s", 
			$customer_email, 
			$sku
		);
		$retorno = $wpdb->get_col($query);
	}else{
		$retorno = email_vs_key_metadata($customer_email, $sku);
	}
    return $retorno;
}

function email_vs_key_metadata($customer_email, $sku) {
    global $wpdb;

    $skeys = [];

    $site_ids = is_multisite() ? get_sites(['fields' => 'ids']) : [1];

    foreach ($site_ids as $site_id) {
        switch_to_blog($site_id);

        $orders = $wpdb->get_col("
            SELECT ID FROM {$wpdb->posts}
            WHERE post_type = 'shop_order'
            AND post_status IN ('wc-completed','wc-processing','wc-on-hold')
        ");

        foreach ($orders as $order_id) {
            $order = wc_get_order($order_id);
            if (!$order) continue;

            if (strtolower($order->get_billing_email()) !== strtolower($customer_email)) {
                continue;
            }

            $keys_meta = get_post_meta($order_id, '_keys', true);
            if (!is_array($keys_meta)) continue;

            foreach ($keys_meta as $key_obj) {
                if (
                    is_object($key_obj) &&
                    isset($key_obj->product_sku, $key_obj->skey) &&
                    $key_obj->product_sku === $sku
                ) {
                    $skeys[] = $key_obj->skey;
                }
            }
        }

        restore_current_blog();
    }

    return $skeys;
}

// Adaptado para guardar todo en tabla centralizada (site=1)
// Llamado desde waolm-insert-keys-on-customer-email.php 207 271
function update_table_waolm_dispatched_keys($envio,$customer_email,$order_id) {
	if(!tabla_wp_waolm_dispatched_keys_creada()){
		return true;
	}
    global $wpdb;
	$order = wc_get_order( $order_id );
    $table_name = $wpdb->base_prefix.'waolm_dispatched_keys';//la tabla reside en site_id=1
	$site_url = get_option('home');;
    if ($envio) {
		foreach ($envio as $grupo){// cada producto
			foreach ($grupo as $key_data) {// cada unidad de producto 
				inserta_llaves_en_tabla($key_data,$order_id,$customer_email); // objeto llave
			}
		}
	}
}

function inserta_llaves_en_tabla($key_object, $order_id, $customer_email){
	global $wpdb;

	$order = wc_get_order( $order_id );
    $table_name = "{$wpdb->base_prefix}waolm_dispatched_keys";//la tabla reside en site_id=1
	$site_url = get_option('home');;

	//$sku = $key_object->product_sku;
	$sku = sanitize_text_field( ($key_object->product_sku ?? '') ?: ($key_object->waolm_sku ?? '') );
	$product_name = $key_object->productname;
	//$key = $key_object->skey;
	$key = sanitize_text_field( ($key_object->skey ?? '') ?: ($key_object->_key ?? '') );
	$date = $order->get_date_created()->format('Y-m-d');
	$site_id = is_multisite()?get_current_blog_id():1; // En un entorno multisite de WordPress

	if (true) {
		// Si no existe, inserta un nuevo registro
		$result = $wpdb->insert(
			$table_name,
			array(
				'sku' => $sku,
				'product_name' => $product_name,
				'customer_email' => $customer_email,
				'order_id' => $order_id,
				'key' => $key,
				'date' => $date,
				'site_id' => $site_id,
				'site_url' => $site_url
			),
			array(
				'%s', // sku
				'%s', // product_name
				'%s', // customer_email
				'%d', // order_id
				'%s', // key
				'%s', // date
				'%d', // site_id
				'%s'  // site_url
			)
		);
	} else {
		// Si existe, actualiza el registro existente
		$wpdb->update(
			$table_name,
			array(
				'product_name' => $product_name, // Actualiza solo los campos necesarios
				'key' => $key,
				'date' => $date,
				'site_id' => $site_id,
				'site_url' => $site_url
				),
			array(
				'sku' => $sku,
				'customer_email' => $customer_email,
				'order_id' => $order_id
				),
			array(
				'%s', // product_name
				'%s', // key
				'%s', // date
				'%d', // site_id
				'%s'  // site_url
				),
			array(
				'%s', // sku
				'%s', // customer_email
				'%d'  // order_id
				)
		);
	}
	
}

function llaves_entregadas($order_id) {
	// solo por compatibilidad al ser llamado por waolm-insert-keys-on-customer-email.php
    return true;
}
