<?php 
/*
 * Consultas a las nuevas tablas
 * vista que ya no se usa: licensemanagerwao_view
 * tabla de llaves: wp_waolicensemanager_keys
 * tabla de despachos que ya no se usa: wp_waolm_dispatched_keys
 * tablas normalizadas:
 * - wp_waolm_rel_orders
 * - wp_waolm_rel_orders_keys
*/
defined( 'ABSPATH' ) or die; 

// APIS PARA DEVOLVER INFORMACION COMO SERVIDOR 

function waolm_register_license_manager_api() {
    register_rest_route('wao-license/v1', '/cuantas-llaves/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_cuantas_llaves_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/las-llaves/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_las_llaves_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/descontar-activaciones', array(
        'methods'  => 'GET',
        'callback' => 'waolm_descontar_activaciones',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/incrementar-despachados', array(
        'methods'  => 'GET',
        'callback' => 'waolm_incrementar_despachos',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/llaves-por-sku/(?P<sku>[\w-]+)', array(
        'methods'  => 'GET',
        'callback' => 'waolm_llaves_por_sku_api',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('wao-license/v1', '/givemecomboproducts', array(
        'methods'  => 'GET',
        'callback' => 'waolm_products_with_ad_for_combo',
        'permission_callback' => '__return_true',
    ));

}

function waolm_validate_api_key($request) {
    $provided_key = sanitize_text_field($request->get_param('waolm_api_key'));
    // Obtener la API Key almacenada en el servidor
	$stored_key = get_waolm_server_option('waolm_server_api_key');
    if (empty($provided_key) || $provided_key !== $stored_key) {
		//echo '<div class="notice notice-error">Fallo en la autenticacion de API de despacho automatico!.</div>'; 
		return new WP_Error('api_auth_failed', 'Fallo en la autenticacion de API de despacho automatico!', ['status' => 401]);
    }
    return true;
}

add_action('rest_api_init', 'waolm_register_license_manager_api');

////////////////////////////
// DESCONTAR ACTIVACIONES //
////////////////////////////

function descontar_activaciones($key_id, $cuantas = 1){ // programar aqui
	return is_external_server_on()?json_decode(descontar_activaciones_api($key_id,$cuantas)):descontar_activaciones_bd($key_id,$cuantas);
}

function descontar_activaciones_bd($key_id, $cuantas = 1) {
    global $wpdb;
    // Obtener el valor actual de _activations
    $activations = $wpdb->get_var($wpdb->prepare(
        "SELECT activations FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE id = %d ",
        $key_id
    ));
    // Convertir a número y descontar
    $activations = max(0, (int) $activations - (int) $cuantas);

    // Actualizar el valor en la base de datos
    $updated = $wpdb->update(
        "{$wpdb->base_prefix}waolicensemanager_keys",
        ['activations' => $activations],
        ['id' => $key_id],
        ['%d'],
        ['%d']
    );

    return $updated !== false; // Devuelve true si la actualización fue exitosa
}

function descontar_activaciones_api($key_id, $cuantas = 1){ // programar aqui
	$url = external_server();
	$api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/descontar-activaciones?waolm_api_key='.$api_client.'&key_id='.$key_id.'&cuantas='.$cuantas;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);
	//echo $api_url."<br><br>";
    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);

    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return 1; // Devuelve 1 si exito
}

function waolm_descontar_activaciones($request) { // crear esquema de 4 funciones

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return $auth;

    $key_id = intval($request->get_param('key_id'));
    $cuantas = intval($request->get_param('cuantas'));

    if ($key_id <= 0 || $cuantas <= 0) {
        return new WP_Error('invalid_data', 'Datos inválidos', ['status' => 400]);
    }

    $success = json_encode(descontar_activaciones_bd($key_id, $cuantas));

    return rest_ensure_response($success);
}

///////////////////////////
// INCREMENTAR DESPACHOS //
///////////////////////////

function incrementar_despachados($key_id, $cuantas = 1) { // programar aqui
	return is_external_server_on()?json_decode(incrementar_despachados_api($key_id,$cuantas)):incrementar_despachados_bd($key_id,$cuantas);
}

function incrementar_despachados_bd($key_id, $cuantas = 1) {
    global $wpdb;
	// Dado el key_id, sumar $cuantas al metadato _dispatched 
    // Obtener el valor actual de _dispatched
    //    "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_dispatched'",
    $dispatched = $wpdb->get_var($wpdb->prepare(
        "SELECT dispatched FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE id = %d",
        $key_id
    ));

    // Convertir a número y sumar
    $dispatched = (int) $dispatched + (int) $cuantas;

    // Actualizar el valor en la base de datos
    $updated = $wpdb->update(
        "{$wpdb->base_prefix}waolicensemanager_keys",
        ['dispatched' => $dispatched],
        ['id' => $key_id],
        ['%d'],
        ['%d']
    );

    return $updated !== false; // Devuelve true si la actualización fue exitosa
}

function incrementar_despachados_api($key_id, $cuantas = 1) { // programar aqui
	$url = external_server();
	$api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/incrementar-despachados?waolm_api_key='.$api_client.'&key_id='.$key_id.'&cuantas='.$cuantas;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);
    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);

    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return 1; // Devuelve 1 si exito
}

function waolm_incrementar_despachos($request) { // crear esquema de 4 funciones

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return $auth;

    $key_id = intval($request->get_param('key_id'));
    $cuantas = intval($request->get_param('cuantas'));

    if ($key_id <= 0 || $cuantas <= 0) {
        return new WP_Error('invalid_data', 'Datos inválidos', ['status' => 400]);
    }

    $success = json_encode(incrementar_despachados_bd($key_id, $cuantas));

    return rest_ensure_response($success);
}

////////////////////////
// LAS LLAVES POR SKU //
////////////////////////

function llaves_por_sku($sku){
	return is_external_server_on()?json_decode(llaves_por_sku_api($sku)):llaves_por_sku_bd($sku);
}

function llaves_por_sku_bd($product_sku){ // consulta sobre wp_waolicensemanager_keys. 
	global $wpdb;
	$q="SELECT * from {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = '{$product_sku}' ORDER BY priority ";	
	$r = $wpdb->get_results($q);	  
	return $r;
}//function END

function llaves_por_sku_api($sku = 'O10PP') {
	$url = external_server();
	$api_client = external_server_api();
    //$api_url = $url.'wp-json/wao-license/v1/llaves-por-sku?sku='.$sku.'&waolm_api_key='.$api_client;
	$api_url = $url.'wp-json/wao-license/v1/llaves-por-sku/'.$sku.'?waolm_api_key='.$api_client;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; // 'Error al obtener los datos de la API.';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { 
        return 0; // si la client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_llaves_por_sku_api($request){
    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;

    $sku = $request->get_param('sku');
    $llaves = json_encode(llaves_por_sku_bd($sku));

    return rest_ensure_response($llaves);	
}

////////////////////////////////
// PRODUCTS WITH AD FOR COMBO //
////////////////////////////////

function products_with_ad_for_combo(){
	return products_with_ad_for_combo_bd();
}

function products_with_ad_for_combo_bd(){
	global $wpdb;
	$q="SELECT p.ID, p.post_title
		FROM {$wpdb->prefix}posts p
		INNER JOIN {$wpdb->prefix}postmeta m1 ON p.ID = m1.post_id AND m1.meta_key = '_autodispatch_option' AND m1.meta_value = 'yes'
		INNER JOIN {$wpdb->prefix}postmeta m2 ON p.ID = m2.post_id AND m2.meta_key = '_combos_option' AND m2.meta_value = 'One'
		WHERE p.post_type = 'product'
		  AND p.post_status = 'publish'
		ORDER BY p.ID";
	$resultados=$wpdb->get_results($q);
	$retorno=array();
	$i=0;
	foreach ($resultados as $res){
		$fila[$i] = new stdClass();
		$fila[$i]->sku = get_post_meta($res->ID,'_sku',true);
		$fila[$i]->post_title = $res->post_title;
		$retorno[]=$fila[$i++];
	}
// Usar usort para ordenar el array
	usort($retorno, 'compararPorNombre');
	return $retorno;
}


function products_with_ad_for_combo_q(){ 
	global $wpdb;
	$q="SELECT p.ID, p.post_title
		FROM {$wpdb->prefix}posts p
		INNER JOIN wp_postmeta m1 ON p.ID = m1.post_id AND m1.meta_key = '_autodispatch_option' AND m1.meta_value = 'yes'
		INNER JOIN wp_postmeta m2 ON p.ID = m2.post_id AND m2.meta_key = '_combos_option' AND m2.meta_value = 'One'
		WHERE p.post_type = 'product'
		  AND p.post_status = 'publish'
		ORDER BY p.ID";
	return $q;
}

////////////////
// LAS LLAVES //
////////////////

function las_llaves($sku,$forxpcs){
	$llaves = is_external_server_on()?json_decode(las_llaves_api($sku, $forxpcs)):las_llaves_bd($sku, $forxpcs);
	return $llaves;
}

function las_llaves_bd($sku,$forxpcs){ // consulta sobre tabla wp_waolicensemanager_keys. 
	global $wpdb;
	$table_name = $wpdb->base_prefix . 'waolicensemanager_keys';
	$table_product_name = $wpdb->base_prefix . 'waolm_product';
	$q = $wpdb->prepare("SELECT * from {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = '%s' AND activations > %d ORDER BY priority ", $sku, $forxpcs);	

	//$q = $wpdb->prepare("SELECT K.id as id, _key, K.id as product, P.product_name as productname, activations, dispatched, priority, waolm_sku FROM {$wpdb->base_prefix}waolicensemanager_keys K, {$wpdb->base_prefix}waolm_product P WHERE waolm_sku = sku AND waolm_sku = %s AND activations > %d ORDER BY priority ", $sku, $forxpcs);
	
	$r = $wpdb->get_results($q);	  
	return $r;
}//function END

function las_llaves_api($sku = 'O10PP', $forxpcs) {
	$url = external_server();
    $api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/las-llaves/'.$sku.'?waolm_api_key='.$api_client.'&forxpcs='.$forxpcs;
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API (funcion las_llaves_api).';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { 
        return 0; // client_api_key no autentica
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_las_llaves_api($request) {

    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;
    $sku = $request->get_param('sku');
    $forxpcs = sanitize_text_field($request->get_param('forxpcs'));
    $llaves = json_encode(las_llaves_bd($sku,$forxpcs));

    //return rest_ensure_response(['sku' => $sku, 'llaves' => $llaves]);
    return rest_ensure_response($llaves);
}


////////////////////
// CUANTAS LLAVES //
////////////////////

function cuantas_llaves($sku,$forxpcs){
	return is_external_server_on()?json_decode(cuantas_llaves_api($sku, $forxpcs)):cuantas_llaves_bd($sku, $forxpcs);
}

function cuantas_llaves_bd($sku, $forxpcs) {
    global $wpdb;
    // Consulta para contar cuántas llaves hay para un SKU específico 
    //    "SELECT COUNT(*) FROM licensemanagerwao_view WHERE waolm_sku = %s AND activations > %d",
    $cantidad = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->base_prefix}waolicensemanager_keys WHERE waolm_sku = %s AND activations > %d",
        $sku, $forxpcs
    ));
    return (int) $cantidad; // Devolver como entero
}

function cuantas_llaves_api($sku = 'O10PP',$forxpcs) {
	$url = external_server();
    $api_client = external_server_api();
	$api_url = $url.'wp-json/wao-license/v1/cuantas-llaves/'.$sku.'?waolm_api_key='.$api_client.'&forxpcs='.$forxpcs; 
    // Hacer la solicitud a la API
    $response = wp_remote_get($api_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);

    if (is_wp_error($response)) {
        return -1; //'Error al obtener los datos de la API. (funcion cuantas_llaves_api)';
    }

    $body = wp_remote_retrieve_body($response);
    if ($body=='0') { // si la client_api_key no autentica
        return $body;
    }
    $data = json_decode($body, true);

    if (!isset($data) || empty($data)) {
    //if (!isset($data['llaves']) || empty($data['llaves'])) {
        return -2; //'No se encontraron llaves para el SKU dado. ';
    }

    return $data; // Devuelve llaves para un sku
}

function waolm_cuantas_llaves_api($request) {
    $auth = waolm_validate_api_key($request);
    if (is_wp_error($auth)) return 0;
    $sku = sanitize_text_field($request['sku']);
    $forxpcs = sanitize_text_field($request->get_param('forxpcs'));
    $cantidad = json_encode(cuantas_llaves_bd($sku,$forxpcs));
	return $cantidad;
    //return rest_ensure_response(['sku' => $sku, 'cantidad' => $cantidad]);
}


/////////////////////////////////////////////////////////////////////
// FUNCIONES GENERICAS PARA CONSULTA DE CONFIGURACIONES DE SERVIDOR//
/////////////////////////////////////////////////////////////////////
function get_waolm_option($key, $default="xxx"){
	$waolm_option = get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_waolm_server_option($key, $default="xxx"){
	//$waolm_option = get_option('_waolm_server_options');
	$waolm_option = is_multisite()?get_blog_option(1,'_waolm_server_options'):get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_waolm_client_option($key, $default="xxx"){
	$waolm_option = is_multisite()?get_blog_option(1,'_waolm_client_options'):get_option('_waolm_options');
	return isset($waolm_option[$key])?$waolm_option[$key]:$default;
}

function get_smart_waolm_client_option($key, $return="xxx"){
	if(is_multisite()){
		$waolm_option = get_option('_waolm_options');
		if(isset($waolm_option[$key])&&$waolm_option[$key]<>""){
			
		}else{
			$waolm_option = get_blog_option(1,'_waolm_client_options');
		}
	}else{
		$waolm_option = get_option('_waolm_options');
	}
	if(isset($waolm_option[$key])){
		$return = $waolm_option[$key];
	}
	return $return;
}

function is_external_server_on(){
	$is = get_waolm_client_option('external_server_on');
	return $is=='on'?true:false;
}

function external_server(){
	return get_waolm_client_option('externalserver');
}

function external_server_api(){
	return get_waolm_client_option('api_client','');
}

// Ordenar el array
function compararPorNombre($a, $b) {
    return strcmp($a->post_title, $b->post_title);
}

function mostrar_error($e){
	switch ($e){
		case 0: 
			$msg ="Error de autenticacion api servidor.";
			break;
		case -1: 
			$msg ="Error al obtener datos de la API.";
			break;
		case -2: 
			$msg ="No se encontraron llaves para el sku dato.";
			break;
		default:
			$msg ="Error no especificado";
	}
	return $e;
}


/////////////////////////////////////////////////////////////////////////////
// FUNCIONES PARA CONSULTAS EN LOCAL SOBRE wp_waolm_dispatched_keys (LOCAL)//
/////////////////////////////////////////////////////////////////////////////

function get_client_keys_by_order_id_site($order_id,$site_id){ // para sus llaves en edit order
	global $wpdb;
	$q = $wpdb->prepare(
		"SELECT K.id, K.sku, K.product_name, O.customer_email, O.order_id, K.key, O.date, O.site_id, O.site_url
		 FROM {$wpdb->base_prefix}waolm_rel_orders O
		 LEFT JOIN {$wpdb->base_prefix}waolm_rel_orders_keys K ON O.ID = K.rel_order_id
		 WHERE O.order_id = %d AND O.site_id = %d",
		$order_id,
		$site_id
	);
	$res = $wpdb->get_results($q);
update_option('_depu',$q);
	return $res;
}

// obtener todas las llaves que compró este cliente.
function get_keys_purchased_by_email($customer_email) {
	// Obtener todas las llaves que compró $customer_email
    global $wpdb;
    // Preparar la consulta de manera segura
	$query = $wpdb->prepare("SELECT K.id, K.sku, K.product_name, O.customer_email, O.order_id, K.key, O.date, O.site_id, O.site_url
		  FROM wp_waolm_rel_orders O
		  LEFT JOIN wp_waolm_rel_orders_keys K ON O.ID = K.rel_order_id 
		  WHERE O.customer_email = %s
		  AND O.sended = 1", 
		$customer_email 
	);

   // Ejecutar la consulta y obtener los resultados
    $results = $wpdb->get_results($query);
    // Array para almacenar los resultados finales
    $response = array();
    // Verificar si se encontraron resultados
    if ( !empty($results) ) {
        foreach ( $results as $row ) {
            // Mapear los resultados a un formato de array específico
			if(is_multisite()){
				$order_site = get_site($row->site_id);
				if ($order_site) {
					$site_url = get_site_url($row->site_id);
				} else {
					$site_url = get_option('home');
				}
			}else{
				$site_url = get_option('home');
			}
            $response[] = array(
                'Fecha'    => date('Y-m-d', strtotime($row->date)),     // Columna 'date' de la base de datos
                'Producto' => $row->product_name, // Columna 'product_name' de la base de datos
                'Llave'    => $row->key,          // Columna 'key' de la base de datos
                'Orden'    => $row->order_id,     // Columna 'order_id' de la base de datos
                'Sku'      => $row->sku,           // Columna 'sku' de la base de datos
                'Site'     => $row->site_id,       // Columna 'site_id' de la base de datos
                'Siteurl'  => $row->site_url   		// Construido a partir de site_id
            );
        }
    } else {
        // Manejo del caso en que no se encuentren resultados
        //echo 'No se encontraron resultados para el correo electrónico y la clave proporcionados.';
    }
    // Devolver el array de respuesta
    return $response;
}

// 
function email_vs_key($customer_email, $sku) {
	// Evaluar si $customer_email ya compro una $vkey
    global $wpdb;
    // Preparar la consulta de manera segura 
	$query = $wpdb->prepare(
		"SELECT K.key
			FROM {$wpdb->base_prefix}waolm_rel_orders O LEFT JOIN {$wpdb->base_prefix}waolm_rel_orders_keys K ON O.id = K.rel_order_id
			WHERE O.customer_email = %s AND K.sku = %s", 
		$customer_email, 
		$sku
	);
    $retorno = $wpdb->get_col($query);
    return $retorno;
}

// crear una fila en waolm_rel_orders
function waolm_insert_rel_order( $order_id, $sended = 0 ) {
    global $wpdb;

    // Obtener la orden
    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return false;
    }

    // Preparar datos
    $customer_email = $order->get_billing_email();
    $site_id = get_current_blog_id();
    $site_url = get_site_url();
    $date = $order->get_date_created() ? $order->get_date_created()->format('Y-m-d H:i:s') : current_time('mysql');

    // Insertar en waolm_rel_orders
    $result = $wpdb->insert(
        "{$wpdb->base_prefix}waolm_rel_orders",
        [
            'order_id'       => $order_id,
            'customer_email' => $customer_email,
            'site_id'        => $site_id,
            'site_url'       => $site_url,
            'date'           => $date,
            'sended'         => $sended,
        ],
        [ '%d', '%s', '%d', '%s', '%s', '%d' ]
    );

    // Devolver el ID insertado o false
    return $result ? $wpdb->insert_id : false;
}

// crear una fila en waolm_rel_orders_keys
function waolm_insert_rel_order_key( $rel_order_id, $sku, $product_name, $key, $dispatched = 1, $priority = 0 ) {
    global $wpdb;
    // Insertar la clave en la tabla de llaves relacionadas
    $result = $wpdb->insert(
        "{$wpdb->base_prefix}waolm_rel_orders_keys",
        [
            'rel_order_id'  => $rel_order_id,
            'sku'           => $sku,
            'product_name'  => $product_name,
            'key'           => $key,
            'dispatched'    => $dispatched,
            'priority'      => $priority,
        ],
        [ '%d', '%s', '%s', '%s', '%d', '%d' ]
    );

    // Devolver el ID insertado o false
    return $result ? $wpdb->insert_id : false;
}

// Adaptado para guardar todo en tabla centralizada (site=1)
function update_table_waolm_dispatched_keys($envio,$customer_email,$order_id) {
    global $wpdb;
	$site_url = get_option('home');
	$dispatched = 1;
	$priority = 1;
    if ($envio) {
		$rel_order_id = waolm_insert_rel_order($order_id,0);
		foreach ($envio as $grupo){
			foreach ($grupo as $key_data) {

				if (is_object($key_data)) {
					$sku = $key_data->waolm_sku;
					$product_name = $key_data->product_name;
					$key = $key_data->_key;

					$rel_orders_keys_id = waolm_insert_rel_order_key($rel_order_id, $sku, $product_name, $key, $dispatched, $priority);
				}
				if (is_array($key_data)) {
					foreach ($key_data as $key_object) {
						if (is_object($key_object)) {
							$sku = $key_object->waolm_sku;
							$product_name = $key_object->product_name;
							$key = $key_object->_key;

							$rel_orders_keys_id = waolm_insert_rel_order_key($rel_order_id, $sku, $product_name, $key, $dispatched, $priority);

						}
					}
				}
			}
		}
    }
}

function llaves_entregadas($order_id) {
    global $wpdb;

    $table = "{$wpdb->base_prefix}waolm_rel_orders";

    // Ejecutar UPDATE
    $result = $wpdb->update(
        $table,
        ['sended' => 1],
        ['order_id' => $order_id],
        ['%d'],
        ['%d']
    );

    // Devolver true si se actualizaron filas, false si no
    return ($result !== false && $result > 0);
}
