<?php

add_filter('manage_edit-shop_order_columns', 'agregar_columna_llaves_enviadas_despues_de_status2', 20);
function agregar_columna_llaves_enviadas_despues_de_status2($columns) {
    $nuevas_columnas = [];

    foreach ($columns as $key => $column) {
        $nuevas_columnas[$key] = $column;

        // Insertar justo después de la columna 'order_status'
        if ($key === 'order_status') {
            $nuevas_columnas['llaves_enviadas'] = 'Despachado';
        }
    }

    return $nuevas_columnas;
}

add_action('manage_shop_order_posts_custom_column', 'mostrar_estado_llaves_enviadas2', 10, 2);
function mostrar_estado_llaves_enviadas2($column, $post_id) {
    if ($column === 'llaves_enviadas') {
        $valor = get_post_meta($post_id, 'llaves_enviadas', true);

        if ($valor === 'yes') {
            echo '<span style="color: green; font-weight: bold;">✔ Sí</span>';
        } else {
            echo '<span style="color: red; font-weight: bold;">✘ No</span>';
        }
    }
}
 

add_filter('woocommerce_order_actions', 'agregar_opcion_despacho_manual2');
function agregar_opcion_despacho_manual2($actions) {
    $actions['despacho_manual'] = 'Despacho manual';
    return $actions;
}


add_action('woocommerce_order_action_despacho_manual', 'ejecutar_despacho_manual2');
function ejecutar_despacho_manual2($order) {
    if (!$order instanceof WC_Order) return;

    $order_id = $order->get_id();

    update_post_meta($order_id, 'llaves_enviadas', 'yes');
    update_post_meta($order_id, '_accion', 'Verificar que el cliente qued&oacute; satisfecho.');
    update_post_meta($order_id, '_razon', 'Despachado en forma manual.');

    // (Opcional) Nota interna en la orden
    $order->add_order_note('Llaves marcadas como enviadas manualmente.');
} 

// ORDENAR POR COLUMNA 
// 1) Hacer la columna clicable (usamos 'llaves_enviadas' como orderby "señuelo")
add_filter( 'manage_edit-shop_order_sortable_columns', function( $cols ) {
    $cols['llaves_enviadas'] = 'llaves_enviadas';
    return $cols;
}, 20 );

// 2) Al hacer clic, en vez de ordenar, filtramos: mostrar sólo pedidos SIN ese meta (NULL)
//    y dejamos el orden por fecha (opcional).
add_action( 'pre_get_posts', function( $q ) {
    if ( ! is_admin() || ! $q->is_main_query() ) return;
    if ( $q->get( 'post_type' ) !== 'shop_order' ) return;
    if ( $q->get( 'orderby' ) !== 'llaves_enviadas' ) return;
	if($q->get('order')=='asc'){
		// Filtra: meta 'llaves_enviadas' NO existe (antes de enviar llaves)
		$meta_query = (array) $q->get( 'meta_query' );
		$meta_query[] = array(
			'key'     => 'llaves_enviadas',
			'compare' => 'NOT EXISTS',
		);
		$q->set( 'meta_query', $meta_query );

		// Opcional: asegúrate de que el listado siga ordenado por fecha descendente
		$q->set( 'orderby', 'date' );
		$q->set( 'order', 'DESC' );
	}
}, 20 );
