<?php
/**
 * Agregar menú de configuración en Network Admin
 */
// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function porunavez(){ 
	$_options_migrated = is_multisite()?get_blog_option(1,"_waolm_options_migrated",null):get_option("_waolm_options_migrated",null);
	if(isset($_options_migrated)){return;}
	if(is_multisite()){
		$waolm_options = get_blog_option(1,'_waolm_options');
		update_blog_option(1,'_waolm_client_options',$waolm_options);
		delete_blog_option(1,'_waolm_server_id');
	}else{
		$waolm_option = get_option('_waolm_options');
		update_option('_waolm_client_options',$waolm_options);
		delete_option('_waolm_server_id');
	}

	$waolm_server_options['waolm_server_api_key'] = '';
	if(is_multisite()){
		update_blog_option(1,'_waolm_server_options',$waolm_server_options);
	}else{
		update_option(1,'_waolm_server_options',$waolm_server_options);
	}

	// Obtener todos los sitios del multisite 
	$sites = get_sites();
	foreach ($sites as $site) {
		switch_to_blog($site->blog_id); // Cambia al sitio actual
		// Obtener la opción _waolm_options
		$waolm_options = get_option('_waolm_options', []);
		if (is_array($waolm_options)) {
			// Filtrar solo 'email_template' y 'checkout_template'
			$filtered_options = array_intersect_key($waolm_options, array_flip(['email_template', 'checkout_template']));
			// Guardar la opción nuevamente con solo los valores filtrados
			update_option('_waolm_options', $filtered_options);
		}
		restore_current_blog(); // Restaurar el sitio original
	}
	if(is_multisite()){
		update_blog_option(1,'_waolm_options_migrated',1);
	}else{
		update_option('_waolm_options_migrated',1);
	}

}


function waolm_network_settings_menu() {
    if (!is_network_admin()) {
        return;
    }
	//porunavez();
	//create_licensemanagerwao_view(); //en waolm-migrate.php ya discontinuado

    add_menu_page(
        'WAOLM Client Settings',
        'WAOLM Client Settings',
        'manage_network',
        'waolm_config',
        'waolm_network_settings_page',
        'dashicons-admin-network',
        6
    );

    if ( function_exists('waolm_render_verify_orders_page') ) { // borrar cuando ya no exista waolm-migrate.php
		add_submenu_page(
			'waolm_config',                    // parent slug (debe coincidir con el de arriba)
			'WAO LM: Verificar órdenes',       // page title
			'Verificar órdenes',               // menu title
			'manage_network',                  // capability
			'waolm-verify-orders',             // menu slug
			'waolm_render_verify_orders_page'  // callback
		);
    }
}

add_action('network_admin_menu', 'waolm_network_settings_menu');

/**
 * Página de configuración
 */
function waolm_network_settings_page() {
    $tab = isset($_GET['tab']) ? $_GET['tab'] : 'general';
    if (isset($_POST['waolm_save_settings']) && check_admin_referer('waolm_network_settings')) {
        $options = is_multisite()?get_blog_option(1,'_waolm_client_options', array()):get_option('_waolm_options', array());
        
        // Guardar valores
		
		if ($tab == 'general'){
			$options['urlmanuals'] = sanitize_text_field($_POST['urlmanuals']);
			$options['payments'] = sanitize_text_field($_POST['payments']);
			$options['llavesquemadas'] = isset($_POST['llavesquemadas']) ? 'on' : '';
			$options['tolerancia'] = isset($_POST['llavesquemadas']) ? sanitize_text_field($_POST['tolerancia']) : '';
			$options['new_to'] = sanitize_text_field($_POST['new_to']);
		}
		if ($tab == 'templates'){
			$options['email_template'] = stripcslashes(($_POST['email_template']));
			$options['checkout_template'] = stripslashes(($_POST['checkout_template']));
		}
		if ($tab == 'migracion'){
			//$options['purgar_keys'] = isset($_POST['purgar_keys']) ? 'on' : '';
		}
		if ($tab == 'thankyou'){
			$options['thankyou_show_keys'] = isset($_POST['thankyou_show_keys']) ? 'on' : '';
		}
		if ($tab == 'api_client'){
			if(isset($_POST['external_server_on'])){
				$options['external_server_on'] = sanitize_text_field($_POST['external_server_on']);
				if(isset($_POST['externalserver'])){
					$raw_url = isset($_POST['externalserver']) ? trim($_POST['externalserver']) : '';
					// Si no empieza con http:// o https://, forzar https://
					if ( ! preg_match('~^https?://~i', $raw_url) ) {
						$raw_url = 'https://' . $raw_url;
					}
					// Quitar todos los slashes del final
					$raw_url = rtrim($raw_url, "/");
					// Agregar solo un slash final
					$formatted_url = $raw_url . '/';
					//echo $formatted_url;
					//$options['externalserver'] = sanitize_text_field($_POST['externalserver']);
					$options['externalserver'] = $formatted_url;
				}
				if(isset($_POST['api_client'])){
					$options['api_client'] = sanitize_text_field($_POST['api_client']);
				}
			}else{
				$options['external_server_on'] = '';
			}
		}

		if (current_user_can('manage_options')) {
			if(is_multisite()){
				update_blog_option(1,'_waolm_client_options', $options);
			}else{
				update_option('_waolm_options', $options);
			}
			echo '<div class="updated notice"><p>Configuración guardada.</p></div>';
		}else{
			echo '<div class="error notice"><p>Te falta!.</p></div>';
		}
        
    }
	$options = is_multisite()?get_blog_option(1,'_waolm_client_options', array()):get_option('_waolm_options', array());
    ?>
    <div class="wrap">
        <h1>WAOLM Client Settings</h1>
        <h2 class="nav-tab-wrapper">
            <a href="?page=waolm_config&tab=general" class="nav-tab <?php echo ($tab == 'general') ? 'nav-tab-active' : ''; ?>">General</a>
            <a href="?page=waolm_config&tab=templates" class="nav-tab <?php echo ($tab == 'templates') ? 'nav-tab-active' : ''; ?>">Templates</a>
		<?php if(function_exists('waolm_setting_migrate_status1')&&current_user_can('manage_network_options')){ //  ?>
            <a href="?page=waolm_config&tab=migracion" class="nav-tab <?php echo ($tab == 'migracion') ? 'nav-tab-active' : ''; ?>">Migración</a>
		<?php }?>
		<?php if(current_user_can('manage_network_options')){ //  ?>
            <a href="?page=waolm_config&tab=api_client" class="nav-tab <?php echo ($tab == 'api_client') ? 'nav-tab-active' : ''; ?>">API client setting</a>
		<?php }?>
        </h2>
		<?php
		if ($tab == 'migracion'){$accion = esc_url( admin_url('network/admin.php?page=waolm_config&tab=migracion'));}else{$accion = '';}
		?>
		<form method="post" action="<?php echo $accion;?>" >
            <?php wp_nonce_field('waolm_network_settings'); ?>
            <?php if ($tab == 'general') { ?>
                <h3>Configuración General</h3>
                <table class="form-table">
                    <tr><th>URL Manuals</th><td><input type="text" name="urlmanuals" value="<?php echo esc_attr($options['urlmanuals'] ?? ''); ?>" class="regular-text" /></td></tr>
                    <tr><th>Completed Email CC</th><td><input type="text" name="new_to" value="<?php echo esc_attr($options['new_to'] ?? ''); ?>" class="regular-text" /></td></tr>
                    <tr><th>Payments</th><td><textarea name="payments" class="large-text code" rows="5"><?php echo esc_textarea($options['payments'] ?? ''); ?></textarea>
					<?php 
						$default_payments = 'cod|ppec_paypal|ppcp|stripe|stripe_googlepay|stripe_applepay|stripe_cc|amazon_payments_advanced|woosa_adyen_credit_card|woosa_adyen_googlepay|woosa_adyen_applepay|woosa_adyen_klarna|woosa_adyen_wechatpay|woosa_adyen_alipay|emerchantpay_checkout|ppcp-gateway';
						$ultimo_metodo_de_pago = get_option('ultimo_metodo_de_pago');
						echo "<i>(Los m&eacute;todos de pago que se mostrar&aacute;n en la ThankYou Page)</i> ";
						echo "<p>Puede copiar varios de la siguiente lista deben estar separados por el caracter pipe (|)</p>";
						echo "<h5 style='border:solid 1px gray;border-radius:3px;background-color:#e7e7e7;padding:3px;'>".$default_payments."</h5>";
						echo "<h5>El &uacute;ltimo m&eacute;todo de pago utilizado fu&eacute;: <b style='border:solid 1px gray;border-radius:3px;background-color:#e7e7e7;padding:3px;'>".$ultimo_metodo_de_pago."</b></h5>";

					
					?>
					
					</td></tr>
                    <?php if (isset($options['llavesquemadas'])&&$options['llavesquemadas']=='on'){?>
                    <tr><th>Activar verificación de llaves quemadas</th><td><input type="checkbox" name="llavesquemadas" <?php checked($options['llavesquemadas'], 'on'); ?> /></td></tr>
					<tr><th>Tolerancia de envío</th><td><input type="text" name="tolerancia" value="<?php echo esc_attr($options['tolerancia'] ?? ''); ?>" class="small-text" /></td></tr>
					<?php } ?>
                </table>
            <?php } elseif ($tab == 'templates') { ?>
                <h3>Templates</h3>
                <table class="form-table">
                    <tr><th>Email Template</th><td><textarea name="email_template" class="large-text code" rows="5"><?php echo esc_attr($options['email_template'] ?? ''); ?></textarea></td></tr>
                    <tr><th>Checkout Template</th><td><textarea name="checkout_template" class="large-text code" rows="5"><?php echo esc_attr($options['checkout_template'] ?? ''); ?></textarea></td></tr>
                </table>
            <?php } elseif ($tab == 'migracion') { ?>
                <h3>Estado actual de la migración de llavess</h3>
				 <?php if(function_exists('waolm_setting_migrate_status1')){ //  
							waolm_setting_migrate_status1();// en waolm_migrate
				 }
				?>
				<?php waolm_mostrar_options_en_tabla();// la funcion esta al final?>
            <?php } elseif ($tab == 'thankyou') { ?>
                <h3>Thank You Page</h3>
				<?php $thankyou_show_keys = isset($options['thankyou_show_keys'])?$options['thankyou_show_keys']:"";?>
                <table class="form-table">
                    <tr><th>Dejar de mostrar llaves en thank you page</th><td><input type="checkbox" name="thankyou_show_keys" <?php checked($thankyou_show_keys, 'on'); ?> /></td></tr>
                </table>
            <?php } elseif ($tab == 'api_client') { ?> 
                <h3>Configuración de servidor de llaves externo.</h3>
                <table class="form-table">
				<?php $external_server_on = isset($options['external_server_on'])?$options['external_server_on']:"";?>
                    <tr><th>Obtener llaves de servidor externo</th><td><input type="checkbox" name="external_server_on" <?php checked($external_server_on, 'on'); ?> /></td></tr>
					<?php if($external_server_on=='on'){ ?>
                    <tr><th>Servidor Externo</th><td><input type="text" name="externalserver" value="<?php echo esc_attr($options['externalserver'] ?? ''); ?>" class="regular-text" /><i><small>Ejemplo: https://dominio.com/</small></i></td></tr>
                    <tr><th>API Client</th><td><input type="text" name="api_client" value="<?php echo esc_attr($options['api_client'] ?? ''); ?>" class="regular-text" /><i><small>Obtener del servidor.</small></i></td></tr>
					<?php } ?>
                </table>
				<?php if($external_server_on=='on'){ ?>
				<p>Si external server tiene una url valida, las llaves se obtendran de ahí.</p>
				<p>Obtener la api client de la configuración del servidor.</p>
				<?php } ?>
            <?php } ?>
			<?php if ($tab<>"migracion"){ ?>
            <p class="submit"><input type="submit" name="waolm_save_settings" class="button-primary" value="Guardar Cambios" /></p>
			<?php } ?>
        </form>
    </div>
    <?php
}

// En esta funcion, completa dos lineas: (debajo de la creación de su tabla correspondiente)
// - Migración de _keys a waolm_dispatched_keys: migradas / total por subsite 
// - Migración de waolm_dispatched_keys → tablas normalizadas: migradas / total




function waolm_client_default_configuration() {
	$waolmoptions = is_multisite()?get_blog_option(1,'_waolm_client_options', array()):get_option('_waolm_options', array());

	if(!isset($waolmoptions['email_template'])||empty($waolmoptions['email_template'])){
		$waolmoptions['email_template']='	<hr><h2>{titulo}</h2>
	<table class="td tablekeys" cellspacing="0" cellpadding="6" style="width: 100%; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_nro}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_product}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_key}</th>
			</tr>
		</thead>
		<tbody>
		{filas}
		</tbody>
	</table>
	<br><hr>';
	}

	if(!isset($waolmoptions['checkout_template'])||empty($waolmoptions['checkout_template'])){
		$waolmoptions['checkout_template']='<style>
	h2 {font-size:25px;}
	.tabla{width:100%;}
	.pname, .pversion {display:inline-block;padding-left:5px;}
	.pversion{text-decoration:underline;}
	.plink{height:40px;}
	.par{background-color:Gainsboro;height:25px;}
	.impar{background-color:white;height:25px;}
	.tablekeys thead tr{background-color:Gray;color:white;height:5px;}
	tr.plink td p{height:15px;}
	tr.impar td p{height:10px;margin-top:0px;margin-bottom:0px;}
	tr.par td p{height:10px;margin-top:0px;margin-bottom:0px;}
	.alert-message {display: flex;align-items: center;background-color:#EEEEEE;border:solid 1px gray;border-radius:5px;padding:10px}
	.exclamation-mark {font-size: 50px;color: #FF0000;margin-right: 30px;}
	.message-content {color:#D04848;font-size:18px;/* Estilos para tu mensaje */}
</style>

<div class="tabla">{tabla}</div>

<div class="alert alert-warning alert-white rounded"style="align-items: center;gap: 10px;width: 90%;background-color:#E7E7EE;border:solid 1px gray;border-radius:3px;padding:10px;">
	<div class="icon" style="display:inline;">
		<svg width="40px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M569.5 440C588 472 564.8 512 527.9 512H48.1c-36.9 0-60-40.1-41.6-72L246.4 24c18.5-32 64.7-32 83.2 0l239.9 416zM288 354c-25.4 0-46 20.6-46 46s20.6 46 46 46 46-20.6 46-46-20.6-46-46-46zm-43.7-165.3l7.4 136c.3 6.4 5.6 11.3 12 11.3h48.5c6.4 0 11.6-5 12-11.3l7.4-136c.4-6.9-5.1-12.7-12-12.7h-63.4c-6.9 0-12.4 5.8-12 12.7z"/></svg>
	</div>
	<div class="message-content2" style="display:inline;">{mensaje}</div>
</div>';
	}

	if(!isset($waolmoptions['payments'])||empty($waolmoptions['payments'])){
		$waolmoptions['payments']="cod|ppec_paypal|ppcp|stripe|stripe_googlepay|stripe_applepay|stripe_cc|amazon_payments_advanced|woosa_adyen_credit_card|woosa_adyen_googlepay|woosa_adyen_applepay|woosa_adyen_klarna|woosa_adyen_wechatpay|woosa_adyen_alipay|emerchantpay_checkout|ppcp-gateway";
	}


    //update_option('_waolm_client_options', $waolmoptions);
	if(is_multisite()){
		update_blog_option(1,'_waolm_client_options', $waolmoptions);
	}else{
		update_option('_waolm_options', $waolmoptions);
	}
	
}
//add_action('update_option__waolm_client_options', 'waolm_client_default_configuration',1);


function waolm_mostrar_options_en_tabla() {
    $option_names = array('waolm_migration','_waolm_options', '_waolm_client_options', '_waolm_server_options');

    echo '<div class="wrap"><h1>Opciones WAOLM</h1>';

    foreach ($option_names as $option_name) {
        $data = get_option($option_name);

        echo "<h2>$option_name</h2>";

        if (!is_array($data)) {
            echo "<p><code>$option_name</code> no es un array o no existe.</p>";
            continue;
        }

        echo '<table class="widefat striped"><thead><tr><th>Clave</th><th>Valor</th></tr></thead><tbody>';

        foreach ($data as $key => $value) { 
            echo '<tr>';
            echo '<td style="vertical-align: top;"><code>' . esc_html($key) . '</code></td>';
            echo '<td>';

            if (is_array($value)) {
                echo '<table style="border: 1px solid #ccc; margin: 5px;"><tbody>';
                foreach ($value as $subkey => $subval) {
                    echo '<tr>';
                    echo '<td style="border: 1px solid #ccc; padding: 3px;"><code>' . esc_html($subkey) . '</code></td>';
                    echo '<td style="border: 1px solid #ccc; padding: 3px;"><code>' . esc_html(print_r($subval, true)) . '</code></td>';
                    echo '</tr>';
                }
                echo '</tbody></table>';
            } else {
                echo '<code>' . esc_html(print_r($value, true)) . '</code>';
            }

            echo '</td></tr>';
        }

        echo '</tbody></table><br>';
    }

    echo '</div>';
}


// Almacenar como option el código del ultimo metodo de pago utilizado
function get_payment_method_at_checkout($order_id) {
    $order = wc_get_order($order_id);
    if ($order) {
        $payment_method = $order->get_payment_method();
        update_option('ultimo_metodo_de_pago',$payment_method);
    }
}
add_action('woocommerce_checkout_update_order_meta', 'get_payment_method_at_checkout');
