<?php
/** 
* Class to create additional product panel in admin 
* @package TPWCP 
* ARTURO: V.2 (Linea 179 modificado query para mostrar solo productos que tienen llaves)
* 		  V.2.1 (Combo de 3 Productos)
* 		  V.2.2 (Link al manual insertado en pestaña + funcion para actualizar el metadato _download_link con idioma + sku producto)
*		  V.2.3 (Guardado de path corregido)
*		  V.2.4 (linea 300 error cuando no hay path corregido)
*/
// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}
if( ! class_exists( 'WAOLM_Pestania' ) ) {
    class WAOLM_Pestania {
        public function __construct() {
        }
        public function init() {
      	// Create the custom tab 
            add_filter( 'woocommerce_product_data_tabs', array( $this, 'create_autodispatch_tab' ) );
    		// Add the custom fields 
            add_action( 'woocommerce_product_data_panels', array( $this, 'display_autodispatch_fields' ) );
    		// Save the custom fields 
    		add_action( 'woocommerce_process_product_meta', array( $this, 'save_fields' ) );
       }
/** 
* Add the new tab to the $tabs array 
* @see https://github.com/woocommerce/woocommerce/blob/e1a82a412773c932e76b855a97bd5ce9dedf9c44/includes/admin/meta-boxes/class-wc-meta-box-product-data.php 
* @param $tabs 
* @since 1.0.0 
*/
	public function create_autodispatch_tab( $tabs ) {
		$tabs['giftwrap'] = array(
			'label'         => __( 'Automatic Dispatch', 'waolicensemanager' ), // The name of your panel 
			'target'		=> 'gifwrap_panel', // Will be used to create an anchor link so needs to be unique 
			'class'			=> array( 'giftwrap_tab', 'show_if_simple', 'show_if_variable' ), // Class for your panel tab - helps hide/show depending on product type 
			'priority'      => 80, // Where your panel will appear. By default, 70 is last item 
		);
		return $tabs;
	}
/** 
* Display fields for the new panel 
* @see https://docs.woocommerce.com/wc-apidocs/source-function-woocommerce_wp_checkbox.html 
* @since 1.0.0 
*/
	public function display_autodispatch_fields($post_id) { ?>
		<style>
			.inline1{display:inline-block!important;border-right:solid gray 1px;}
			.inline1 ul li{display:inline-block!important}
			.wc-radios li{display:inline!important;padding-left:3px;padding-right:3px;}
			.no-show {display:none!important;}
			.woocommerce_options_panel label{width:300px!important;}
		</style>
		<div id='gifwrap_panel' class='panel woocommerce_options_panel' style='margin-top:1px;'>
			<div class="options_group">
				<div>
				<?php
					$sino=false;
					$name=get_post($post_id);
					$sku=get_post_meta($name->ID,'_sku',true);//nuevo / obtengo el _sku del producto
					$auto=get_post_meta($name->ID,'_autodispatch_option');//del producto
					$co=get_post_meta($name->ID,'_combos_option');
					$combos_option=$co[0]==""?'One':$co[0];
					if($combos_option<>'One'){$clase="inline1 no-show";}else{$clase="inline1";}
					woocommerce_wp_checkbox(
						array(
							'id'		=> 'autodispatch_option',
							'label'		=> __( 'Auto dispatch option', 'waolicensemanager' ),
							'value'		=> $auto[0],
							'wrapper_class'	=> 'inline1',
							'desc_tip'	=> $sino,
							'descriptionx'	=> __( 'Select this option to activate keys autodispatch for this product', 'waolicensemanager' )
						)
					);

					 woocommerce_wp_radio( array(
						 'id'            => 'combos_option',
						 'name'            => 'combos_option',
						 'label'         => __('Products', 'tpwcp'),
						 'options'       => array(
							 'One'    => '1 Product &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
							 'Two'    => '2 Products &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
							 'Three'  => '3 Products &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
							 'Four'   => '4 Products'
						 ),
						 'value'         => $combos_option
					 ) );
				?>
				</div>
				<?php
				if($auto[0]=="yes"){
					if($combos_option=="One"){
				?>
				<table class="wp-list-table widefat fixed striped table-view-list posts">
					<thead>
					<tr>
						<td>KEY</td>
						<td>PRODUCT</td>
						<td>ACTIVATIONS</td>
						<td>DISPATCHED</td>
						<td>PRIORITY</td>
					</tr>
					</thead>
					<tbody>
					<?php

					$content = llaves_por_sku($sku);
					if($content == 0){
						echo '<div class="notice notice-error">Fallo en la autenticacion de API de despacho automatico!.</div>'; 
						$content = '';
					}
					//$claves=json_decode(strip_tags($content),true);
					$claves=$content;

					foreach($claves as $clave){ // por cada post_id encontrado
					?>
					<tr>
						<td><?php echo $clave->_key//->;?></td>
						<td width="20%"><?php echo $clave->product_name; ?></td>
						<td><?php echo $clave->activations; ?></td>
						<td><?php echo $clave->dispatched;?></td>
						<td><?php echo $clave->priority;?></td>
					</tr>
					<?php
					}//fin de for bucle por cada llave
					?>
					</tbody>
				</table>
				<?php
					}else{//else if combos option one
						switch ($combos_option){
							case "Two": 
								$k=2;
								break;
							case "Three": 
								$k=3;
								break;
							case "Four": 
								$k=4;
								break;
						}//fin de switch

						$resultados=products_with_ad_for_combo();//en waolm_querys_new.php
						//print_r($resultados);
						$opciones=array();
						if($resultados == 0){
							echo '<div class="notice notice-error">Fallo en la autenticacion de API de despacho automatico!.</div>'; 
							$resultados = '';
							$opciones['']='Error al autenticar con la API ante servidor externo.';
						}else{
							$opciones['']='No se ha seleccionado :(';
						}
						foreach($resultados as $r){
							if(get_smart_waolm_client_option('external_server_on')=='on'){
								$opciones[$r->sku]=$r->post_title;
							}else{
								$opciones[$r->sku]=table_product_name($r->sku);
							}
						}//fin foreach
						$prod=get_post_meta($name->ID,'_combo_products',true);
						for($j=0;$j<$k;$j++){
							$id_1 = "combo_product".$j;
							$label_1 = "Product ".($j+1);
							//$opciones = array('1'=>'uno','2'=>'dos','3'=>'tres');
							//$args = array( 'posts_per_page' => 200, 'post_status' => 'publish', 'post_type' => 'product' );
							//$postslist = new WP_Query( $args );
							woocommerce_wp_select(
								array(
									'id'		=> $id_1,
									'label'		=> __( $label_1, 'waolicensemanager' ),
									'desc_tip'	=> true,
									'description'	=> __( 'Nombre del <i>product</i> cuando existe llave en <i>despacho autm&aacute;tico</i>', 'waolicensemanager' ),
									'value'		=> $prod[$j],
									'options'	=> $opciones
								)
							);
							
						}//fin for
					}//fin if combos option one
				}//fin si autodispatch yes (fin de tabla)
				?>
				<div><hr>
				<?php
				//if($combos_option=="One"&&$auto[0]=="yes"){
				if($combos_option=="One"&&$auto[0]=="yes"){
					$auto=get_post_meta($name->ID,'_download_link');
					woocommerce_wp_text_input(
						array(
							'id'		=> 'download_link',
							'label'		=> __( 'Path for manual and download of this product', 'waolicensemanager' ),
							'type'		=> 'text',
							'value'		=> $auto[0],
							'desc_tip'	=> true,
							'description'	=> __( 'Write the path URL for manuals and downloads including language (Ex: <c style="color:yellow;">de/windows-11-pro/</c>)', 'waolicensemanager' )
						)
					);

					$auto=get_post_meta($name->ID,'_product_name');
					woocommerce_wp_text_input(
						array(
							'id'		=> 'product_name',
							'label'		=> __( 'Friendly Name for keys table', 'waolicensemanager' ),
							'placeholder'   => $name->post_title,
							'value'		=> $auto[0],
							'type'		=> 'text',
							'desc_tip'	=> true,
							'description'	=> __( 'The product name as will showed in the email.', 'waolicensemanager' )
						)
					);
				echo '<p class="form-field download_link_field" ><label>Link to manual</label>';
				echo '<span><a href=" '.esc_url(waolm_get_manual_url($name->ID)).'" target="_blank">'.esc_html(waolm_get_manual_url($name->ID)).'</a></span>';
				echo '<span class="woocommerce-help-tip" tabindex="0" aria-label="Link to be inserted on completed order customer email."></span></p>';
				}//fin de combos option one
				?>
				</div><hr>
				<input type="submit" name="save" id="publish" class="button button-primary button-large" style="margin-bottom:20px;" value="Update">
			</div>
		</div>
	<?php 
	} // function end

/** 
* Save the custom fields using CRUD method 
* @param $post_id 
* @since 1.0.0 
*/
	public function save_fields( $post_id ) {
		$product = wc_get_product( $post_id );
		// Save the autodispatch_option setting 
		$autodispatch_option = isset( $_POST['autodispatch_option'] ) ? 'yes' : 'no';
		$auto=get_post_meta($post_id,'_autodispatch_option',true);
		$combos_option = isset( $_POST['combos_option'] ) ? $_POST['combos_option'] : '';
		$download_link = isset( $_POST['download_link'] ) ? $_POST['download_link'] : '';
			if($download_link<>"" AND substr($download_link, -1)<>'/'){$download_link.='/';}//forzamos slash al final
			if(substr($download_link, 0 ,1)=='/'){$download_link=substr($download_link, 1);}//forzamos quitar slash al principio
		$product_name = isset( $_POST['product_name'] ) ? $_POST['product_name'] : '';
		global $wpdb;
		if($combos_option<>"One"){
			switch ($combos_option){
				case "Two": 
					$k=2;
					break;
				case "Three": 
					$k=3;
					break;
				case "Four": 
					$k=4;
					break;
			}//fin de switch
			
			for($l=0;$l<=$k-1;$l++){
				$combo_product="combo_product".$l;
				$array_products[] = isset( $_POST[$combo_product] ) ? $_POST[$combo_product] : '';
				//$array_products[]=sanitize_text_field($paso);
			}//end for
			$product->update_meta_data( '_combo_products', $array_products  ); //Los skus (codigos) de producto en array
		}
		if($autodispatch_option=="yes"&&$auto=="yes"){
			$rotation = isset( $_POST[$rotation] ) ? $_POST[$rotation] : '';
		}//fin if autodispatch_option
		$product->update_meta_data( '_autodispatch_option', sanitize_text_field( $autodispatch_option ) );
		if($auto=="yes"){
			$product->update_meta_data( '_combos_option', sanitize_text_field( $combos_option ) );//one, two, four
			$product->update_meta_data( '_download_link', sanitize_text_field( $download_link ) );
			$product->update_meta_data( '_product_name', sanitize_text_field( $product_name ) );
		}
		$product->save();
	}// function end

    }// fin de clase
}// fin de si existe clase


/**
 * Idioma por defecto del subsite (2 letras) con TranslatePress.
 * No usa el idioma actual del visitante; usa el "default-language" del sitio.
 */
//function get_language_subsite() {
function get_language_subsite( $blog_id = null ) {
    $restore = false;
    if ( is_multisite() && $blog_id && get_current_blog_id() !== (int) $blog_id ) {
        switch_to_blog( (int) $blog_id );
        $restore = true;
    }

    $lang = '';

    // 1) TranslatePress: usar la opción del sitio si existe
    $trp = get_option('trp_settings');
    if ( empty($lang) && is_array($trp) && ! empty($trp['default-language']) ) {
        $lang = $trp['default-language']; // ej. 'it_IT' o 'it'
    }

    // 2) Polylang (si está activo en ese subsite)
    if ( empty($lang) && function_exists('pll_default_language') ) {
        $pll = pll_default_language('slug'); // 'it', 'es', ...
        if ( ! empty($pll) ) $lang = $pll;
    }

    // 3) Idioma del sitio puro (no depende del user locale en admin)
    if ( empty($lang) ) {
        $wplang = get_option('WPLANG'); // ej. 'it_IT' o '' si es inglés por defecto
        if ( $wplang === '' ) {
            // WordPress guarda inglés como vacío; normalizamos
            $wplang = 'en_US';
        }
        $lang = $wplang;
    }

    // 4) Último recurso
    if ( empty($lang) ) {
        $lang = get_bloginfo('language') ?: get_locale();
    }

    if ( $restore ) {
        restore_current_blog();
    }

    // Normalizar a 2 letras
    $parts = preg_split('/[_-]/', (string) $lang);
    return strtolower($parts[0] ?? 'en');
}


// Funcion para crear el link al manual, por product_id
function waolm_get_manual_url( $product_id ) {
	//$options = get_option( '_waolm_client_options' );
	//$base    = isset( $options['urlmanuals'] ) ? trim( $options['urlmanuals'] ) : '';
	$base	= trim(get_waolm_client_option('urlmanuals'));
	$path    = trim( get_post_meta( $product_id, '_download_link', true ) );
	if($path==""){
//		$path = trim( get_post_meta( $product_id, '_sku', true ) );
//		$path = "/".strtolower($path);

		//$lang = strtolower( preg_split('/[_-]/', get_bloginfo('language') ?: get_locale() )[0] ?? 'en' ); 
		$lang = get_language_subsite();
		
		$path = trim( get_post_meta( $product_id, '_sku', true ) );
		$path = $lang."/".strtolower($path);


	}
	// Si no hay base o path, retornar vacío
	//if ( empty( $base ) || empty( $path ) ) {  
	if (empty($base)) {
		return '';
	}

	// Asegurar que el esquema sea https://
	if ( strpos( $base, 'http://' ) === 0 ) {
		//$base = preg_replace( '/^http:\/\//', 'https://', $base );
	} elseif ( strpos( $base, 'https://' ) !== 0 ) {
		$base = 'https://' . ltrim( $base, '/' );
	}

	// Eliminar slash final de base y slash inicial de path
	$base = rtrim( $base, '/' );
	$path = ltrim( $path, '/' );

	// Unir base y path correctamente
	$full_url = $base . '/' . $path;

	return esc_url( $full_url );
}


// Poblar el metadato _download_link de los productos, con /sku
function waolm_generate_download_links() {
	if(isset($_POST['download_link'])&&$_POST['download_link']=="***"){
		delete_option('waolm_download_links_done');
	}

	if(get_option('waolm_download_links_done')) {
		return;
	}
	$_POST['download_link']=="entro";
	/*$args = array(
		'post_type'      => 'product',
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'meta_query'     => array(
			'relation' => 'AND',
			array(
				'key'     => '_autodispatch_option',
				'value'   => 'yes',
				'compare' => '=',
			),
			array(
				'key'     => '_combos_option',
				'value'   => 'One',
				'compare' => '=',
			),
		),
	);*/
	$args = array(
		'post_type'      => 'product',
		'posts_per_page' => -1,
	);

	$products = get_posts( $args );
	//$idioma   = substr( get_locale(), 0, 2 );
	$idioma   = substr( get_option('WPLANG'), 0, 2 );

	foreach ( $products as $product ) {
		$sku = strtolower( get_post_meta( $product->ID, '_sku', true ) );
		if ( ! empty( $sku ) ) {
			$download_link = $idioma . '/' . $sku;
			update_post_meta( $product->ID, '_download_link', $download_link );
		}
	}

	update_option( 'waolm_download_links_done', 1 );
}
add_action( 'init', 'waolm_generate_download_links' );

/**
 * Borra TODOS los postmeta con meta_key = '_download_link'
 * - Single site: usa option 'wao_purge_download_link_done'
 * - Multisite: recorre todos los sitios y usa site_option 'wao_purge_download_link_done'
 * Devuelve el total de filas eliminadas.
 */
function wao_purge_download_link_meta_once() {
    $flag_key = 'wao_purge_download_link_done';

    if ( is_multisite() ) {
        if ( get_site_option( $flag_key ) ) {
            return 0; // ya se ejecutó
        }
        $total_deleted = 0;
        $site_ids = get_sites( [ 'fields' => 'ids', 'number' => 0 ] );
        foreach ( $site_ids as $blog_id ) {
            switch_to_blog( (int) $blog_id );
            $total_deleted += wao__delete_download_link_meta_for_current_blog();
            restore_current_blog();
        }
        add_site_option( $flag_key, [ 'ts' => time(), 'deleted' => $total_deleted ] );
        return $total_deleted;

    } else {
        if ( get_option( $flag_key ) ) {
            return 0; // ya se ejecutó
        }
        $deleted = wao__delete_download_link_meta_for_current_blog();
        add_option( $flag_key, [ 'ts' => time(), 'deleted' => $deleted ] );
        return $deleted;
    }
}

/**
 * Borra para el blog actual. Devuelve filas afectadas.
 */
function wao__delete_download_link_meta_for_current_blog() {
    global $wpdb;
    // Eliminación directa, más eficiente y nos da el conteo.
    $sql = "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s";
    return (int) $wpdb->query( $wpdb->prepare( $sql, '_download_link' ) );
}

add_action('admin_init', function(){
    if ( isset($_GET['wao_purge_download_link']) && current_user_can('manage_options') ) {
        $deleted = wao_purge_download_link_meta_once();
        wp_die( "Listo. Eliminados {$deleted} metadatos '_download_link'." );
    }
});