<?php
/** 
* Class to send keys on customer email 
* @package WAOLM 
* Version 4.0.2 (27-10-2025)
* 
*/

// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

// LOGICA PARA REPROCESAR DESPACHO AUTOMÁTICO CUANDO NO SE ENVIO POR CUALQUIER MOTIVO.
// Agregar una nueva acción al widget "Order Actions"
add_filter( 'woocommerce_order_actions', function( $actions ) {
	$order_id = get_the_ID();
	$llaves_enviadas = get_post_meta($order_id,'llaves_enviadas',true); 
	if (empty($llaves_enviadas)) {
		$actions['procesar_despacho_automatico'] = __( 'Procesar despacho automático', 'textdomain' );
	}
    return $actions;
});
// Ejecutar la función cuando se seleccione la acción personalizada
add_action( 'woocommerce_order_action_procesar_despacho_automatico', function( $order ) {
    if ( $order instanceof WC_Order ) {
        $order_id = $order->get_id();
		$llaves_enviadas = get_post_meta($order_id,'llaves_enviadas',true);
		if (empty($llaves_enviadas)) {			
			// Llamar a la función personalizada
			fill_table_keys( $order_id, $order );
			// Reenviar el correo de "Processing Order"
			$mailer = WC()->mailer();
			$emails = $mailer->get_emails();
			if ( isset( $emails['WC_Email_Customer_Completed_Order'] ) ) {
				$emails['WC_Email_Customer_Completed_Order']->trigger( $order_id );
				$order->update_status( 'completed' );
			}
		}// fin de si llaves enviadas
    }
});

add_action( 'woocommerce_new_order', 'fill_table_keys', 10, 2 );
add_action( 'woocommerce_email_order_details', 'auto_dispatch_table', 5, 4 );
/*https://www.businessbloomer.com/woocommerce-add-extra-content-order-email/*/
      
//////////////////////////////////AQUI EMPIEZAN LAS FUNCIONES/////////////////////////////////////////////////
function fill_table_keys($order_id, $order) {
	global $wpdb;
	$despachartodo=TRUE;
	$actualizarstock=TRUE;
	$depu=array();
	$depu['order_id']=$order_id;
	$customer_email=$order->get_billing_email();
	$totalitem=0;
	$items=0;
	$envio=array();

	//////////////////
	//bucle de ITEMS de la ORDER
	//////////////////
	$i=0;//para bucle de items
	$j=0;//para blucle de combo
	$razon=$accion="";
	foreach( $order->get_items() as $item_id => $item ) {
		if($item->get_type()=='line_item'){
$depu[$item_id]['type']=$item->get_type();
			$items++;
			$product_id_1 = $item->get_product_id();
			$autodispatch=get_post_meta($product_id_1,'_autodispatch_option',true);
$depu[$item_id]['autodispatch']=$autodispatch;
			if($autodispatch<>'yes'){//aqui poner un if is_set
					$despachartodo=FALSE;
					$razon = "Despacho autom&aacute;tico no activo para uno o mas productos!";
					$accion = "Activar el despacho autom&aacute;tico para los productos, si la pol&iacute;tica de la empresa lo permite.";
			}else{
				
				$quantity = $item->get_quantity();
$depu[$item_id]['quantity']=$quantity;
				//las claves son cargadas para el producto raiz, no para las  variaciones
				//las variaciones solo sirven para descontar el stock
				$variation_id = $item->get_variation_id();
				$variation=1;
				if($variation_id==0){
						$variation_id=$product_id_1;
						$muestraversion[$items]=false;
						$variation=1;
				}else{
						$muestraversion[$items]=true;
						$variation=obtenervariacion($variation_id);//funcion local producto es 1pc, 2pc, etc
				}
				if(escombo($product_id_1)){//funcion local, pregunta si _combos_option del producto = One, two, three o four
						$productoscombo=combos($product_id_1);//funcion local, si el producto en order es combo, jala los skus
						$l=0;
				}else{
						unset($productoscombo);
						$productoscombo[0]=get_post_meta($product_id_1,'_sku',true);
				}
				//////////////////
				//bucle de COMBOS
				//////////////////
				$j=0;//para bucle de combo
				if(!empty($productoscombo)){//el producto es combo pero no se ha configurado
					foreach($productoscombo as $product_sku){
$depu[$item_id][$product_sku]['sku']=$product_sku;
							//verificar si se configuraron todos los skus del combo
							if($product_sku=='0' OR empty($product_sku)){
								$razon = "Uno o mas productos del combo NO est&aacute;n seleccionados.";
								$accion = "Despache en forma manual y revise la configuración del producto combo. As&iacute;gne los productos correspondientes.";
								$despachartodo=FALSE;
								break;
							}
							//////////////////
							//bucle PRODUCT_ID
							//////////////////
							$despachados=0;
							$cuantas=cuantas_llaves($product_sku,$variation);//Tengo por ejemplo 3 llaves con mas activaciones que variaciones
$depu[$item_id][$product_sku]['cuantas']=$cuantas;
$depu[$item_id][$product_sku]['query_cuantas']=cuantas_llaves_q($product_sku,$variation);
							$totalitem+=$quantity;
							$tp=$wpdb->prefix;	
							//dado sku, hallar id del producto en la tienda cliente. Para busqueda de nombre amigable
							//$combo_id = product_id_por_sku($product_sku);
							$combo_id = $wpdb->get_var($wpdb->prepare("SELECT P.ID FROM {$tp}posts AS P INNER JOIN {$tp}postmeta AS M ON P.ID = M.post_id WHERE P.post_type = 'product' AND P.post_status = 'publish' AND M.meta_key = '_sku' AND M.meta_value = %s LIMIT 1", $product_sku));

							if($cuantas >= $quantity){ /// cuantas llaves existen en total con activaciones > variation 
									$tiene_quemadas=0;
									$priority=1;
									// Cargar tabla con llaves para sku $quantity no es funcional, devolvera tabla con todas las llaves
									$todaslasfilas=las_llaves($product_sku,$variation,$quantity,$priority);
$depu[$item_id][$product_sku]['las_llaves_q']=las_llaves_q($product_sku,$variation,$quantity,$priority);
									if(count($todaslasfilas)>=$quantity){ // Si hay mas filas de llaves que la cantidad solicitada
										// Cambiar nombres si se tiene configurado nombre amigable
										for($k = 0; $k < count($todaslasfilas); $k++){
											$todaslasfilas[$k]->variation=$variation;
										}
										// AQUI SE DEBEN FILTRAR LLAVES YA POSEIDAS POR EL CLIENTE, O ENVIADAS AHORA MISMO
										// $todaslasfilas=quitar_llaves_ya_poseidas_tabla($todaslasfilas,$product_sku,$customer_email );
										$filasaenviar = array_slice($todaslasfilas, 0, $quantity); // de todas las llaves disponibles, dejamos las n primeras
										$despachados+=count($filasaenviar,1);// 1 para recursivo
										$tiene_quemadas=0;
									}else{// Si han menos llaves que las solicitadas, despachar todo a falso. Sin embargo if para la razon
									// Si se supo que el cliente ya tiene llave quemada, proseguir envio (o #llaves > que lo configurado)
										if($tiene_quemadas){
											$keysfallidas.=$product_sku."|";
											$razon = "Cliente ya posee mismas llaves para (".$keysfallidas.")";
											$accion = "Verifique que llaves ya recibi&oacute; el cliente y enviele una llave nueva. Configure cantidad permitida de llaves repetidas";
											$despachartodo=FALSE;
										}else{ // Esto significa que de hecho NO HABIA LA CANTIDAD DE LLAVES QUE EL CLIENTE SOLICITO
											$despachartodo = FALSE;
											$razon = "Uno o mas productos (".$product_sku.") no tienen el stock necesario!";
											$accion = "Despache en forma manual y aseg&uacute;rese que estos productos cuenten con activaciones suficientes!";
										}
									}
									$envio[] = $filasaenviar;
							}else{
								$despachartodo=FALSE;
								$razon = "Aunque despacho automático está activado, algún producto no cuenta con stock.";
								$accion = "Verifique stock para cada producto y procese el despacho automático nuevamente.";
							}//if cuantas > quantity END
							$j++;
							//////////////////////
							//bucle PRODUCT_ID END
							//////////////////////
							$esd_links[$product_sku]=waolm_get_manual_url($combo_id);//waolm-pestana-en-producto.php
					}
				}else{//if empty productoscombo
					$razon = "Uno o mas productos del combo no est&aacute;n seleccionados.";
					$accion = "Despache en forma manual y revise la configuración del producto combo. As&iacute;gne los productos correspondientes."; 
					$despachartodo=FALSE;
				}//if empty productoscombo
				$i++;
				//////////////////
				//bucle de COMBOS END
				//////////////////
			}//fin de si autodispatch <> yes
		}//fin de si line_item
	}//foreach BUCLE DE ITEMS END
	//////////////////
	//bucle de ITEMS de la ORDER END
	//////////////////
	if($despachartodo){
			$order->add_order_note( 'WAOLM: Existen llaves para los productos.', false );
			update_post_meta($order_id,'_dispatchnow','yes');// Visto bueno para enviar las llaves en completed order
			$actualizarstock&&update_post_meta($order_id,'_esd_links',$esd_links);// actualiza los links referenciados por sku en un serializado
			$actualizarstock&&update_post_meta($order_id,'_keys',$envio);// actualiza las llaves en un campo serializado
			$salida = $actualizarstock?latabla($envio, $esd_links, $muestraversion):'';// Devuelve las llaves en un template html
			update_table_waolm_dispatched_keys($envio,$customer_email,$order_id);
			$actualizarstock&&update_post_meta($order_id,'_table_keys',htmlentities($salida));// actualiza las llaves en su template html

	}else{
//$depu['envio']=$envio;
//$depu['despachartodo']=$despachartodo;
update_post_meta($order_id,'_depu',$depu);
		update_post_meta($order_id,'_dispatchnow','no');// no se hara despacho automatico
	}//if despachar END
	update_post_meta($order_id,'_razon',$razon);// guardamos el motivo por el que no se realizó el despacho
	update_post_meta($order_id,'_accion',$accion);// sugiere una accion a realizar
}//function END 

// Disparar despacho automatico cuando el metodo de pago ha confirmado el pago
add_action('woocommerce_payment_complete', 'waolm_procesar_pago_confirmado', 10, 1);
function waolm_procesar_pago_confirmado($order_id) {
			$dispatchnow=get_post_meta($order_id,'_dispatchnow');
			$order = wc_get_order( $order_id );
			// $order->add_order_note( 'Woocommerce confirmó pago completado y dispatchnow es '.$dispatchnow[0], false );
			if($dispatchnow[0]=="yes"){
				$order->add_order_note( 'WAOLM: DA. activado por método de pago.', false );
				$order->update_status( 'completed' );
			}
}

// Disparar despacho automatico para metodo cod en processing
add_action('woocommerce_order_status_processing', 'waolm_si_cod_en_processing', 10, 1);
function waolm_si_cod_en_processing($order_id) {
    $order = wc_get_order($order_id);
    if (!$order) return;
    if ($order->get_payment_method() === 'cod') {
		$dispatchnow=get_post_meta($order_id,'_dispatchnow');
		if($dispatchnow[0]=="yes"){
			$order->update_status( 'completed' );
		}
    }
}


function auto_dispatch_table( $order, $sent_to_admin, $plain_text, $email ) {
	if ( $email->id == 'customer_completed_order' ) {
			$order_id=$order->get_id();
			$dispatchnow=get_post_meta($order_id,'_dispatchnow');
			// Obtener el correo electrónico del cliente
			$customer_email = $order->get_billing_email();
			//////////////////
			// GRAN IF 
			//////////////////
			if($dispatchnow[0]=="yes"){
				$salida = "";
				$table_keys=get_post_meta($order_id,'_table_keys');
				if (!empty($table_keys)){
					$salida = html_entity_decode($table_keys[0]);
					echo $salida;
					llaves_entregadas($order_id);
					$order->add_order_note( 'WAOLM: Llaves despachadas en email completed order.', false );
					update_post_meta($order_id,'llaves_enviadas','yes');
				}//if empty  envio END
			}//if dispatchno=yes END
			//////////////////
			// GRAN IF END
			//////////////////
	}//$email->id == 'customer_completed_order'  END
}//function END

function latabla($envio,$esd_links,$muestraversion){
	$template = template();
	$filas = "";
	$k=0;
	foreach($envio as $prod){
			$parimpar='par';
			$template_link = '<tr class="plink" style="font-style: italic;"><td colspan=3 style="border-top: solid 1px #e5e5e5;border-bottom: solid 1px #e5e5e5;"><p>{download_link}&nbsp;<a href="{link}" target="_blank"> {producto}</a></td></tr>';
			foreach($prod as $fila){
				$template_fila ='<tr class={parimpar}><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{nro}</td><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{producto}</td><td style="border-top: solid 1px #e5e5e5;border-bottome: solid 1px #e5e5e5;">{llave}</td></tr>';
				$parimpar=$parimpar=="par"?"impar":"par";
				$k++;
				if(isset($muestraversion[$k])&&$muestraversion[$k]){//Undefined array key 2 in waolm-insert-keys-on-customer-email.php on line 307
					$fila->produc_tname.="<p class='pversion' style='font-size:small;'>Version: ".$fila->variation." PC.</p>";
				}
				//activaciones($fila->_key,$fila->waolm_sku,$fila->variation,$fila->nro);
				descontar_activaciones($fila->id,$fila->variation);
				incrementar_despachados($fila->id,$fila->variation);
				$template_fila = str_replace('{parimpar}',$parimpar,$template_fila);
				$template_fila = str_replace('{nro}',$fila->priority,$template_fila);
				//$template_fila = str_replace('{producto}',$fila->shop_product_name,$template_fila); 
				//$template_fila = str_replace('{producto}',$fila->product_name,$template_fila); 
				$template_fila = str_replace('{producto}',site_product_name($fila->waolm_sku),$template_fila); 

                $key = $fila->_key ?? $fila->skey ?? '';
				 
				$template_fila = str_replace('{llave}',$key,$template_fila);
				$filas .= $template_fila;
			}// foreach END

            $wsku = $fila->waolm_sku ?? $fila->sku ?? '';
			$template_link = str_replace('{download_link}',__( 'Download Link:', 'waolicensemanager' ),$template_link);
			$template_link = str_replace('{link}',$esd_links[$wsku],$template_link);
			$template_link = str_replace('{producto}',$fila->product_name,$template_link);
			$filas .= $template_link;
	}
	$template = str_replace('{titulo}',__( 'Your Software Activation Keys', 'waolicensemanager'),$template);
	$template = str_replace('{tit_nro}',__( 'Nr.', 'waolicensemanager' ),$template);
	$template = str_replace('{tit_product}',__( 'Product', 'waolicensemanager' ),$template);
	$template = str_replace('{tit_key}',__( 'Key', 'waolicensemanager' ),$template);
	$template = str_replace('{filas}',$filas,$template);
	return $template;
}

function escombo($post_id){ // consulta sobre producto en local
	$combos_option = get_post_meta($post_id,'_combos_option');
	if(empty($combos_option)||$combos_option[0]=='One'){
		return FALSE;
	}else{
		
		return TRUE;
	}
}// function escombo END 

function combos($post_id){ // consulta sobre producto en local
	$combo_products = get_post_meta($post_id,'_combo_products',true);
	return $combo_products;
}//function combos END

function obtenervariacion($variation_id){ // consulta sobre producto variable en local
	global $wpdb;
	$q="SELECT menu_order FROM {$wpdb->prefix}posts WHERE ID = {$variation_id}";
	$var=$wpdb->get_var($q);

	$var = $wpdb->get_var(
		$wpdb->prepare(
			"SELECT menu_order FROM {$wpdb->prefix}posts WHERE ID = %d",
			$variation_id
		)	
	);



	return $var[0]; 
} 

function new_waolicensemanager_column( $columns = array() ) {
    // Add new columns
    $columns['waolicensemanager-status'] = 'AD';
    return $columns;
}

function waolicensemanager_column_content( $column ) {
    //global $the_order; // you can use the global WP_Order object here
	global $post; // is also available here
 
    if( $column == 'waolicensemanager-status' ) {

		$autodispatch=get_post_meta($post->ID, '_autodispatch_option',true);

	
		if(!empty($autodispatch)&&$autodispatch=="yes"){
			echo "<c style='color:green'>YES</c>";
		}else{
			//echo "no";
		}
        // do stuff, ex: get_post_meta( $post->ID, 'key', true );
    }

}
add_filter( 'manage_edit-product_columns','new_waolicensemanager_column');
add_action( 'manage_product_posts_custom_column' , 'waolicensemanager_column_content' );	

// 1) Hacer la columna "waolicensemanager-status" ordenable
add_filter( 'manage_edit-product_sortable_columns', 'waolm_autodispatch_sortable_column' );
function waolm_autodispatch_sortable_column( $columns ) {
    // La clave del índice debe ser el ID de la columna que definiste antes
    $columns['waolicensemanager-status'] = 'waolicensemanager-status';
    return $columns;
}

// 2) Modificar la query para ordenar por el meta _autodispatch_option
add_action( 'pre_get_posts', 'waolm_autodispatch_orderby' );
function waolm_autodispatch_orderby( $query ) {
    if ( ! is_admin() || ! $query->is_main_query() ) {
        return;
    }

    $orderby = $query->get( 'orderby' );

    if ( 'waolicensemanager-status' === $orderby ) {

        // Añadimos las dos metas a la query
        $meta_query = (array) $query->get( 'meta_query' );

        $meta_query['autodispatch_clause'] = array(
            'key'     => '_autodispatch_option',
            'compare' => 'EXISTS',
        );

        $meta_query['combos_clause'] = array(
            'key'     => '_combos_option',
            'compare' => 'EXISTS',
        );

        $query->set( 'meta_query', $meta_query );

        // Orden: primero _autodispatch_option, luego _combos_option
        // Ajusta ASC/DESC según te convenga
        $query->set( 'orderby', array(
            'autodispatch_clause' => 'DESC', // YES arriba si usas 'yes' / vacío
            'combos_clause'       => 'ASC',  // One, Four, etc. en orden alfabético
        ) );
    }
}



 // Con copia a admin  
function bbloomer_order_completed_email_add_cc_bcc( $headers, $email_id, $order ) {
    if ('customer_completed_order'==$email_id){
		$adm_email=get_option('admin_email');
        $headers .= "Cc: Copia para admin <".$adm_email.">\r\n"; // delete if not needed
    }
    return $headers;
}
add_filter( 'woocommerce_email_headers', 'bbloomer_order_completed_email_add_cc_bcc', 9999, 3 );

// Template HTML para las llaves y links
function template(){
	$template = '
	<hr><h2>{titulo}</h2>
	<table class="td tablekeys" cellspacing="0" cellpadding="6" style="width: 100%; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_nro}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_product}</th>
				<th class="td" scope="col" style="text-align:{text-align}">{tit_key}</th>
			</tr>
		</thead>
		<tbody>
		{filas}
		</tbody>
	</table>
	<br><hr>...
	';
	$template = get_smart_waolm_client_option('email_template',$template);
	return $template;
}


//////////////////////////////////AQUI TERMINAN LAS FUNCIONES/////////////////////////////////////////////////

function site_product_name( $sku) {
	global $wpdb;

	$sku = trim( (string) $sku );
	if ( $sku === '' ) {
		return null;
	}
	$custom_key = site_custom_produc_name($sku);
	if(!empty($custom_key)){
		return $custom_key;
	}
	// Prefix correcto para el sitio 12 en multisite (wp_12_)
	$prefix = $wpdb->base_prefix;

	// Si el SKU pertenece a una variación, devolvemos el título del producto padre.
	$sql = $wpdb->prepare(
		"SELECT CASE
					WHEN p.post_type = 'product_variation'
						THEN (SELECT pp.post_title FROM {$prefix}posts pp WHERE pp.ID = p.post_parent LIMIT 1)
					ELSE p.post_title
				END AS product_title
		 FROM {$prefix}postmeta m
		 INNER JOIN {$prefix}posts p ON p.ID = m.post_id
		 WHERE m.meta_key = '_sku'
		   AND m.meta_value = %s
		 ORDER BY (p.post_status = 'publish') DESC, p.ID DESC
		 LIMIT 1",
		$sku
	);

	return $wpdb->get_var( $sql ); // string|null
}

function table_product_name( $sku) {
	global $wpdb;

	$sku = trim( (string) $sku );
	if ( $sku === '' ) {
		return null;
	}
	$prefix = $wpdb->base_prefix;

	// Si el SKU pertenece a una variación, devolvemos el título del producto padre.
	$sql = $wpdb->prepare(
		"SELECT product_name FROM {$prefix}waolm_product WHERE sku = %s",
		$sku
	);
	//return $sql;
	return $wpdb->get_var( $sql ); // string|null
}


function site_custom_produc_name($sku){
	$product_id = wc_get_product_id_by_sku( $sku );
	$new_name=get_post_meta($product_id,'_product_name',true);
	if(isset($new_name)){
		return $new_name;
	}
	return '';
}

function quitar_llaves_ya_poseidas_tabla($todaslasfilas,$product_sku,$customer_email){
	//$todaslasfilas es un array con una propiedad _key
	// buscar en las tablas wp_waolm_rel_orders y wp_waolm_rel_order_keys
	// todas las _key = wp_waolm_rel_orders_keys.key AND wp_waolm_rel_order.customer_email=$customer_email AND wp_waolm_rel_orders_keys.sku = $product_sku
	// si existe tal fila, borrar esta instancia de $todaslasfilas
	return $todaslasfilas;
}