<?php
/** 
* Plugin Name: WAO License Manager
* Description: Auto dispatch software keys at completed order email.(Envia correo completed a admin) 
* Version: 4.0.7
* Date: 2025.11.21
* Change Log: Columna AD ordenable en listado de productos. En la edicion de productos, ver los nombres de producto de la tabla.En email del cliente y thankyoupage, ver nombre de producto del mismo producto.(Idiomas danish,dutch,finnish,french,german,italian,norwegian,spanish,swedish, Capacidad de expotar e importar llaves. Nuevas tablas y migración. Cambio de disparador para despacho automatico. Inserta en productos metadato _download_link a partir de idioma y sku, Funcion waolm_generate_download_links
* Corregido: No sale nombre de producto de llave enviada en ordenes corregido. No genera link de descarga cuando no se configuro producto. Duplica llaves al actualizar. Corregido: mostrar llaves solo cuando comprado. Modificado: uso de templates. Link de pago mudado a stephanpay plugin. Link de pago para stephanpay en la thankyoupage. Boton para actualizar llaves aun no enviadas en edicion de orden. La configuracion para mostrar llaves en la checkout page ahora en WAOLM Client Setting. Toda orden se acualiza a completed corregido. Funcion de actualizacion solo se dispara en la pagina de plugins de la red. Warnings corregidos. Cambio de logica en despacho automatico) 
* Author: Arturo Zubieta 
* Author URI: https://winandoffice.com/ 
* Text Domain: waolicensemanager
* WC requires at least: 3.2.0 
* WC tested up to: 3.3.0 
* License: GPL-2.0+ 
* License URI: https://www.gnu.org/licenses/gpl-2.0.txt 
*/

/* ESTRUCTURA DE LAS VARIABLES USADAS EN EL PLUGIN
 *	SERVER:	wp_options[_waolm_server_options]
 *		- API
 *			apiserverkey
 *	SERVER:	wp_options[_waolm_client_options]
 *		- General
 *			s:10:"urlmanuals";s:31:"https://esd.dl-winandoffice.com";
 *			s:8:"payments";s:257:"cod|ppec_paypal";
 *			s:14:"llavesquemadas";s:0:"";
 *			s:10:"tolerancia";s:0:"";
 *			s:6:"new_to";s:22:"artux@winandoffice.com";
 *			s:11:"purgar_keys";s:0:"";
 *		- Migracion
 *		- Checkout page
 *			s:18:"thankyou_show_keys";s:0:"";
 *		- API client setting
 *			s:14:"external_server_on";s:2:"on";
 *			s:14:"externalserver";s:32:"https://arturo.winandoffice.com/";
 *			s:10:"api_client";s:15:"7YPUdHRqgcuPXrU";	 
 *	CLIENT:wp_xx_options[_waolm_options]
 *		- Templates
 *			s:14:"email_template";s:511:"<hr><h2>{titulo}</h2>";
 *			s:17:"checkout_template";s:1927:"<style>"; 
*/

// Exit if accessed directly 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'WAOLM_PLUGIN_VERSION' ) ) {
	define( 'WAOLM_PLUGIN_VERSION', '4.0.7' );
}
if ( ! defined( 'WAOLM_PLUGIN_DIR_PATH' ) ) {
	define( 'WAOLM_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

// CARGAR IDIOMAS  
function waolicensemanager_load_textdomain() {
    load_plugin_textdomain( 'waolicensemanager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'waolicensemanager_load_textdomain' );

include("waolm-update.php"); // Logica de actualización
//include ("classes/waolm-migrate.php");  // Funciones de migración
//include ("classes/waolm-migration-cron.php"); // Funciones de migración cron
include ("classes/waolm_on_intall_update.php"); // Funciones de migración cron

if(is_multisite()){ 
	require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-cpt-table.php' );
	include ("classes/waolm-client-settings-network.php"); // config de cliente en network
	include ("classes/waolm-client-settings-site.php"); // config de cliente en site
}else{
	include ("classes/waolm-cpt.php"); // CPT en local (antiguo)
	include ("classes/waolm-client-settings-nomultisite.php"); // Server y client config local (antiguo)
}

include ("classes/waolm-insert-keys-on-customer-email.php"); // El motor del plugin
include ("classes/waolm-llavesclientemetabox.php"); 
include ("classes/waolm-susllaves-en-edit-order.php");
include ("classes/waolm-tests.php");  
include ("classes/waolm-keys-on-thankyou-page.php");
include ("classes/waolm-products.php");
include ("classes/waolm-columna-llaves-no-enviadas.php");

include ("classes/waolm_querys_new.php"); 
// organizar_waolm_options_1();

// Bloque para instanciar pestanias de automatic dispatch en producto
require( WAOLM_PLUGIN_DIR_PATH . '/classes/waolm-pestana-en-producto.php' );

add_action( 'plugins_loaded', 'waolm_pestanias_init' );//Instancia de clase en waolm-client-functions.php
function waolm_pestanias_init() {
	if ( is_admin() ) {
		$WAOLM_Pestania = new WAOLM_Pestania();
		$WAOLM_Pestania->init();
	}
}

// funciones de ayuda
function wdepu($valor){
	$depu = get_option('_depu',[]);
	$depu[] = $valor;
	update_option('_depu',$depu);
}

