<?php
/**
 * Class WAO Segundo email  file.
 * (Error multisite en la linea 37 corregido)
 * @package waosegundoemail\Emails 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
// Construimos la clase wao_correo, encargada de preparar y disparar el 2do correo
if ( ! class_exists( 'wao_correo', false ) ) :
	class wao_correo { 

		public function __construct() {
			$this->id = 'custom_completed_order';
			$this->title = 'Custom Completed Order Email';
			$this->description = 'This is a custom completed order email sent via a different SMTP.';
			
			$this->template_html = 'emails/custom-completed-order.php';
			$this->template_plain = 'emails/plain/custom-completed-order.php';
			$this->placeholders   = array(
				'{order_date}'   => '',
				'{order_number}' => '',
				);
			$this->order_id = 1;
			// Verificamos que el template esté en su lugar
			$this->copiar_template();
			$this->poblar_parametros();
			// Triggers for this email.
			// ESTE NO add_action('woocommerce_order_status_completed', array($this, 'send_test_email_with_phpmailer1'),10,2);
			add_action('woocommerce_thankyou', array($this, 'send_test_email_with_phpmailer1'),10,2);
		}

		public function poblar_parametros(){
			if(is_multisite()){
				$maestro=get_blog_option(1,'segundoemailmaestro');
			}else{
				$maestro=get_option('segundoemailmaestro');
			}
			if ($maestro){
				switch_to_blog($maestro);
				}
			$opciones=get_option('segundoemail_options');
			$this->host=$opciones['host'];
			$this->username=$opciones['username'];
			$this->password=$opciones['password'];
			$this->smtptipo=$opciones['smtptipo'];
			$this->port=$opciones['port'];
			if ($maestro){
				restore_current_blog();
			}
		}

		function copiar_template() {
			$source_template =  ABSPATH . 'wp-content/plugins/waosegundoemail/templates/customer-second-completed-order.php';
			$destination_folder = (ABSPATH . 'wp-content/plugins/woocommerce/templates/emails/');//copiamos a la carpeta woocommerce/templates/emails
			$destination_folder = (get_stylesheet_directory() . '/woocommerce/emails/');			
			$destination_template = $destination_folder."customer-second-completed-order.php";
			if (!is_dir($destination_folder)) {
				mkdir($destination_folder, 0755, true);
			}
			if (!file_exists($destination_template)) {
				copy($source_template, $destination_template);
			}else{
				if (md5_file($source_template) !== md5_file($destination_template)) {
					if (copy($source_template, $destination_template)) {
						//echo '<div class="notice notice-success is-dismissible"><p>Template copied successfully!</p></div>';
					}
				}
			}
		}

		function contact_support($order_id) {
			$retorno = '<div style="background-color:#F5F5F5;border-left:solid 2px gray;margin-left:10px;margin-right:10px;padding:10px;text-decoration:none;"';
			$retorno .= '<p>'.__('The company guarantees the functionality of the product you received.','wao-tiendas').'</p>';
			$retorno .= '<p>'.__('If you have problems with it, our customer service department will solve any problem until you are completely satisfied.','wao-tiendas').'</p>';
			$retorno .= '<p>'.__('Contact us through:','wao-tiendas').'</p>';
			$su=get_option('home')."/support?order_id=".$order_id;
			$retorno .= '<a href="'.$su.'"><span style="background-color:#6527BE;border:solid 1px green;color:white;border-radius:10px;padding:5px 20px 5px 20px;"><i class="fa fa-comment-o" aria-hidden="true">&nbsp;'.__('Support','wao-tiendas').'</i></span></a>';
			return $retorno;
		}

		function limpia_la_traduccion($content){
			// Buscar y eliminar los números después de "data-trpgettextoriginal="
			$cadena_limpia = preg_replace('/data-trpgettextoriginal=\d+/', '', $content);
			// Luego, buscar y eliminar las cadenas conocidas
			#!trpst#trp-gettext data-trpgettextoriginal=6560#!trpen#Hallo michael#!trpst#/trp-gettext#!trpen#    #!trpst#/trp-gettext
			$cadena_final = str_replace(['#!trpst#trp-gettext', 'data-trpgettextoriginal=', '#!trpen#', '#!trpst#/trp-gettext','#!trpen#'], '', $cadena_limpia);
			// Imprimir la cadena final
			$content = utf8_decode($cadena_final);
			return $content;
		}

		//public function send_test_email_with_phpmailer1($order, $sent_to_admin, $plain_text, $email) { Ss
		public function send_test_email_with_phpmailer1($order_id) {//ESTE SI

			if (isset($this->host)&&isset($this->username)&&isset($this->password)&&isset($this->smtptipo)&&isset($this->port)){
				
				global $phpmailer; ///// Asegúrate de declarar la variable global
				// Obtenemos las configuraciones originales de envio de correo
				$opciones_email=get_option('woocommerce_customer_completed_order_settings');
				// Obtén la instancia de la orden
				$order = wc_get_order($order_id);
				$yaseenvio=get_post_meta($order_id,"email2sent");
				//$yaseenvio=get_post_meta($order->get_id(),"email2sent");
				if($order->get_status()=="completed"&&!$yaseenvio){
					// Creamos un objeto $email para compatibilidad, ya que en esta instancia no existe!
					if (function_exists('WC')) {
						$mailer = WC()->mailer();
						$email = $mailer->emails['WC_Email_Customer_Completed_Order'];
					}
					// Obtenemos el template 
					$template = 'emails/customer-second-completed-order.php'; //Esto se debe copiar a woocommerce/templates/emails
					//  Configuracion del contenido del correo
					$email_heading = isset($opciones_email['heading'])&&$opciones_email['heading']<>""?__($opciones_email['heading'],'woocommerce'):__("Thanks for shopping with us","woocommerce");
					$additional_content = isset($opciones_email['additional_content'])&&$opciones_email['additional_content']<>""?__($opciones_email['additional_content'],'woocommerce'):"";
					$sent_to_admin = false;
					$plain_text = false; 
					// Obtenemos el contenido del template. Tambien podriamos cargar email-header.php o email-footer.php con wc_get_template()
					ob_start();
					wc_get_template($template, array(
						'order' => $order,
						'email' => $email,
						'sent_to_admin'=>$sent_to_admin, 
						'plain_text'=>$plain_text, 
						'email_heading'=>$email_heading,
						'additional_content'=>$additional_content,
						'text_align'=>'left',
						'contact_support1'=>$this->contact_support($order->get_id())));
					$content = ob_get_clean();
					$content = $this->limpia_la_traduccion($content);

					// Configurar el transporte SMTP usando $phpmailer

					$phpmailer->isSMTP();
					$phpmailer->SMTPAuth = true;

					$phpmailer->Host = $this->host;
					$phpmailer->Username = $this->username;
					$phpmailer->Password = $this->password;

					$phpmailer->SMTPSecure = $this->smtptipo;
					$phpmailer->Port = $this->port;
					
					///Configuración del correo electrónico
					$recipient = $order->get_billing_email();
					$subject = isset($opciones_email['subject'])&&$opciones_email['subject']<>""?__($opciones_email['subject'],'woocommerce'):__("Your {site_title} order is now complete","woocommerce");
					$subject = str_replace("{site_title}",get_bloginfo('name'),$subject);
					$phpmailer->setFrom($phpmailer->Username, get_option('woocommerce_email_from_name'));
					$phpmailer->addAddress($recipient);
					$phpmailer->Subject = $this->limpia_la_traduccion($subject);
					$phpmailer->IsHTML(true); 
					$phpmailer->Body = ($content);
					$phpmailer->addReplyTo(get_option('admin_email','rodrikgerman@gmail.com'), get_option('blogname'));
					// Enviar el correo electrónico
					try{
					if($phpmailer->send()){
						update_post_meta($order_id,'email2sent','yes');
						//echo "Correo enviado con Exito!";
						}else{
						//echo "Correo NO enviado :(";
						throw new Exception('Can not send email: ' . $phpmailer->ErrorInfo);
						}
					}catch(Exception $e) {
						//// Captura cualquier excepción y maneja los errores
						error_log('Error sending email: ' . $e->getMessage());
					}
				}//fin de si estado es completed
			}//fin de if
		}

	}///fin de clase wao_correo
endif;

//return new wao_correo();
