<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'vendor/autoload.php';
/**
 * Aliases for League Provider Classes
 * Make sure you have added these to your composer.json and run `composer install`
 * Plenty to choose from here:
 * @see http://oauth2-client.thephpleague.com/providers/thirdparty/
 */
//@see https://github.com/thephpleague/oauth2-google
use League\OAuth2\Client\Provider\Google;
//@see https://packagist.org/packages/hayageek/oauth2-yahoo
use Hayageek\OAuth2\Client\Provider\Yahoo;
//@see https://github.com/stevenmaguire/oauth2-microsoft
use Stevenmaguire\OAuth2\Client\Provider\Microsoft;

$providerName = '';
session_start();

if (array_key_exists('provider', $_GET)) {
    $providerName = $_GET['provider'];
    $_SESSION['provider'] = $providerName;
} elseif (array_key_exists('provider', $_SESSION)) {
    $providerName = $_SESSION['provider'];
}
if (!in_array($providerName, ['Google', 'Microsoft', 'Yahoo'])) {
    exit('Only Google, Microsoft and Yahoo OAuth2 providers are currently supported in this script.');
}

//These details are obtained by setting up an app in the Google developer console,
//or whichever provider you're using.
if(isset($_GET['client_id'])) {
    $clientId = $_GET['client_id'];
    $clientSecret = $_GET['client_secret'];


    //If this automatic URL doesn't work, set it yourself manually to the URL of this script
    $redirectUri = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];

    $params = [
        'clientId' => $clientId,
        'clientSecret' => $clientSecret,
        'redirectUri' => $redirectUri,
        'accessType' => 'offline'
    ];

    $options = [];
    $provider = null;

    switch ($providerName) {
        case 'Google':
            $provider = new Google($params);
            $options = [
                'scope' => [
                    'https://mail.google.com/'
                ]
            ];
            break;
        case 'Yahoo':
            $provider = new Yahoo($params);
            break;
        case 'Microsoft':
            $provider = new Microsoft($params);
            $options = [
                'scope' => [
                    'wl.imap',
                    'wl.offline_access'
                ]
            ];
            break;
    }

    if (null === $provider) {
        exit('Provider missing');
    }

    if (!isset($_GET['code'])) {
        //If we don't have an authorization code then get one
        $authUrl = $provider->getAuthorizationUrl($options);
        $_SESSION['oauth2state'] = $provider->getState();
        header('Location: ' . $authUrl);
        exit;
        //Check given state against previously stored one to mitigate CSRF attack
    } elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {
        unset($_SESSION['oauth2state']);
        unset($_SESSION['provider']);
        exit('Invalid state');
    } else {
        unset($_SESSION['provider']);
        //Try to get an access token (using the authorization code grant)
        $token = $provider->getAccessToken(
            'authorization_code',
            [
                'code' => $_GET['code']
            ]
        );
        print_r($token);
        //Use this to interact with an API on the users behalf
        //Use this to get a new access token if the old one expires
        
        echo 'Refresh Token: ', $token->getRefreshToken();
        $myfile = fopen("token.txt", "w") or die("Unable to open file!");
        $txt = json_encode($token);
        fwrite($myfile, $txt);
        fclose($myfile);
        $redirectUri = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/wp-admin/admin.php?page=segundoemail_settings&readfile=true';
        echo '<a href="'.$redirectUri.'">Return</a>';
    }
}
else {
    $redirectUri = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/wp-admin/admin.php?page=segundoemail_settings&readfile=true';
    header('Location: '. $redirectUri);
}