<?php

defined( 'ABSPATH' ) || exit;

/**
 * 1.- Creación del usuario supervision por una sola vez
 */

function usuariopaypal()
{
	// Creamos el rol shop_supervisor si no existe
	if(get_role("shop_supervisor") == null){
		add_role( 'shop_supervisor', 'Shop Supervisor', get_role( 'shop_manager' )->capabilities);
	}
	// Añade la capacidad ver_paypals al rol shop_supervisor (fuerza siempre)
	$super = get_role('shop_supervisor');
	$super->add_cap('ver_paypals');
	// Crea el usuario supervision si no existe
	if(!username_exists('supervision'))
	{
		$user_id = wp_create_user( 'supervision', 'Supervision.2021*', 'supervision@windowsandoffice.com' );
		$user = new WP_User( $user_id );
		$user->set_role( 'shop_supervisor' );
	}
	// Fuerza el rol shop_supervisor par el usuario supervision
	$super = get_user_by('login','supervision');
	$super->remove_role("shop_manager");
	$super->add_role("shop_supervisor");
	// Crea el usuario despacho si no existe
	if(!username_exists('despacho'))
	{
		$user_id = wp_create_user( 'despacho', 'Despacho.2021*', 'despacho@windowsandoffice.com' );
		$user = new WP_User( $user_id );
		$user->set_role( 'shop_manager' );
	}
	// Fuerza el rol shop_manager para el usuario despacho
	$despacho = get_user_by('login','despacho');
	$despacho->remove_role("shop_supervisor");
	$despacho->add_role("shop_manager");
	// Quita la capacidad ver_paypals al rol shop_manager
	$despachoRol = get_role('shop_manager');
	$despachoRol->remove_cap('ver_paypals');

	$user = wp_get_current_user();
	$role = $user->roles;

}//fin de funcion usuariopaypal

add_action( 'admin_init', 'usuariopaypal' );

/**
 * 2.- Si tiene privilegio 'ver_paypals' registra un new_post_type
 */

add_action('init', 'register_new_post_type');

function register_new_post_type()
{
	if(current_user_can('ver_paypals')){
		$pplogo="data:image/svg+xml;base64,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";
		$args = array(
			'public' => true,
			'labels' => array(
			'name' => 'Paypals',
			'singular_name' => 'Paypal',
			'all_items' => 'Todos los Paypals',
			'add_new' => 'Agregar nuevo Paypal',
			'add_new_item' => 'Agregar nuevo Paypal',
			'edit_item' => 'Editar Paypal',
			'new_item' => 'Nuevo Paypal',
			'view_item' => 'Ver Paypal',
			'search_items' => 'Buscar Paypals',
			'not_found' => 'No se han encontrado Paypals',
			'not_found_in_trash' => 'No se han encontrado Paypals en la Papelera'
			),
		 'supports' => array( 'title' ),
		 'menu_icon' => $pplogo
		);
		register_post_type('Paypals', $args);
	}//fin de si es admin
}//fin de funcion
	
/**
 * 2.1.- Llama funcion para agregar los los meta boxes para el Custom Post Type Paypal
 * https://developer.wordpress.org/reference/functions/add_meta_box/
 */

function paypal_register_meta_boxes()
{
	add_meta_box('Paypal-Parameters', 'Parametros', 'paypal_output_meta_box', 'Paypals', 'normal', 'high');
}

/**
 * 2.2 Inputs para cada nuevo campo personalizado (dentro del meta box)
 */
function paypal_output_meta_box($post)
{
	// Los campos se graban en la base de datos con un subrayado bajo como prefijo
	// WP indica así por defecto que son campos metas
	//cambiar aqui
	$options = get_option( '_paypal_options' );//el sitio actual siempre es servidor
	$liveAPIUsername = get_post_meta($post->ID, '_liveAPIUsername', true);
	$liveAPIPassword = get_post_meta($post->ID, '_liveAPIPassword', true);
	$liveAPISignature = get_post_meta($post->ID, '_liveAPISignature', true);

	$liveEmailAddress = get_post_meta($post->ID, '_liveEmailAddress', true);
	$liveMerchantId = get_post_meta($post->ID, '_liveMerchantId', true);
	$liveClientId = get_post_meta($post->ID, '_liveClientId', true);
	$liveSecretKey = get_post_meta($post->ID, '_liveSecretKey', true);

	$ppcategory = get_post_meta($post->ID, '_ppcategory', true);
	$ppdaysales = get_post_meta($post->ID, '_ppdaysales', true);
	$pplifetimesales = get_post_meta($post->ID, '_pplifetimesales', true);
	$ppstatus = get_post_meta($post->ID, '_ppstatus', true);
	$forsites = get_post_meta($post->ID, '_forsites', true);
	$forsite = get_post_meta($post->ID, '_forsite', true);

	$ppgracedate = get_post_meta($post->ID, '_ppgracedate', true);

	//$ppactivesales = get_post_meta($post->ID, '_ppactivesales', true);
	//$ppmonthsales = get_post_meta($post->ID, '_ppmonthsales', true);
	$ppmonthlimit = get_post_meta($post->ID, '_ppmonthlimit', true);
	echo "<style>
		.cpt_1 {
			float:left;
			width:160px;
			//border:solid 1px red;
		}
		.cpt_2 {
			width:500px;
			//border:solid 1px blue;
		}
		.cpt_2 input, select {
			width:300px;
		}
	</style>";
	echo "
	<div style='float:left;width:48%;padding-bottom:150px;'>";
	if ($options['checkout']=='S'){;
		wp_nonce_field( 'graba_paypal', 'paypal_nonce' );
		echo " 
		<div style='border:none 1px gray;border-radius:5px;'>
			<div class='cpt_1'><label for='liveAPIUsername'>" . __('Live API Username: ', 'pluginwao') . "</label></div>
			<div class='cpt_2'><input type='text' name='liveAPIUsername' id='liveAPIUsername' value='" . esc_attr($liveAPIUsername) . "'></div>
			<br>
			<div class='cpt_1'><label for='liveAPIPassword'>" . __('Live API Password: ', 'pluginwao') . "</label></div>
			<div class='cpt_2'><input type='text' name='liveAPIPassword' id='liveAPIPassword' value='" . esc_attr($liveAPIPassword) . "'></div>
			<br>
			<div class='cpt_1'><label for='liveAPISignature'>" . __('Live API Signature: ', 'pluginwao') . "</label></div>
			<div class='cpt_2'><input type='text' name='liveAPISignature' id='liveAPISignature' value='" . esc_attr($liveAPISignature) . "'></div>
		</div>";
	}
	
	echo "
		<div style='padding-bottom:20px;margin-top:18px;'>
			<div class='cpt_1'><label for='ppcategory' style='padding-right:67px;'>" . __('Category: ', 'pluginwao') . "</label></div>
			";	
			$checked = $ppcategory=="r"||empty($category)?"checked":"";
			echo '
			<div class="cpt_2">
				<span style="border-radius:5px;background-color:Pink;border:solid 1px Crimson;padding:5px;margin-right:5px;"><input style="width:14px" type="radio" id="ppcategory" name="ppcategory" value="r" '.$checked.'><label for="ppcategory" >Red</label></span>'; 
				$checked = $ppcategory=="y"?"checked":"";
				echo '	<span style="border-radius:5px;background-color:LemonChiffon;border:solid 1px #FFA500;padding:5px;margin-right:5px;"><input style="width:14px" type="radio" id="ppcategory" name="ppcategory" value="y" '.$checked.'><label for="ppcategory" >Yellow</label></span>'; 
				$checked = $ppcategory=="g"?"checked":"";
				echo '	<span style="border-radius:5px;background-color:#E9F5F0;border:solid 1px YellowGreen;padding:5px;margin-right:5px;"><input style="width:14px" type="radio" id="ppcategory" name="ppcategory" value="g" '.$checked.'><label for="ppcategory" >Green</label></span>
			</div>
		</div>';
	if(is_multisite()){
		$sites = get_sites(array('archived'=>0));
		echo('<div class="cpt_1"><label for="forsite">' . __('Site: ', 'pluginwao') . '</label></div>');
		$multiple = $options['multiple_countries']=='M'?"multiple":"";
		$m=$options['multiple_countries']=='M'?true:false;
		if(empty($forsite)){ // si forsite esta vacio es porque es la primera actualizacion
			$new_forsite=get_post_meta($post->ID,'_forsites',true);
			update_post_meta($post->ID, '_forsite', $new_forsite[0]);
			$forsite = get_post_meta($post->ID, '_forsite', true);
		}else{

		}
		$names=$m?"name='forsites[]' id='forsites' multiple":"name='forsite' id='forsite' >";
		echo '
			<div class="cpt_2">
				<select '.$names.'>
					<option value="0" >Sin sitio</option>';
		foreach ( $sites as $site ) {
			switch_to_blog( $site->blog_id );
			if (!str_contains(strtolower($site->blogname), 'manuals')){
				//descomentar para multiselect
				if($m){
					if($forsites<>FALSE){
						$sel=in_array($site->blog_id,$forsites)?"selected":"";
					}//if forsites false END
				}else{
					$sel=$forsite==$site->blog_id?"selected":"";
				}
				echo "<option value='".$site->blog_id."' ".$sel." >".$site->blogname."</option>";
			}
			restore_current_blog();
		}//fin de foreach
		echo "	</select>
			</div>";	
	}//fin de is_multisite

	echo "</div>";
	echo "<div style='float:right;width:48%;text-align:left;'>";

	if ($options['payments']=='S'){
		echo "<div style='border:solid 1px gray;border-radius:5px;padding:10px'>";

		echo('<label for="liveEmailAddress">' . __('Live Email Address: ', 'pluginwao') . '</label>');
		echo('<input type="text" name="liveEmailAddress" id="liveEmailAddress" style="width:300px;margin-left:18px;" value="' . esc_attr($liveEmailAddress) . '">');
		echo '<i style="color:gray;padding-left:5px;">El email de la cuenta paypal.</i><br><br>';

		echo('<label for="liveMerchantId">' . __('Live Merchant ID: ', 'pluginwao') . '</label>');
		echo('<input type="text" name="liveMerchantId" id="liveMerchantId" style="width:300px;margin-left:26px;" value="' . esc_attr($liveMerchantId) . '">');
		echo '<i style="color:gray;padding-left:5px;">En cuenta paypal navegar a: account->settings/businnes information.</i><br><br>';

		echo('<label for="liveClientId">' . __('Live Client ID: ', 'pluginwao') . '</label>');
		echo('<input type="text" name="liveClientId" id="liveClientId" style="width:300px;margin-left:48px;" value="' . esc_attr($liveClientId) . '">');
		echo '<i style="color:gray;padding-left:5px;">Para obtener (Client ID) y (Secret Key) en la cuenta Paypal, abrir <a href="https://developer.paypal.com" target="_blank">https://developer.paypal.com</a> y clic en "Log into Dashboard".</i><br><br>';

		echo('<label for="liveSecretKey">' . __('Live Secret Key: ', 'pluginwao') . '</label>');
		echo('<input type="text" name="liveSecretKey" id="liveSecretKey" style="width:300px;margin-left:40px;" value="' . esc_attr($liveSecretKey) . '"><br><br>');

		echo "</div><br><br>";
	}
	echo '
		<div class="cpt_1"><label for="ppmonthlimit">' . __('Monthly Limit: ', 'pluginwao') . '</label></div>
		<div class="cpt_2"><input type="text" name="ppmonthlimit" id="ppmonthlimit" value="' . esc_attr($ppmonthlimit) . '"></div><br>
		<div class="cpt_1"><label for="ppstatus">' . __('Paypal Status: ', 'pluginwao') . '</label></div>
		<div class="cpt_2">
			<select name="ppstatus" id="ppstatus"  >';
				$selected=$ppstatus=="Activo"?'selected':'';
				if($selected=='selected'){
					echo('<option value="Activo" '.$selected.'>Activo</option>');
				}else{
					$selected=$ppstatus=="Reserva"?'selected':'';
					echo('<option value="Reserva" '.$selected.'>Reserva</option>');
					$selected=$ppstatus=="En_revision"?'selected':'';
					echo('<option value="En_revision" '.$selected.'>En revision</option>');
				}
		echo '</select>
		</div><br>
		<div class="cpt_1"><label for="ppgracedate">' . __('Date for change: ', 'pluginwao') . '</label></div>
		<div class="cpt_2"><input type="date" name="ppgracedate" id="ppgracedate" value="' . esc_attr($ppgracedate) . '"></div><br>
	</div>
	<div style="clear:both"></div>';

}
add_action('add_meta_boxes', 'paypal_register_meta_boxes');

/**
 * 2.3 Graba los campos del formulario del meta box
 * @param int $post_id Post ID
 */

function alert_validation(){
	$message = "<p>Paypal fields can't to be empty</p>";	
	echo "<div class='notice notice-alert id-dismissible'>";	
	echo $message;	
	echo "</div>";	
	
}

function paypal_save_meta_boxes($post_id)
{

	// Comprueba que el nonce es correcto para evitar ataques CSRF
	if ( !isset($_POST['paypal_nonce']) || ! wp_verify_nonce( $_POST['paypal_nonce'], 'graba_paypal') ) {
		if ( ! wp_verify_nonce( $_POST[ '_inline_edit' ], 'inlineeditnonce' ) ) {
			return;
		}else{
			$ppstatus = sanitize_text_field($_POST['ppstatus']);
			update_post_meta($post_id, '_ppstatus', $ppstatus);
			return;
		}
		return $post_id;
	}
	// Comprueba que el tipo de post es paypal
	if ('paypals' != $_POST['post_type']) {
		return $post_id;
	}

	// Comprueba que el usuario actual tiene permiso para editar esto
	if (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}

	// Ahora puedes grabar los datos con tranquilidad
	// Observa que cuando vienen del formulario los campos meta no vienen con el prefijo subrayado bajo pero cuando los grabas en el post hay que poner el prefijo, igual que cuando los leías del post
	// cambiar aqui
	if(!empty($_POST['liveAPIUsername'])){
		$liveAPIUsername = sanitize_text_field($_POST['liveAPIUsername']);
	}
	if(!empty($_POST['liveAPIPassword'])){
		$liveAPIPassword = sanitize_text_field($_POST['liveAPIPassword']);
	}
	if(!empty($_POST['liveAPISignature'])){
		$liveAPISignature = sanitize_text_field($_POST['liveAPISignature']);
	}
//	$liveEmailAddress = sanitize_text_field($_POST['liveEmailAddress']);

	if (get_paypal_option('checkout')=='S'&&(empty($liveAPIUsername)||empty($liveAPIPassword)||empty($liveAPISignature))){
		add_action( 'admin_notices', 'alert_validation');
		return;
	}

	if(!empty($liveAPIUsername)){
		update_post_meta($post_id, '_liveAPIUsername', $liveAPIUsername);
	}
	if(!empty($liveAPIPassword)){
		update_post_meta($post_id, '_liveAPIPassword', $liveAPIPassword);
	}
	if(!empty($liveAPISignature)){
		update_post_meta($post_id, '_liveAPISignature', $liveAPISignature);
	}

	if(!empty($_POST['liveEmailAddress'])){
		$liveEmailAddress = sanitize_text_field($_POST['liveEmailAddress']);
	}
	if(!empty($_POST['liveMerchantId'])){
		$liveMerchantId = sanitize_text_field($_POST['liveMerchantId']);
	}
	if(!empty($_POST['liveClientId'])){
		$liveClientId = sanitize_text_field($_POST['liveClientId']);
	}
	if(!empty($_POST['liveSecretKey'])){
		$liveSecretKey = sanitize_text_field($_POST['liveSecretKey']);
	}

	if (get_paypal_option('payments')=='S'&&(empty($liveEmailAddress)||empty($liveMerchantId)||empty($liveClientId)||empty($liveSecretKey))){
		add_action( 'admin_notices', 'alert_validation');
		return;
	}

	if(!empty($liveEmailAddress)){
		update_post_meta($post_id, '_liveEmailAddress', $liveEmailAddress);
	}
	if(!empty($liveMerchantId)){
		update_post_meta($post_id, '_liveMerchantId', $liveMerchantId);
	}
	if(!empty($liveClientId)){
		update_post_meta($post_id, '_liveClientId', $liveClientId);
	}
	if(!empty($liveSecretKey)){
		update_post_meta($post_id, '_liveSecretKey', $liveSecretKey);
	}

	if(!empty($_POST['ppcategory'])){
		$ppcategory = sanitize_text_field($_POST['ppcategory']);
		update_post_meta($post_id, '_ppcategory', $ppcategory);
	}

	if(!empty($_REQUEST['forsite'])){
		$forsite = $_REQUEST['forsite'];
	}

	$forsite = !empty($_POST['forsite'])?$_POST['forsite']:0;
	$forsites = !empty($_POST['forsites'])?$_POST['forsites']:NULL;

	//$ppoptions = get_paypal_options();//obtiene del servidor paypal
	$ppoptions = get_option('_paypal_options');//obtiene del sitio actual ESTAMOS EN EL SERVIDOR

	if(is_multisite()){
		if(!is_null($forsite)){
			update_post_meta($post_id, '_forsite', $forsite); //no tocar
			update_post_meta($post_id, '_forsites', array('0'=>$forsite)); //no tocar
		}
		if(!is_null($forsites)){
			update_post_meta($post_id, '_forsites', $forsites);
			update_post_meta($post_id, '_forsite', $forsites);
		}
	}
	if(!empty($_POST['ppactivesales'])){
		$ppactivesales = sanitize_text_field($_POST['ppactivesales']);
		update_post_meta($post_id, '_ppactivesales', $ppactivesales);
	} 
	if(!empty($_POST['ppdaysales'])){
		$ppdaysales = sanitize_text_field($_POST['ppdaysales']);
		update_post_meta($post_id, '_ppdaysales', $ppdaysales);
	} 
	if(!empty($_POST['ppmonthlimit'])){
		$ppmonthlimit = sanitize_text_field($_POST['ppmonthlimit']);
		update_post_meta($post_id, '_ppmonthlimit', $ppmonthlimit);
	}
	if(!empty($_POST['pplifetimesales'])){
		$pplifetimesalessales = sanitize_text_field($_POST['pplifetimesales']);
		update_post_meta($post_id, '_pplifetimesales', $pplifetimesalessales);
	}
	if(!empty($_POST['ppstatus'])){
		$ppstatus = sanitize_text_field($_POST['ppstatus']);
		update_post_meta($post_id, '_ppstatus', $ppstatus);
	}
	if(!empty($_POST['ppgracedate'])){
		$ppgracedate = sanitize_text_field($_POST['ppgracedate']);
		update_post_meta($post_id, '_ppgracedate', $ppgracedate);
	}

	return true;
}

add_action('save_post', 'paypal_save_meta_boxes');

/**
 * 2.4 Aumentar columnas personalizadas en la tabla
 */

function personalizar_columnas1( $columns ) 
{
	if(is_multisite()){
		$option=get_paypal_option('multiple_countries');
		$country = $option=='M'?'countries':'country';

		$columns1 = array(
		  'username' => __( 'User Name', 'paypals' ),
		  $country => __( ucfirst($country), 'paypals' ),
		  'ppactivesales' => __( 'Active Sales', 'paypals' ),
		  'ppdaysales' => __( 'Today Sales', 'paypals' ),
		  'ppmonthsales' => __( 'Monthly Sales', 'paypals' ),
		  'pplifetimesales' => __( 'All Sales', 'paypals' ),
		  'ppmonthlimit' => __( 'Limit', 'paypals' ),
		  'ppstatus' => __( 'Paypal Status', 'paypals' )
		);
		if($option=='M'){
			$columns1['ppactiveinsites']= __( 'Active in sites', 'paypals' );
		};

	}else{
		$columns1 = array(
		  'username' => __( 'User Name', 'paypals' ),
		  'ppactivesales' => __( 'Active Sales', 'paypals' ),
		  'ppdaysales' => __( 'Today Sales', 'paypals' ),
		  'ppmonthsales' => __( 'Monthly Sales', 'paypals' ),
		  'pplifetimesales' => __( 'All Sales', 'paypals' ),
		  'ppmonthlimit' => __( 'Limit', 'paypals' ),
		  'ppstatus' => __( 'Paypal Status', 'paypals' ),
		);
	}

	$columns=array_merge($columns, $columns1);
  return $columns;
}//function personalizar columna END

add_filter( 'manage_paypals_posts_columns', 'personalizar_columnas1');

/**
 * 2.5 Definir el contenido a mostrar en las columnas
 */

function personalizar_contenido_columna( $column, $post_id ) 
{
  $info = get_post_meta($post_id);
  $info1 = get_post($post_id);
  switch ($column)
  {
	case 'username':
		$color=empty($info['_ppcategory'][0])?paypal_color_span('default'):paypal_color_span($info['_ppcategory'][0]);
		//echo $color.$info[$GLOBALS['_user_email_name']][0];
		echo $color.$info['_liveAPIUsername'][0];
	  break;
	case 'countries':
		//$blog_id = get_current_blog_id();
		$sites=get_post_meta($post_id,'_forsites');
		$salida="";
		if(!empty($sites[0])){
			foreach($sites[0] as $site){
				switch_to_blog( $site);
				$optblogname = get_option( 'blogname' );
				$salida.="<span style='background-color:azure;border:solid gray 1px;border-radius:3px;font-size:10px;margin-left:3px;padding:0px 3px 0px 3px'>".$optblogname."</span>";
				restore_current_blog();
			}
		}//if sites false END
		echo $salida;
	  break;
	case 'country':
		//$blog_id = get_current_blog_id();
		$site=get_post_meta($post_id,'_forsite',true);
		$salida="";
		if(!empty($site)){
			switch_to_blog( $site);
				$optblogname = get_option( 'blogname' );
				$link = get_option( 'home' )."/wp-admin";
				//$salida.="<span style='background-color:azure;border:solid gray 1px;border-radius:3px;font-size:10px;margin-left:3px;padding:0px 3px 0px 3px'>".$optblogname."</span>";
				$salida.="<a href='".$link."'>".$optblogname."</a>";
			restore_current_blog();
		}else{
			//$salida.="<span style='background-color:azure;border:solid gray 1px;border-radius:3px;font-size:10px;margin-left:3px;padding:0px 3px 0px 3px'>Sin sitio</span>";
			$salida.="Sin sitio";
		}//if sites false END
		echo $salida;
	  break;
	case 'ppactiveinsites':
		//$blog_id = get_current_blog_id();
		$sites=get_post_meta($post_id,'_ppactiveinsites');
		$salida="";
		if(!empty($sites[0])){
			foreach($sites[0] as $site){
				switch_to_blog( $site);
				$optblogname = get_option( 'blogname' );
				$salida.="<span style='background-color:PaleGreen;border:solid gray 1px;border-radius:3px;font-size:10px;margin-left:3px;padding:0px 3px 0px 3px'>".$optblogname."</span>";
				restore_current_blog();
			}
		}//if sites false END
		echo $salida; 
	  break;
	case 'ppactivesales':
		if(!empty($info['_ppactivesales'][0])){
			echo $info['_ppactivesales'][0];
		}
	  break;
	case 'ppdaysales':
		if(!empty($info['_ppdaysales'][0])){
			echo $info['_ppdaysales'][0];
		}
	  break;
	case 'ppmonthsales':
		if(!empty($info['_ppmonthsales'][0])){
			echo $info['_ppmonthsales'][0];
		}
	  break;
	case 'pplifetimesales':
		if(!empty($info['_pplifetimesales'][0])){
			echo $info['_pplifetimesales'][0];
		}
	  break;
	case 'ppmonthlimit':
		if(!empty($info['_ppmonthlimit'][0])){
			echo $info['_ppmonthlimit'][0];
		}
			  break;
	case 'ppstatus':
		if(!empty($info['_ppstatus'][0])){
			echo $info['_ppstatus'][0];
		}
	  break;
  }
}//function personalizar contenidos END

add_action( 'manage_paypals_posts_custom_column', 'personalizar_contenido_columna', 10, 2);

/**
 * 2.6 Columnas ordenables
 * Tres funciones: keys_sortable_columns, keys_load, my_sort_keys
 */
// Nombra la columna que sera ordenable
function keys_sortable_columns( $columns ) 
{
	$columns['ppstatus'] = 'Paypal Status';
	$multicountries=get_paypal_option('multiple_countries');
	if($multicountries=='S'){
		$columns['country'] = 'Paypal Country';
	}
	return $columns;
}//function keys sortable columns END

add_filter( 'manage_edit-paypals_sortable_columns', 'keys_sortable_columns' );

/* Only run our customization on the 'edit.php' page in the admin. */
// En edit.php pone el mecanismo de ordenacion
function keys_load() 
{
 add_filter( 'request', 'my_sort_keys');
}//function keys load END 

/* Sorts  paypals. */
function my_sort_keys( $vars ) 
{
	/* Check if we're viewing the 'paypals' post type. */
	if ( isset( $vars['post_type'] ) && 'paypals' == $vars['post_type'] ) {
		/* Check if 'orderby' is set to 'ppstatus'. */
		if ( isset( $vars['orderby'] ) && 'Paypal Status' == $vars['orderby'] ) {
			/* Merge the query vars with our custom variables. */
			$vars = array_merge(
			$vars,
			array(
				 'meta_key' => '_ppstatus',
				 'orderby' => 'meta_value'
				)
				//meta_value_num
			);
		}

		if ( isset( $vars['orderby'] ) && 'Paypal Country' == $vars['orderby'] ) {
			/* Merge the query vars with our custom variables. */
			$vars = array_merge(
			$vars,
			array(
				 'meta_key' => '_forsite',
				 'orderby' => 'meta_value'
				)
				//meta_value_num
			);
		}

	}
 return $vars; 
}//function my sort keys END		

add_action( 'load-edit.php', 'keys_load');



/**
 * 2.7 Añade metadatos (en inputs) al Quick edit
 * https://rudrastyh.com/wordpress/quick-edit-tutorial.html
 */

function paypals_quick_edit_fields( $column_name, $post_type ) 
{
	switch( $column_name ) {
		case 'inline-edit-status': 
				echo "naranjas!";
			break;
		case 'ppstatus': 
			$ppstatus = get_post_meta($post->ID, '_ppstatus', true);
			?>
				<fieldset class="inline-edit-col-left">
					<div class="inline-edit-col-ps">
						<label>
							<span class="title">Papal Status</span>
							<select name="ppstatus" id="ppstatussel">
								<?php $selected=$ppstatus=='Activo'?'selected':'';?>
								<option id="Activo" value="Activo" <?php echo $selected;?> >Activo</option>
								<?php $selected=$ppstatus=='Reserva'?'selected':'';?>
								<option id="Reserva" value="Reserva" <?php echo $selected;?> >Reserva</option>
								<?php $selected=$ppstatus=='En_revision'?'selected':'';?>
								<option id="En_revision" value="En_revision" <?php echo $selected;?>>En_revision</option>
							</select>
						</label>
					</div>
				</fieldset>
<script>
jQuery( function( $ ){
	const wp_inline_edit_function = inlineEditPost.edit;
	// we overwrite the it with our own
	inlineEditPost.edit = function( post_id ) {
		// let's merge arguments of the original function
		wp_inline_edit_function.apply( this, arguments );
		// get the post ID from the argument
		if ( typeof( post_id ) == 'object' ) { // if it is object, get the ID number
			post_id = parseInt( this.getId( post_id ) );
		}
		// add rows to variables
		const edit_row = $( '#edit-' + post_id )
		const post_row = $( '#post-' + post_id )
		const ppstatus = $( '.column-ppstatus', post_row ).text()
		// populate the inputs with column data
		if(ppstatus!='Activo'){
			$('#ppstatussel').empty()
			.append('<option value="Reserva">Reserva</option>')
			.append('<option value="En_revision">En revision</option>')
			;
		}
		$('div.inline-edit-col-ps select').val(ppstatus).change();
	}
});
</script>
				<?php
			break;
	}
}

//add_action( 'quick_edit_custom_box',  'paypals_quick_edit_fields', 10, 2 );

/**
 * 2.8 Añade un input select por status en la fila de filtros del listado CPT
 */

function ppstatus_filtering($post_type)
{
	if('paypals' !== $post_type){
	  return; //filter your post
	}
	$selected = '';
	$request_attr = 'paypal_status';
	if ( isset($_REQUEST[$request_attr]) ) {
	  $selected = $_REQUEST[$request_attr];
	}
	//get unique values of the meta field to filer by.
	$meta_key = '_ppstatus';
	global $wpdb;
	
	$result = $wpdb->get_results( 
		$wpdb->prepare( "SELECT DISTINCT meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key = '_ppstatus'" 
		) 
	);
   //build a  custom dropdown list of values to filter by
	echo '<select id="paypal_status" name="paypal_status">';
	echo '<option value="-1">' . __( 'Show all status', 'paypals' ) . ' </option>';
	foreach($result as $location){
	  //$select = ($org->ID == $selected) ? ' selected="selected"':'';
	  if ($location->meta_value<>""){
		  $select = ($location->meta_value == $selected) ? ' selected="selected"':'';
		echo '<option value="'.$location->meta_value.'"'.$select.'>' . $location->meta_value . ' </option>';
	  }
	}
	echo '</select>';
  }

add_action('restrict_manage_posts','ppstatus_filtering');

/**
 * 2.9 Añade un input select por country en la fila de filtros del listado CPT
 */
function country_filtering($post_type)
{
	if('paypals' !== $post_type){
	  return; //filter your post
	}
	$selected = '';
	$request_attr = 'paypal_country';
	if ( isset($_REQUEST[$request_attr]) ) {
	  $selected = $_REQUEST[$request_attr];
	}
	//get unique values of the meta field to filer by.
	$meta_key = '_forsite';
	global $wpdb;
	
	$result = $wpdb->get_results( 
		$wpdb->prepare( "SELECT DISTINCT meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key = '_forsite'" 
		) 
	);
   //build a  custom dropdown list of values to filter by
	echo '<select id="paypal_country" name="paypal_country">';
	echo '<option value="-1">' . __( 'Show all sites', 'paypals' ) . ' </option>';
	echo '<option value="0">' . __( 'Show "Sin sitio"', 'paypals' ) . ' </option>';
	foreach($result as $location){
	  //$select = ($org->ID == $selected) ? ' selected="selected"':'';
	  if($location->meta_value<>0){
		  $select = ($location->meta_value == $selected) ? ' selected="selected"':'';
		  switch_to_blog($location->meta_value);
			$nom_sitio=get_option('blogname');
		  restore_current_blog();
		  echo '<option value="'.$location->meta_value.'"'.$select.'>' . $nom_sitio . ' </option>';
	  }
	}
	echo '</select>';
  }
add_action('restrict_manage_posts','country_filtering');

/**
 * 3.0 El mecanismo del filtro (the ‘parse_query’ filter)
 */

function paypals_filter_request_query($query)
{
	//modify the query only if it admin and main query.
	if( (is_admin() AND $query->is_main_query()) ){ 
		$salir=false;
		$salir1=false;
		if( $query->is_main_query() ){ 
		  //return $query;
		}

		//we want to modify the query for the targeted custom post and filter option
		if(!empty($query->query['post_type'])){
			if( !('paypals' === $query->query['post_type'] AND isset($_REQUEST['paypal_status']) ) ){
			//we want to modify the query for the targeted custom post and filter option
		//print_r($query);
				if( !('paypals' === $query->query['post_type'] AND isset($_REQUEST['paypal_country']) ) ){
				  return $query;
				}
			}
		}

		if(!empty($_REQUEST['post-search-input'])){
			if('' === $_REQUEST['post-search-input']){
				set_query_var('post_title', false);
				$salir=true;
			}else{
				//List posts this user is "tagged" in (B).
				$query->set('post_title',$_REQUEST['post-search-input']);
			}
		}

		//for the default value of our filter no modification is required
		$metaquery1=array();
		$metaquery2=array();
		if('-1' === $_REQUEST['paypal_status']){
			set_query_var('_ppstatus', false);
			$salir=true;
		}else{
			//List posts this user is "tagged" in (B).
			$metaquery1=array('key' => '_ppstatus', 'value' => $_REQUEST['paypal_status'],'compare' => '=' );
		}
		//for the default value of our filter no modification is required
		if('-1' == $_REQUEST['paypal_country']){
		  set_query_var('_forsite', false);
			$salir1=true;
		}else{
			//List posts this user is "tagged" in (B).
			$metaquery2=array('key' => '_forsite', 'value' => $_REQUEST['paypal_country'],'compare' => '=' );
		}
		if($salir&&$salir1){
		  return $query;
		}else{
			$metaquerys=array($metaquery1, $metaquery2);
			$query->set('meta_query',$metaquerys);
		}

		return $query;
	}// fin de if is admin
}//fin de function

add_filter( 'parse_query', 'paypals_filter_request_query');

/**
 * 3.1 quitar opciones view, quick edit, y otros de cada fila de los cpt
 */
 
function quita_opciones_view($actions, $post)
{
    if ($post->post_type=='paypals')
    {
        //$actions['duplicate'] = '<a href="#" title="" rel="permalink">Duplicate</a>';
		unset($actions['view']);
		unset($actions['inline hide-if-no-js']); 
	}
	borraantiguospaypals();
	return $actions;
}
add_filter('post_row_actions', 'quita_opciones_view', 10, 2);

function borraantiguospaypals()
{
	$dias=get_paypal_option("diasborrar");
	if($dias<10){$dias=10;}
	if(empty($dias)){ $dias=100;}
	$dias="-".$dias." days";
	$args = array(
		'posts_per_page'   => 500,
		'orderby'          => 'post_modified',
		'order'            => 'DESC',
		'post_type'        => 'paypals',
		'post_status'      => 'publish',
		'meta_query' => array(
			array(
				'key' => '_ppstatus',
				'value' => 'En_revision',
				'compare' => '=',
			)
		),			
		'date_query' => array(
			array(
				//Compara con la fecha de modificación
				'column'  => 'post_modified',
				//Despues => ahora menos 30 días
				'before'   => $dias
			)
		)
	); 
	$paypls = get_posts($args);
	foreach($paypls as $payp){
		wp_delete_post( $payp->ID);
	}
}