<?php
/*
 * FUNCIONES PARA INCLUIR HTML EN EL FOOTER DE LOS EMAILS WOOCOMMERCE 
 * V 1.1 Traduccion al italiano
*/

defined( 'ABSPATH' ) || exit; 

add_action('woocommerce_email_footer', 'agregar_contenido_footer_correos', 10, 1); //Agregar html footer email
add_shortcode('orden','orden'); //Procesar datos de orden a partir de $_GET['order_id']

// Verificar que exista el formulario support
$existing_form = posts_exists('support', 'wpcf7_contact_form');
if (!$existing_form) {
	// El formulario no existe, crearlo
	$form_id=create_contact_form();
	// Crear o actualizar la page
	create_support_page($form_id);
}
// Verificar que exista la pagina Support
$existing_page = posts_exists('Support', 'page', 'todos');
if (!$existing_page) {
	GLOBAL $wpdb;
	if(is_multisite()){
		$pre=get_current_blog_id(); 
		$pre=$pre==1?"":$pre."_";
	}else{
		$pre="";
	}
	$q="SELECT ID FROM wp_".$pre."posts WHERE post_title = 'support' AND post_status = 'publish' AND post_type='wpcf7_contact_form'";
	$support_id=$wpdb->get_var($q);
	// Crear o actualizar la page
	create_support_page($support_id);
}

// Agregar contenido html en el footer de los emails woocommerce. 
// Se genera una url apuntando al formulario /support con el order_id
function agregar_contenido_footer_correos($email) {
	if(isset($email)){
		$order_id = $email->object->get_id();
		//$order_id = 56074;
		//echo '<hr>';
		echo '<div style="background-color:#F5F5F5;border-left:solid 2px gray;margin-left:10px;margin-right:10px;padding:10px;text-decoration:none;"';
		echo '<p>'.__('The company guarantees the functionality of the product you received.','wao-tiendas').'</p>';
		echo '<p>'.__('If you have problems with it, our customer service department will solve any problem until you are completely satisfied.','wao-tiendas').'</p>';
		echo '<p>'.__('Contact us through:','wao-tiendas').'</p>';
		//echo '<p>Número de orden: ' . $order_id . '</p>';
		//$te="https://t.me/59172243224";
		//echo '<a href="'.$te.'"><span style="background-color:#259FDC;border:solid 1px green;color:white;border-radius:10px;padding:5px 20px 5px 20px;"><i class="fa fa-telegram" aria-hidden="true">&nbsp;Telegram</i></span></a>';
		//echo '&nbsp;';
		//$wa="https://wa.me/59172243224";
		//echo '<a href="'.$wa.'"><span style="background-color:#29B75F;border:solid 1px green;color:white;border-radius:10px;padding:5px 20px 5px 20px;"><i class="fa fa-whatsapp" aria-hidden="true">&nbsp;Whatsapp</i></span></a>';
		//echo '&nbsp;';
		$su=get_option('home')."/support?order_id=".$order_id;
		echo '<a href="'.$su.'"><span style="background-color:#6527BE;border:solid 1px green;color:white;border-radius:10px;padding:5px 20px 5px 20px;"><i class="fa fa-comment-o" aria-hidden="true">&nbsp;'.__('Support','wao-tiendas').'</i></span></a>';
	}
}

// Shortcode para procesar el order_id recibido
// Dado el order_id, obtiene el nombre, email y los productos de la orden, los asigna a la variable global $_GET[] para luego 
// mostrarlos en el formulario de contact form 7
function orden(){
	if(isset($_GET['order_id'])){
		//add_action('wp_head', 'email_order_style');
		global $woocommerce;
		$order1 = intval(preg_replace('/[^0-9]+/', '', $_GET['order_id']), 10); 
		$order = wc_get_order($order1);
		$_GET['your-name'] = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
		$_GET['your-email'] = $order->get_billing_email();
		$_GET['order-link'] = get_option("home")."/wp-admin/post.php?post=".$_GET['order_id']."&action=edit";
		

		//$billing_country_code = $order->get_billing_country();
		//$countries = WC()->countries->countries;
		//$billing_country_name = isset($countries[$billing_country_code]) ? $countries[$billing_country_code] : '';
		//echo "País de facturación: " . $billing_country_name;
		//$_GET['pais'] = $billing_country_name;

		// Obtener los productos de la orden
		$p="";
		$products = array();
		$h=1;
		foreach ($order->get_items() as $item_id => $item) {
			$product = $item->get_product();
			$product_name = $product->get_name();
			$product_quantity = $item->get_quantity();
			$p.= '- '.$product_name."  (".$product_quantity.")".PHP_EOL.' ';
			$products[] = array(
				'name' => $product_name,
				'quantity' => $product_quantity
			);
			$h++;
		}
		email_order_style($h);
		$p.="";
		$_GET['your-products'] = $p;
		//$_GET['telefono'] = $order->get_billing_phone();
	}
}
// Estilo para el input text ordenes
function email_order_style($h){
		$h=$h*28;
		echo '<style type="text/css">.productos {
		  background-color:#F8F6F4;
		  margin-left:20px;
		  display: block;
		  width: 100%;
		  height: '.$h.'px;
		  padding: 10px;
		  resize: vertical;
		  border-left:solid 3px gray!important;
		  font-size:12px;
		}</style>';
}

function create_support_page($form_id){
	// Verificar si el post 'source' ya existe
	$existing_post = posts_exists('Support','page');
	if (!$existing_post) {
		// El post no existe, crearlo
		$contenido='[orden][contact-form-7 id="'.$form_id.'" title="Support"]';
		$post_data = array(
			'ID'   => 0,
			'post_title'   => 'Support',
			'post_content' => $contenido,
			'post_status'  => 'publish',
			'post_type'    => 'page',
			'post_author'  => 1
		);
		require_once( ABSPATH . "wp-includes/pluggable.php" );
		// Insertar el formulario y obtener su ID
		$form_id = wp_insert_post($post_data);
		// Agregar meta datos al post
		//add_post_meta($post_id, 'nombre_meta_campo', 'valor_meta_campo');
	}else{
		//Buscar el ID del post para luego actualizar
		GLOBAL $wpdb;
		if(is_multisite()){
			$pre=get_current_blog_id(); 
			$pre=$pre==1?"":$pre."_";
		}else{
			$pre="";
		}
		$q="SELECT ID FROM wp_".$pre."posts WHERE post_title = 'Support' AND post_status = 'publish' AND post_type='page'";
		$support_id=$wpdb->get_var($q);
		// Insertar el post y obtener su ID
		$contenido='[orden][contact-form-7 id="'.$form_id.'" title="Support"]';
		$post_data = array(
			'ID'   => $support_id,
			'post_title'   => 'Support',
			'post_content' => $contenido,
			'post_status'  => 'publish',
			'post_type'    => 'page',
			'post_author'    => 1
		);
		// Insertar el post y obtener su ID
		$post_id = wp_update_post($post_data);
		
	}
	
	//update_option('_depu',$depu);
	
}

function create_contact_form(){
	
	$mailconfig['active']=1;
	$mailconfig['subject']='[_site_title] "[your-subject]"';
	$mailconfig['sender']='[_site_title] &lt;[_site_admin_email]&gt;';
	$mailconfig['recipient']='[_site_admin_email]';
	$mailconfig['body']='From: [your-name] [your-email]
Subject: [your-subject]

Message Body:
[your-message]

Order ID:
[order_id]

Products
[your-products]

Link to order
[order-link]

-- 
This e-mail was sent from a contact form on [_site_title] ([_site_url])';
	$mailconfig['additional_headers']='Reply-To: [your-email]';
	$mailconfig['attachments']="";
	$mailconfig['use_html']=0;
	$mailconfig['exclude_blank']=0;

	$messages=messages1();
	//$messages=explode("\n",messages());
	$config_errors4cuarto['message']='';
	$config_errors4['params']=array();
	$config_errors4['link']='https://contactform7.com/configuration-errors/invalid-mailbox-syntax';
	$config_errors3['code']=102;
	$config_errors3['args']=$config_errors4;
	$config_errors2[0]=$config_errors3;
	$config_errors['mail.sender']=$config_errors2;

	$configerrors="a:1:{s:11:'mail.sender';a:1:{i:0;a:2:{s:4:'code';i:102;s:4:'args';a:3:{s:7:'message';s:0:'';s:6:'params';a:0:{}s:4:'link';s:68:'https://contactform7.com/configuration-errors/invalid-mailbox-syntax';}}}}";

	$form_data = array(
		'ID'   => 0,
		'post_title'   => 'support',
		'post_content' => post_content(),
		'post_status'  => 'publish',
		'post_type'    => 'wpcf7_contact_form',
		'post_author'  => 1
	);

	require_once( ABSPATH . "wp-includes/pluggable.php" );

	// Insertar el formulario y obtener su ID
    $form_id = wp_insert_post($form_data);

	add_post_meta($form_id, '_form', form());
	add_post_meta($form_id, '_mail', $mailconfig);
	$mailconfig['active']=0;
	add_post_meta($form_id, '_mail_2', $mailconfig);
	add_post_meta($form_id, '_locale', 'en_US');
	add_post_meta($form_id, '_messages', messages1());
	add_post_meta($form_id, '_config_errors', $config_errors);
	return $form_id;
}

function posts_exists($title, $type, $status='publish'){
	GLOBAL $wpdb;
	if(is_multisite()){
		$pre=get_current_blog_id(); 
		$pre=$pre==1?"":$pre."_";
	}else{
		$pre="";
	}
	$stat=$status=='todos'?" ":" AND post_status = '".$status."' ";
	$q="SELECT ID FROM wp_".$pre."posts WHERE post_title = '".$title."' ".$stat."AND post_type='".$type."'";
	$post_id=$wpdb->get_var($q);
	return empty($post_id)?false:true;
}

function post_content(){
	$mesbody=messagebody();
	$retorno= form();
	$retorno.='	
1
[_site_title] "[your-subject]"
[_site_title] &gt;[_site_admin_email]&lt;
[_site_admin_email]
';
	$retorno.=$mesbody;
	$retorno.='
Reply-To: [your-email]




[_site_title] "[your-subject]"
[_site_title] &gt;[_site_admin_email]&lt;
[_site_admin_email]
';
	$retorno.=$mesbody;
	$retorno.='
Reply-To: [your-email]



';
	$retorno.=messages();
	return $retorno;
}

function form(){
	return '<label> Your name
    [text* your-name default:get param "your-name"] </label>

<label> Your email
    [email* your-email default:get param "your-email"] </label>

<label> Telephone number * (for contact you)
    [phonetext* your-phone numberonly]
 </label>

<label> Your order number
    [text order_id readonly default:get param "order_id"]</label>

<label> Your products
    [textarea your-products readonly class:productos default:get param "your-products"]</label>

<label> Subject
    [text* your-subject default:"I have a problem that requires your attention."] </label>

<label> Your message (optional)
    [textarea your-message placeholder "Write here your text ..."] </label>
    [hidden order-link  default:get param "order-link"]
[submit "Submit"]';
}

function messagebody(){
	return 'From: [your-name] [your-email]
Subject: [your-subject]

Message Body:
[your-message]

Order ID:
[order_id]

Products
[your-products]

Link to order
[order-link]

-- 
This e-mail was sent from a contact form on [_site_title] ([_site_url])';
}

function messages(){
	return 'Thank you for your message. It has been sent.
There was an error trying to send your message. Please try again later.
One or more fields have an error. Please check and try again.
There was an error trying to send your message. Please try again later.
You must accept the terms and conditions before sending your message.
Please fill out this field.
This field has a too long input.
This field has a too short input.
There was an unknown error uploading the file.
You are not allowed to upload files of this type.
The uploaded file is too large.
There was an error uploading the file.
Please enter a date in YYYY-MM-DD format.
This field has a too early date.
This field has a too late date.
Please enter a number.
This field has a too small number.
This field has a too large number.
The answer to the quiz is incorrect.
Please enter an email address.
Please enter a URL.
Please enter a telephone Number.';
}

function messages1(){
	return array('Thank you for your message. It has been sent.',
'There was an error trying to send your message. Please try again later.',
'One or more fields have an error. Please check and try again.',
'There was an error trying to send your message. Please try again later.',
'You must accept the terms and conditions before sending your message.',
'Please fill out this field.',
'This field has a too long input.',
'This field has a too short input.',
'There was an unknown error uploading the file.',
'You are not allowed to upload files of this type.',
'The uploaded file is too large.',
'There was an error uploading the file.',
'Please enter a date in YYYY-MM-DD format.',
'This field has a too early date.',
'This field has a too late date.',
'Please enter a number.',
'This field has a too small number.',
'This field has a too large number.',
'The answer to the quiz is incorrect.',
'Please enter an email address.',
'Please enter a URL.',
'Please enter a Telephone number.');
}

function messages2(){
	return 'a:12:{s:12:"mail_sent_ok";s:45:"Thank you for your message. It has been sent.";s:12:"mail_sent_ng";s:71:"There was an error trying to send your message. Please try again later.";s:16:"validation_error";s:61:"One or more fields have an error. Please check and try again.";s:4:"spam";s:71:"There was an error trying to send your message. Please try again later.";s:12:"accept_terms";s:69:"You must accept the terms and conditions before sending your message.";s:16:"invalid_required";s:27:"Please fill out this field.";s:16:"invalid_too_long";s:32:"This field has a too long input.";s:17:"invalid_too_short";s:33:"This field has a too short input.";s:13:"upload_failed";s:46:"There was an unknown error uploading the file.";s:24:"upload_file_type_invalid";s:49:"You are not allowed to upload files of this type.";s:21:"upload_file_too_large";s:31:"The uploaded file is too large.";s:23:"upload_failed_php_error";s:38:"There was an error uploading the file.";}';
}

function emailconfig(){
return '
From: [your-name] [your-email]
Subject: [your-subject]

Message Body:
[your-message]

Order ID:
[order_id]

Products
[your-products]

Link to order
[order-link]

-- 
This e-mail was sent from a contact form on [_site_title] ([_site_url])';
}

// Es necesario instalar el complemento Country & Phone Field Contact Form 7 para la bandera al lado del campo telefono
// Crear una page con dos shortcodes: [orden] y a continuacion el shortcode del formulario