<?php
// Agregar un menú en la sección de ajustes
defined( 'ABSPATH' ) || exit;


function my_custom_admin_menu() {
    add_menu_page(
        'Configuracion WAO Tiendas',
        'WAO Tiendas',
        'manage_options',
        'my_custom_settings',
        'my_custom_settings_page',
		'dashicons-admin-settings',
		11
    );
}
add_action('admin_menu', 'my_custom_admin_menu');

// Crear la página del menú y las pestañas
function my_custom_settings_page() {
	$_GET['tab'] = isset( $_GET['tab'] ) ? $_GET['tab'] : 'tab1';
    ?>
    <div class="wrap">
        <h2>Configuracion para WAO Tiendas</h2>

        <h2 class="nav-tab-wrapper">
            <a href="?page=my_custom_settings&tab=tab1" class="nav-tab <?php echo isset($_GET['tab']) && $_GET['tab'] == 'tab1' ? 'nav-tab-active' : ''; ?>">Parametros factura</a>
            <a href="?page=my_custom_settings&tab=tab2" class="nav-tab <?php echo isset($_GET['tab']) && $_GET['tab'] == 'tab2' ? 'nav-tab-active' : ''; ?>">Mailtrain Tracking</a>
            <a href="?page=my_custom_settings&tab=tab3" class="nav-tab <?php echo isset($_GET['tab']) && $_GET['tab'] == 'tab3' ? 'nav-tab-active' : ''; ?>">Shopper Approved</a>
        </h2>

        <form method="post" action="options.php">
            <?php
            if (isset($_GET['tab']) && $_GET['tab'] == 'tab1') {
                // Pestaña 1: Campos para _invoices_options
                settings_fields('_invoices_options');
                do_settings_sections('my_custom_settings_tab1');
				?>
				<hr>
				<p>ADICIONALMENTE ESTAN DISPONIBLES LOS SIGUIENTES SHORTCODES:</p>
				<p>-   <b>[nombreshop]</b> (El nombre de la tienda configurado en woocommerce)</p>
				<p>-   <b>[urltienda]</b> (La URL de esta tienda )(**)</p>
				<p>ACLARACIONES:</p>
				<p>(*)   <b>[correo]</b> (El shortcode correo acepta el parmetro eslink='s' para devolver un enlace caliente)</p>
				<p>(**)   <b>[urltienda]</b> (El shortcode urltienda acepta los parmetros eslink='s' para enlace caliente y prtcl='n' para eliminar https:// o http:// del enlace)</p>
				<?php
            } elseif (isset($_GET['tab']) && $_GET['tab'] == 'tab2') {
                // Pestaña 2: Campos para _mtt_options
                settings_fields('_mtt_options');
                do_settings_sections('my_custom_settings_tab2');
            } elseif (isset($_GET['tab']) && $_GET['tab'] == 'tab3') {
                // Pestaña 3: Campos para woocommerce_shopper_approved
                settings_fields('woocommerce_shopper_approved');
                settings_fields('woocommerce_shopper_approved_url');
                do_settings_sections('my_custom_settings_tab3');
            }

            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Funciones de registro de opciones y campos

function my_register_settings() {
    // Pestaña 1: Campos para _invoices_options
    register_setting('_invoices_options', '_invoices_options');

    add_settings_section('my_custom_settings_tab1', 'Informacion de la tienda y activacion de shortcodes', 'my_section_callback', 'my_custom_settings_tab1');

	add_settings_field( 'invoices_setting_ustidnr', 'USt-IdNr', 'invoices_setting_ustidnr', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_correo_factura', 'Corréo Factura', 'invoices_setting_correo_factura', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_direccion_factura', 'Dirección Factura', 'invoices_setting_direccion_factura', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_direccion2_factura', 'Dirección Factura 2', 'invoices_setting_direccion2_factura', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_mspartner', 'Microsoft Partner Number', 'invoices_setting_mspartner', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_telefono', 'Teléfono', 'invoices_setting_telefono', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_hra', 'HRA', 'invoices_setting_hra', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_propietario', 'Propietario tienda', 'invoices_setting_propietario', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_vertrag', 'Raiz Vertrag', 'invoices_setting_vertrag', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_lizenzgeber', 'Raiz Lizenzgeber', 'invoices_setting_lizenzgeber', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_mostrar2factura', 'Mostrar la hoja 2 factura (S/N)', 'invoices_setting_mostrar2factura', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_genverliz', 'Generar Vertrag y Lizenzgeber? (S/N)', 'invoices_setting_genverliz', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );
	add_settings_field( 'invoices_setting_combos', 'Combos (COMBO#SKU|ID*ID)', 'invoices_setting_combos', 'my_custom_settings_tab1', 'my_custom_settings_tab1' );

    /*for ($i = 1; $i <= 10; $i++) {
        add_settings_field("field_{$i}", "Campo {$i}", 'my_text_field_callback', 'my_custom_settings_tab1', 'my_custom_settings_tab1', array('field' => "field_{$i}"));
    }*/

    // Pestaña 2: Campos para _mtt_options
    register_setting('_mtt_options', '_mtt_options');

    add_settings_section('my_custom_settings_tab2', 'Configuraciones de seguimiento de campaña Mailtrain', 'my_section_callback', 'my_custom_settings_tab2');

	add_settings_field( 'invoices_setting_mailtraintracking', 'Activar Mailtrain Tracking?','invoices_setting_mailtraintracking', 'my_custom_settings_tab2', 'my_custom_settings_tab2' );

    /*for ($i = 1; $i <= 2; $i++) {
        add_settings_field("field_{$i}", "Campo {$i}", 'my_text_field_callback', 'my_custom_settings_tab2', 'my_custom_settings_tab2', array('field' => "field_{$i}"));
    }*/

    // Pestaña 3: Campos para woocommerce_shopper_approved
    register_setting('woocommerce_shopper_approved_url', 'woocommerce_shopper_approved_url','woocommerce_shopper_approved_sino');
    register_setting('woocommerce_shopper_approved', 'woocommerce_shopper_approved');

    add_settings_section('my_custom_settings_tab3', 'Configuracion para insertar invitacion de shopper approved', 'my_section_callback', 'my_custom_settings_tab3');

	add_settings_field( 'woocommerce_shopper_approved_url', 'URL base de Shopper Approved','woocommerce_shopper_approved_url', 'my_custom_settings_tab3', 'my_custom_settings_tab3' );
	add_settings_field( 'woocommerce_shopper_approved', 'Activar envio de invitacion','woocommerce_shopper_approved', 'my_custom_settings_tab3', 'my_custom_settings_tab3' );
    /*for ($i = 1; $i <= 2; $i++) {
        add_settings_field("field_{$i}", "Campo {$i}", 'my_text_field_callback', 'my_custom_settings_tab3', 'my_custom_settings_tab3', array('field' => "field_{$i}"));
    }*/
}
add_action('admin_init', 'my_register_settings');

function woocommerce_shopper_approved_sino($input){
    if (isset($_POST['woocommerce_shopper_approved'])) {
        $nuevo_valor = sanitize_text_field($_POST['woocommerce_shopper_approved']);
        update_option('woocommerce_shopper_approved', $nuevo_valor);
    }
	return $input; 
}
// Callbacks para mostrar campos y secciones

function my_section_callback() {
    // Puedes agregar descripciones para las secciones si es necesario
	//echo "esto es una prueba";
}

function my_text_field_callback($args) {
    $field = $args['field'];
    $value = get_option($field);
    ?>
    <input type="text" name="<?php echo $field; ?>" value="<?php echo esc_attr($value); ?>" />
    <?php
}

//////////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]
{
function invoices_setting_ustidnr() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_ustidnr' name='_invoices_options[ustidnr]' type='text' value='".esc_attr( $options['ustidnr'] )."' /> Shortcode:[ustidnr]";
}
function invoices_setting_correo_factura() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_correo_factura' name='_invoices_options[correo_factura]' type='text' value='".esc_attr($options['correo_factura'] )."' /> Shortcode: [correo]";
}
function invoices_setting_direccion_factura() {
  $options = get_option( '_invoices_options' );
  echo "<textarea id='invoices_setting_direccion_factura' name='_invoices_options[direccion_factura]' cols=80>".esc_attr( $options['direccion_factura'] )."</textarea> Shortcode: [direccion]";
}
function invoices_setting_direccion2_factura() {
  $options = get_option( '_invoices_options' );
  echo "<textarea id='invoices_setting_direccion2_factura' name='_invoices_options[direccion2_factura]' type='text' cols=80>".esc_attr( $options['direccion2_factura'] )."</textarea> Shortcode: [direccion2]";
}
function invoices_setting_mspartner() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_mspartner' name='_invoices_options[mspartner]' type='text' value='".esc_attr( $options['mspartner'] )."' /> Shortcode: [mspartner]";
}
function invoices_setting_telefono() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_telefono' name='_invoices_options[telefono]' type='text' value='".esc_attr( $options['telefono'] )."' /> Shortcode: [telefono]";
}
function invoices_setting_vertrag() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_vertrag' name='_invoices_options[vertrag]' type='text' value='".esc_attr( $options['vertrag'] )."' /> Shortcode: [vertrag]";
}
function invoices_setting_lizenzgeber() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_lizenzgeber' name='_invoices_options[lizenzgeber]' type='text' value='".esc_attr( $options['lizenzgeber'] )."' /> Shortcode: [lizenzgeber]";
}
function invoices_setting_hra() {
  $options = get_option( '_invoices_options' );
  //echo "<input id='invoices_setting_hra' name='_invoices_options[hra]' type='text' value='".esc_attr( $options['hra'] )."' /> Shortcode:[hra]";
  echo "<textarea id='invoices_setting_hra' name='_invoices_options[hra]' cols=80>".esc_attr( $options['hra'] )."</textarea> Shortcode: [hra]";
}
function invoices_setting_propietario() {
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_propietario' name='_invoices_options[propietario]' type='text' value='".esc_attr( $options['propietario'] )."' /> Shortcode: [propietario]";
}
function invoices_setting_mostrar2factura() {
  $options = get_option( '_invoices_options' );
  //echo "<input id='invoices_setting_mostrar2factura' name='_invoices_options[mostrar2factura]' type='text' value='".esc_attr( $options['mostrar2factura'] )."' /> ";
  $checked = $options['mostrar2factura']=="S"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mostrar2factura" name="_invoices_options[mostrar2factura]" value="S" '.$checked.'><label for="_invoices_options[mostrar2factura]">Si</label>'; 
  $checked = $options['mostrar2factura']=="N"?"checked":"";
  echo '<input type="radio" id="invoices_setting_mostrar2factura" name="_invoices_options[mostrar2factura]" value="N" '.$checked.'><label for="_invoices_options[mostrar2factura]">No</label>'; 
}
function invoices_setting_genverliz() { // S=genera Vertrag y Lizenzgeber a partir de options; N=toma estos valores de los atributos.
  $options = get_option( '_invoices_options' );
  //echo "<input id='invoices_setting_genverliz' name='_invoices_options[genverliz]' type='text' value='".esc_attr( $options['genverliz'] )."' /> ";
  $checked = $options['genverliz']=="S"?"checked":"";
  echo '<input type="radio" id="invoices_setting_genverliz" name="_invoices_options[genverliz]" value="S" '.$checked.'><label for="invoices_setting_genverliz">Si</label>'; 
  $checked = $options['genverliz']=="N"?"checked":"";
  echo '<input type="radio" id="invoices_setting_genverliz" name="_invoices_options[genverliz]" value="N" '.$checked.'><label for="invoices_setting_genverliz">No</label>'; 
}
function invoices_setting_padrehijo() { // P=incluye paypal-padre.php H=incluye paypa-hijo.php). YA NO SE USA
  $options = get_option( '_invoices_options' );
  echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
  $checked = $options['padrehijo']=="P"?"checked":"";
  echo 'Paypal Checkout:&nbsp;&nbsp;<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="P" '.$checked.'><label for="invoices_setting_padrehijo">Padre</label>&nbsp;&nbsp;&nbsp;'; 
  $checked = $options['padrehijo']=="H"?"checked":"";
  echo '<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="H" '.$checked.'><label for="invoices_setting_padrehijo">Hijo</label>'; 
  $checked = $options['padrehijo']=="Q"?"checked":"";
  echo "</span>&nbsp;&nbsp;";
  echo "<span style='border:solid 1px gray; border-radius:5px;padding:10px;width:300px;'>";
  echo 'Paypal Payments:&nbsp;&nbsp;&nbsp;<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="Q" '.$checked.'><label for="invoices_setting_padrehijo">Padre</label>&nbsp;&nbsp;&nbsp;'; 
  $checked = $options['padrehijo']=="I"?"checked":"";
  echo '<input type="radio" id="invoices_setting_padrehijo" name="_invoices_options[padrehijo]" value="I" '.$checked.'><label for="invoices_setting_padrehijo">Hijo</label>'; 
  echo "</span>";
}
function invoices_setting_mailtraintracking() { // S=incluye columna mailtran en orders N=no lo hace.
  $options = get_option( '_mtt_options' );
  $checked = $options['mailtraintracking']=="S"?"checked":"";
  echo '<input type="radio" id="mtt_setting_mailtraintracking" name="_mtt_options[mailtraintracking]" value="S" '.$checked.'><label for="invoices_setting_mailtraintracking">Si</label>'; 
  $checked = $options['mailtraintracking']=="N"?"checked":"";
  echo '<input type="radio" id="mtt_setting_mailtraintracking" name="_mtt_options[mailtraintracking]" value="N" '.$checked.'><label for="invoices_setting_mailtraintracking">No</label>'; 
}
function invoices_setting_combos() { // Combos (COMBO#SKU|ID*ID)
  $options = get_option( '_invoices_options' );
  echo "<input id='invoices_setting_combos' name='_invoices_options[combos]' type='text' value='".esc_attr( $options['combos'] )."' /> ";
}
function woocommerce_shopper_approved_url() {
  $option = get_option( 'woocommerce_shopper_approved_url' );
  echo "<input style='width:600px;' id='woocommerce_shopper_approved_url' name='woocommerce_shopper_approved_url' type='text' value='".esc_attr($option)."' /> ";
  echo "<div style='font-size:12px;color:gray;'>Example: https://www.shopperapproved.com/surveys/full.php?id=<b style='color:black;'>39036</b>&code=<b style='color:black;'>5e27yQdW</b>&products[]= </div>";
}
function woocommerce_shopper_approved() { // S=genera Vertrag y Lizenzgeber a partir de options; N=toma estos valores de los atributos.
  $option = get_option( 'woocommerce_shopper_approved' );
  $checked = $option=="yes"?"checked":"";
  echo '<input type="radio" id="woocommerce_shopper_approved" name="woocommerce_shopper_approved" value="yes" '.$checked.'><label for="woocommerce_shopper_approved">Si</label>'; 
  $checked = $option=="no"?"checked":"";
  echo '<input type="radio" id="woocommerce_shopper_approved" name="woocommerce_shopper_approved" value="no" '.$checked.'><label for="woocommerce_shopper_approved">No</label>'; 
}

}


	//CARGA EL LA INFORMACIÓN COMO SHORTCODE
	add_shortcode( 'ustidnr', 'agregaustidnr' );
	add_shortcode( 'correo', 'agregacorreo' );
	add_shortcode( 'direccion', 'agregadireccion' );
	add_shortcode( 'direccion2', 'agregadireccion2' );
	add_shortcode( 'hra', 'agregahra' );
	add_shortcode( 'propietario', 'agregapropietario' );
	add_shortcode( 'mspartner', 'agregamspartner' );
	add_shortcode( 'telefono', 'agregatelefono' );
	add_shortcode( 'nombreshop', 'agreganombreshop' );
	add_action('woocommerce_admin_order_data_after_order_details','paypal1');//sale en edit de order
	add_shortcode( 'urltienda', 'urlTienda' );
	add_shortcode( 'vertrag', 'agregavertrag' );
	add_shortcode( 'lizenzgeber', 'agregalizenzgeber' );
	function agregaustidnr_init(){
		function agregaustidnr() {
		  $options = get_option( '_invoices_options' );
		  return $options['ustidnr'];
		}
		function agregacorreo($attr) {
			$args = shortcode_atts( array(
					'eslink' => 's',
				), $attr );
			$options = get_option( '_invoices_options' );
			if ($args['eslink']=="s"){
				return "<a href='mailto:".$options['correo_factura']."'>".$options['correo_factura']."</a>"; 
			}else{
				return $options['correo_factura'];
			}
		}
		function agregadireccion() {
		  $options = get_option( '_invoices_options' );
		  return $options['direccion_factura'];
		}
		function agregadireccion2() {
		  $options = get_option( '_invoices_options' );
		  return $options['direccion2_factura'];
		}
		function agregamspartner() {
		  $options = get_option( '_invoices_options' );
		  return $options['mspartner'];
		}
		function agregatelefono() {
		  $options = get_option( '_invoices_options' );
		  return $options['telefono'];
		}
		function agregahra() {
		  $options = get_option( '_invoices_options' );
		  return $options['hra'];
		}
		function agregapropietario() {
		  $options = get_option( '_invoices_options' );
		  return $options['propietario'];
		}
		function agreganombreshop() {
		  $options = get_option( 'wpo_wcpdf_settings_general' );
		  return $options['shop_name']['default'];
		}
		function paypal1($post){//sale en edit de order
			$tt=get_post_meta( $post->id,'_payment_method' );
			if ($tt[0]=='paypal'||$tt[0]=='ppec_paypal'){
				$options1 = get_post_meta( $post->id,'paypal_receiver' );
				echo "<p class='form-field form-field-wide wc-customer-user' style='color:blue;padding-top:190px;border:solid 1px gray;border-radius:3px;'>Paypal receiver: ".$options1[0]."</p>";
			}	
		}
		function urlTienda($attr){
			$args = shortcode_atts( array(
					'eslink' => 's',
					'prtcl'  => 's',
				), $attr );
			$home = get_option( 'siteurl' );
			if ($args['prtcl']<>"s"){
				$home=str_replace("https://", "", $home);
				$home=str_replace("http://", "", $home);
				$home=str_replace("https//", "", $home);
				$home=str_replace("http//", "", $home);
			}
			
			if ($args['eslink']=="s"){
				return "<a href='$home'>$home</a>";
			}else{
				return $home;
			}
		}
		function agregavertrag() {
		  $options = get_option( '_invoices_options' );
		  return $options['vertrag'];
		}
		function agregalizenzgeber() {
		  $options = get_option( '_invoices_options' );
		  return $options['lizenzgeber'];
		}
	}
	add_action('init', 'agregaustidnr_init');

function estilo_icono() {
    // Define el código CSS
    $css_personalizado = '
		.toplevel_page_my_custom_settings>.dashicons-admin-settings:before{color:#83A2FF!important;}
		//.toplevel_page_my_custom_settings div.dashicons-admin-settings:before{color:yellow!important;}
		//.dashicons-admin-settings{color:yellow!important;background-color:white!important;
		}
    ';

    // Registra el estilo
    wp_register_style('estilo-personalizado-admin', false); // El segundo parámetro es la URL, que es falso en este caso

    // Agrega el código CSS personalizado al estilo registrado
    wp_add_inline_style('estilo-personalizado-admin', $css_personalizado);

    // Enqueue the style
    wp_enqueue_style('estilo-personalizado-admin');
}

// Engancha la función a la acción 'admin_enqueue_scripts'
add_action('admin_enqueue_scripts', 'estilo_icono');
