<?php
// Agregar un menú en la sección de ajustes
// Version 2.1 (configuracion de mautic, hooks se borran cuando no hay filas)
defined( 'ABSPATH' ) || exit;

 
// Hook para agregar el menú de administración
add_action('admin_menu', 'wao_tiendas_menu');

function wao_tiendas_menu() {
    add_menu_page(
        'WAO Tiendas',
        'WAO Tiendas',
        'manage_options',
        'wao_tiendas',
        'wao_tiendas_page_content',
        'dashicons-store',
        6
    );
}

// Función para mostrar el contenido del menú
function wao_tiendas_page_content() {
    // Tabs
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'parametros_factura';
    ?>
    <div class="wrap">
        <h2>WAO Tiendas</h2>
        <h2 class="nav-tab-wrapper">
            <a href="?page=wao_tiendas&tab=parametros_factura" class="nav-tab <?php echo $active_tab == 'parametros_factura' ? 'nav-tab-active' : ''; ?>">Parámetros Factura</a>
            <a href="?page=wao_tiendas&tab=mailtrain_tracking" class="nav-tab <?php echo $active_tab == 'mailtrain_tracking' ? 'nav-tab-active' : ''; ?>">Email Marketing</a>
            <a href="?page=wao_tiendas&tab=configurar_widgets" class="nav-tab <?php echo $active_tab == 'configurar_widgets' ? 'nav-tab-active' : ''; ?>">Configurar Widgets de Red</a>
            <a href="?page=wao_tiendas&tab=textos_anadidos" class="nav-tab <?php echo $active_tab == 'textos_anadidos' ? 'nav-tab-active' : ''; ?>">Hooks</a>
        </h2>
        <?php
        switch ($active_tab) {
            case 'parametros_factura':
                wao_parametros_factura_content();
                break;
            case 'mailtrain_tracking':
                wao_mailtrain_tracking_content();
                break;
            case 'configurar_widgets':
                wao_configurar_widgets_content();
                break;
            case 'textos_anadidos':
                wao_textos_anadidos_content();
                break;
        }
    echo '</div>';
}

// Función para mostrar el contenido de 'Parámetros Factura'
function wao_parametros_factura_content() {
    $options = get_option('_invoices_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Guardar los valores en la opción
        $options = [
            'ustidnr' => sanitize_text_field($_POST['ustidnr']),
            'correo_factura' => sanitize_text_field($_POST['correo_factura']),
            'direccion_factura' => sanitize_text_field($_POST['direccion_factura']),
            'direccion2_factura' => sanitize_text_field($_POST['direccion2_factura']),
            'mspartner' => sanitize_text_field($_POST['mspartner']),
            'telefono' => sanitize_text_field($_POST['telefono']),
            'hra' => sanitize_text_field($_POST['hra']),
            'propietario' => sanitize_text_field($_POST['propietario']),
            'vertrag' => sanitize_text_field($_POST['vertrag']),
            'lizenzgeber' => sanitize_text_field($_POST['lizenzgeber']),
            'mostrar2factura' => sanitize_text_field($_POST['mostrar2factura']),
            'genverliz' => sanitize_text_field($_POST['genverliz'])
        ];
        update_option('_invoices_options', $options);
        echo '<div class="updated"><p>Parámetros guardados correctamente.</p></div>';
    }

    ?>
    <form method="post">
        <table class="form-table">
            <tr>
                <th><label for="ustidnr">USt-IdNr</label></th>
                <td><input type="text" name="ustidnr" id="ustidnr" value="<?php echo esc_attr($options['ustidnr'] ?? ''); ?>" /> Shortcode: [ustidnr]</td>
            </tr>
            <tr>
                <th><label for="correo_factura">Correo Factura</label></th>
                <td><input type="text" name="correo_factura" id="correo_factura" value="<?php echo esc_attr($options['correo_factura'] ?? ''); ?>" /> Shortcode: [correo]</td>
            </tr>
            <tr>
                <th><label for="direccion_factura">Dirección Factura</label></th>
                <td><textarea name="direccion_factura" id="direccion_factura"><?php echo esc_textarea($options['direccion_factura'] ?? ''); ?></textarea> Shortcode: [direccion]</td>
            </tr>
            <tr>
                <th><label for="direccion2_factura">Dirección 2 Factura</label></th>
                <td><textarea name="direccion2_factura" id="direccion2_factura"><?php echo esc_textarea($options['direccion2_factura'] ?? ''); ?></textarea> Shortcode: [direccion2]</td>
            </tr>
            <tr>
                <th><label for="mspartner">MS Partner</label></th>
                <td><input type="text" name="mspartner" id="mspartner" value="<?php echo esc_attr($options['mspartner'] ?? ''); ?>" /> Shortcode: [mspartner]</td>
            </tr>
            <tr>
                <th><label for="telefono">Teléfono</label></th>
                <td><input type="text" name="telefono" id="telefono" value="<?php echo esc_attr($options['telefono'] ?? ''); ?>" /> Shortcode: [telefono]</td>
            </tr>
            <tr>
                <th><label for="hra">HRA</label></th>
                <td><input type="text" name="hra" id="hra" value="<?php echo esc_attr($options['hra'] ?? ''); ?>" /> Shortcode: [hra]</td>
            </tr>
            <tr>
                <th><label for="propietario">Propietario</label></th>
                <td><input type="text" name="propietario" id="propietario" value="<?php echo esc_attr($options['propietario'] ?? ''); ?>" /> Shortcode: [propietario]</td>
            </tr>
            <tr>
                <th><label for="vertrag">Vertrag</label></th>
                <td><input type="text" name="vertrag" id="vertrag" value="<?php echo esc_attr($options['vertrag'] ?? ''); ?>" /> Shortcode: [vertrag]</td>
            </tr>
            <tr>
                <th><label for="lizenzgeber">Lizenzgeber</label></th>
                <td><input type="text" name="lizenzgeber" id="lizenzgeber" value="<?php echo esc_attr($options['lizenzgeber'] ?? ''); ?>" /> Shortcode: [lizenzgeber]</td>
            </tr>
            <tr>
                <th><label for="mostrar2factura">Mostrar la hoja 2 factura?</label></th>
                <td>
                    <input type="radio" name="mostrar2factura" value="S" <?php checked($options['mostrar2factura'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="mostrar2factura" value="N" <?php checked($options['mostrar2factura'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
            <tr>
                <th><label for="genverliz">Generar versión de licencia?</label></th>
                <td>
                    <input type="radio" name="genverliz" value="S" <?php checked($options['genverliz'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="genverliz" value="N" <?php checked($options['genverliz'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
        </table>
        <p><input type="submit" class="button button-primary" value="Guardar Cambios"></p>
    </form>
    <?php
}

// Manejo de peticion ajax para test de conexion
add_action('wp_ajax_load_ajax_content', 'wao_handle_ajax');
add_action('wp_ajax_nopriv_load_ajax_content', 'wao_handle_ajax');

function wao_handle_ajax() {
    //echo "Contenido generado por PHP dinámicamente 2";
	if (function_exists('mautic_test_page')) {
		echo mautic_test_page();  // Llamar a la función si existe
	} else {
		echo 'La función mautic_test_page() no está definida.';  // Mensaje de error si no existe
	}
    wp_die(); // Termina correctamente la solicitud
}

// Función para 'Mailtrain Tracking'
function wao_mailtrain_tracking_content() {

    $options = get_option('_mtt_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		$msg = 'Configuración guardada correctamente.';
		$options['mautic_url'] = normalize_url(sanitize_text_field($_POST['mautic_url']));
        $options['mautic_client_id'] = sanitize_text_field($_POST['mautic_client_id']);
        $options['mautic_client_secret'] = sanitize_text_field($_POST['mautic_client_secret']);
        $mautic_master_config = sanitize_text_field($_POST['mautic_master_config']);
		if(is_multisite()){
			if($mautic_master_config=='mc'){
				$sites = get_sites(); // Devuelve un array con todos los sitios en la red multisite
				foreach ($sites as $site) {
					switch_to_blog($site->blog_id);
					$options1=get_option('_mtt_options');
					$options1['mautic_url']=$options['mautic_url'];
					$options1['mautic_client_id']=$options['mautic_client_id'];
					$options1['mautic_client_secret']=$options['mautic_client_secret'];
					update_option('_mtt_options', $options1);
					restore_current_blog();
				}
				$msg = 'Configuración guardada correctamente para todos los sitios del multisite.';
			}
		}
        $options['mailtraintracking'] = sanitize_text_field($_POST['mailtraintracking']);
        $options['mautictracking'] = sanitize_text_field($_POST['mautictracking']);
		update_option('_mtt_options', $options);
        echo '<div class="updated"><p>'.$msg.'</p></div>';
    }
    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
        <table class="form-table">
            <tr>
				<th>
					<label for="mailtraintracking">Activar Mailtrain Tracking (Obsoleto)</label>
				</th>
				<td>
					<input type="checkbox" id="mailtraintracking" name="mailtraintracking" value="S" <?php checked($options['mailtraintracking'] ?? '', 'S'); ?>><small><i> (Mejor usar <b>utm_source</b> y <b>utm_campaign</b> de mautic)</i></small>
				</td>
					
            <tr>
            <tr>
				<th>
					<label for="mautictracking">Activar Filtros de Mautic Tracking</label>
				</th>
				<td>
					<input type="checkbox" id="mautictracking" name="mautictracking" value="S" <?php checked($options['mautictracking'] ?? '', 'S'); ?>>
					<small><i> (En ordenes woocommerce)</i></small>
				</td>
            <tr>
			<tr><th>Configurar api mautic</th><td></td></tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_url">Mautic URL</label></th>
                <td><input style="width:420px" type="text" name="mautic_url" id="mautic_url" value="<?php echo esc_attr($options['mautic_url'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_id">Mautic Client ID</label></th>
                <td><input style="width:420px"  type="text" name="mautic_client_id" id="mautic_client_id" value="<?php echo esc_attr($options['mautic_client_id'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_secret">Mautic Client Secret</label></th>
                <td><input style="width:420px"  type="text" name="mautic_client_secret" id="mautic_client_secret" value="<?php echo esc_attr($options['mautic_client_secret'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;">
					<button type="button" style="margin-left:30px;font-style:italic;" onclick="loadContent()">Test connection</button>
				</th>
                <td>
					<div id="dynamic-content" style="margin-top: 20px; border: 1px solid #ccc; padding: 10px;">
						<p>Test result.</p>
					</div>
				</td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_id">Master config</label></th>
                <td><input type="checkbox" name="mautic_master_config" id="mautic_master_config" value="mc"> <small><i> (Guardar para todos los subshops)</i></small> </td>
            </tr>

		</table>
        <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>
    </form>

	</div>
     <script>
        function loadContent() {
            // Crear la solicitud Fetch
			fetch(ajaxurl, {
				method: 'POST',
				headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
				body: new URLSearchParams({ action: 'load_ajax_content' })
			})
			.then(response => response.text())
			.then(html => {
				document.getElementById('dynamic-content').innerHTML = html;
			})
			.catch(error => console.error('Error:', error));
					}
    </script>   <?php
}

// Función para 'Configurar Widgets de Red'
function wao_configurar_widgets_content() {
    $options = get_option('_waotiendas_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $options['excluidos'] = sanitize_text_field($_POST['excluidos']);
        update_option('_waotiendas_options', $options);
        echo '<div class="updated"><p>Configuración guardada correctamente.</p></div>';
    }
    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
        <label for="excluidos">Excluidos</label>
        <input type="text" name="excluidos" id="excluidos" style="width:500px" value="<?php echo esc_attr($options['excluidos'] ?? ''); ?>" placeholder="Excluir sitios como manuals, etc." />
		<i>Excluir sitios como <b>manuals</b>, etc</i>
       <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>
    </form>
	</div>
    <?php
}

// Función para 'Textos Añadidos'
function wao_textos_anadidos_content() {
    $options = get_option('_textos_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['textos'])) {
        $options = array_map(function($texto) {
            return [
                'texto' => $texto['texto'],
                'ubicacion' => sanitize_text_field($texto['ubicacion']),
                'prioridad' => sanitize_text_field($texto['prioridad']),
                'activo' => sanitize_text_field($texto['activo'])
            ];
        }, $_POST['textos']);
		update_option('_textos_options', $options);
		echo '<div class="updated"><p>Textos guardados correctamente.</p></div>';
    }else{
		if(isset($_POST['guardar'])&&$_POST['guardar']=='Guardar'){
			delete_option('_textos_options');
			echo '<div class="updated"><p>No hay mas textos.</p></div>';
			unset($options);
		}
	}

    ?>
    <form method="post">
        <table class="form-table" style="width:70%">
            <thead>
                <tr style="border-bottom:solid 1px gray">
                    <th style="width:40%">Texto</th>
                    <th style="width:30%">Ubicación</th>
                    <th style="width:10%">Prioridad</th>
                    <th style="width:10%">Activo</th>
                    <th style="width:10%">Acciones</th>
                </tr>
            </thead>
            <tbody id="textos-rows">
                <?php foreach ($options as $index => $texto_data): ?>
                    <tr>
                        <td style="width:40%"><textarea cols="70" name="textos[<?php echo $index; ?>][texto]"><?php echo stripslashes($texto_data['texto']); ?></textarea></td>
                        <td style="width:30%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][ubicacion]" value="<?php echo esc_attr($texto_data['ubicacion']); ?>"></td>
						<td style="width:10%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][prioridad]" value="<?php echo esc_attr($texto_data['prioridad']); ?>"></td>
                        <td style="width:10%">
							<input style="width:10px;" type="checkbox" name="textos[<?php echo $index; ?>][activo]" value="S" <?php checked($texto_data['activo'], 'S'); ?>> Sí
                        </td>
                        <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <p><button type="button" class="button button-secondary" id="add-row">Incrementar fila</button></p>
        <p><input type="submit" class="button button-primary" id="guardar" name="guardar" value="Guardar"></p>
    </form>
    <script>
        document.getElementById('add-row').addEventListener('click', function() {
            const table = document.getElementById('textos-rows');
            const rowCount = table.rows.length;
            const newRow = table.insertRow();
            newRow.innerHTML = `
                <td style="width:40%"><textarea cols="70" name="textos[${rowCount}][texto]"></textarea></td>
                <td style="width:30%"><input style="width:100%;" type="text" name="textos[${rowCount}][ubicacion]"></td>
				<td style="width:10%"><input style="width:100%;" type="text" name="textos[${rowCount}][prioridad]"></td>
                <td style="width:10%">
					<input style="width:10px;" type="checkbox" name="textos[${rowCount}][activo]" value="S"> Sí
                </td>
                <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
            `;
            addDeleteFunctionality();
        });

        function addDeleteFunctionality() {
            document.querySelectorAll('.delete-row').forEach(button => {
                button.addEventListener('click', function() {
                    this.closest('tr').remove();
                });
            });
        }

        addDeleteFunctionality();
    </script>
    <?php
}


	add_shortcode( 'nombreshop', 'agreganombreshop' );
	//CARGA EL LA INFORMACIÓN COMO SHORTCODE
	add_shortcode( 'ustidnr', 'agregaustidnr' );
	add_shortcode( 'correo', 'agregacorreo' );
	add_shortcode( 'direccion', 'agregadireccion' );
	add_shortcode( 'direccion2', 'agregadireccion2' );
	add_shortcode( 'hra', 'agregahra' );
	add_shortcode( 'propietario', 'agregapropietario' );
	add_shortcode( 'mspartner', 'agregamspartner' );
	add_shortcode( 'telefono', 'agregatelefono' );
	add_action('woocommerce_admin_order_data_after_order_details','paypal1');//sale en edit de order
	add_shortcode( 'urltienda', 'urlTienda' );
	add_shortcode( 'vertrag', 'agregavertrag' );
	add_shortcode( 'lizenzgeber', 'agregalizenzgeber' );
	function agregaustidnr_init(){
		function agregaustidnr() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['ustidnr'];
		}
		function agregacorreo($attr) {
			$args = shortcode_atts( array(
					'eslink' => 's',
				), $attr );
			$options = get_option( '_invoices_options');
			if (!is_bool($options)) {
				if ($args['eslink']=="s"){
					return "<a href='mailto:".$options['correo_factura']."'>".$options['correo_factura']."</a>"; 
				}else{
					return $options['correo_factura'];
				}
			}else{return "none";}
		}
		function agregadireccion() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['direccion_factura'];
		}
		function agregadireccion2() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['direccion2_factura'];
		}
		function agregamspartner() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['mspartner'];
		}
		function agregatelefono() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['telefono'];
		}
		function agregahra() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['hra'];
		}
		function agregapropietario() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['propietario'];
		}
		function agreganombreshop() {
		  $options = get_option( 'wpo_wcpdf_settings_general' );
		  return is_bool($options)?"none":$options['shop_name']['default'];
		}
		function urlTienda($attr){
			$args = shortcode_atts( array(
					'eslink' => 's',
					'prtcl'  => 's',
				), $attr );
			$home = get_option( 'siteurl' );
			if ($args['prtcl']<>"s"){
				$home=str_replace("https://", "", $home);
				$home=str_replace("http://", "", $home);
				$home=str_replace("https//", "", $home);
				$home=str_replace("http//", "", $home);
			}
			
			if ($args['eslink']=="s"){
				return "<a href='$home'>$home</a>";
			}else{
				return $home;
			}
		}
		function agregavertrag() {
		  $options = get_option( '_invoices_options' );
		  return $options['vertrag'];
		}
		function agregalizenzgeber() {
		  $options = get_option( '_invoices_options' );
		  return $options['lizenzgeber'];
		}
	}
	add_action('init', 'agregaustidnr_init');

function estilo_icono() {
    // Define el código CSS
    $css_personalizado = '
		.toplevel_page_my_custom_settings>.dashicons-admin-settings:before{color:#83A2FF!important;}
		//.toplevel_page_my_custom_settings div.dashicons-admin-settings:before{color:yellow!important;}
		//.dashicons-admin-settings{color:yellow!important;background-color:white!important;}
    ';

    // Registra el estilo
    wp_register_style('estilo-personalizado-admin', false); // El segundo parámetro es la URL, que es falso en este caso

    // Agrega el código CSS personalizado al estilo registrado
    wp_add_inline_style('estilo-personalizado-admin', $css_personalizado);

    // Enqueue the style
    wp_enqueue_style('estilo-personalizado-admin');
}

// Engancha la función a la acción 'admin_enqueue_scripts'
//add_action('admin_enqueue_scripts', 'estilo_icono');

function paypal1($post){//sale en edit de order PAYPAL RECEIVER
	$id=$post->get_id();
	$tt=get_post_meta( $id,'_payment_method' );
	if ($tt[0]=='paypal'||$tt[0]=='ppec_paypal'||$tt[0]=='ppcp-gateway'||$tt[0]=='ppcp'){
		$options1 = get_post_meta( $id,'paypal_receiver' );
		echo "<p class='form-field form-field-wide wc-customer-user' style='color:blue;padding-top:190px;border:solid 1px gray;border-radius:3px;'>Paypal receiver: ".$options1[0]."</p>"; 
	}	
}

function get_waotiendas1_option($indice="nothing"){
	if(is_multisite()){
		$thissite = get_current_blog_id();
		switch_to_blog(1);
	}
	$option = get_option('_waotiendas_options',"");
	if(!isset($option[$indice])){
		$retorno = FALSE;
	}else{
		$retorno = $option[$indice];
	}
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}

function update_waotiendas1_option($indice,$valor){
	if(is_multisite()){
		$thissite = get_current_blog_id();
		switch_to_blog(1);
	}
	$option = get_option('_waotiendas_options');
	if(!is_bool($option[$indice])){
		$option[$indice]=$valor;
		if (update_option('_waotiendas_options',$option)){
			$retorno = TRUE;
		}else{
			$retorno = FALSE;
		}
	}else{
		$retorno = FALSE;
	}
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}

function normalize_url($url) {
    // Asegúrate de que la URL tenga el prefijo "https://"
    if (strpos($url, 'https://') !== 0) {
        $url = 'https://' . $url;
    }
    
    // Analiza la URL y obtén solo el host
    $parsed_url = parse_url($url);
    if (isset($parsed_url['host'])) {
        $host = $parsed_url['host'];
    } else {
        // Si no hay host, asume que toda la cadena es el host
        $host = $parsed_url['path'] ?? '';
    }
    
    // Devuelve la URL normalizada
    return 'https://' . $host;
}

