<?php
/**
 * @package Woocomerce-Rest-B
 */
/*
Plugin Name: Woocomerce-Rest-B
Plugin URI: https://highriskshop.com/
Description: Get Data from website a and create payment.
Version: 13.5.3
Author: High Risk Shop
Author URI: https://highriskshop.com/
*/

if (isset($_GET['total_amount'])) {
    global $WOOCS;
    $currency = $_GET['currency'];
    if (isset($WOOCS)) {
        if(get_option( 'woocommerce_currency' ) != $currency) {
            $WOOCS->set_currency($currency); 
        }
    }
    // Get the total amount from GET parameter
    $total_amount = floatval($_GET['total_amount']);
	$myordernow = $_GET['myordernow'];
	$myaffiliateurl = urldecode($_GET['myaffiliateurl']);
    
    // Flush old cookies
    setcookie('new_price', '', time() - 3600, '/');
	setcookie('myordernow', '', time() - 3600, '/');
	setcookie('myaffiliateurl', '', time() - 3600, '/');

    // Save new price in cookie
    setcookie('new_price', $total_amount, 0, '/');
	setcookie('myordernow', $myordernow, 0, '/');
	setcookie('myaffiliateurl', $myaffiliateurl, 0, '/');

    // Add query vars for total amount and billing fields
    function wc_prefilled_checkout_query_vars($vars) {
        $vars[] = 'total_amount';
        $vars[] = 'billing_first_name';
        $vars[] = 'billing_last_name';
        $vars[] = 'billing_email';
        $vars[] = 'billing_company'; // Add more billing fields as needed
        $vars[] = 'billing_address_1';
        $vars[] = 'billing_address_2';
        $vars[] = 'billing_city';
        $vars[] = 'billing_state';
        $vars[] = 'billing_postcode';
        $vars[] = 'billing_country';
        $vars[] = 'billing_phone';
        $vars[] = 'currency';
		$vars[] = 'myordernow';
		$vars[] = 'myaffiliateurl';
        //$vars[] = 'lang';
        // Add more fields as needed
        return $vars;
    }
    add_filter('query_vars', 'wc_prefilled_checkout_query_vars');

    // Prefill checkout fields based on URL parameters
    function wc_prefilled_checkout_fields() {
        // Check if we are already on the checkout page to avoid infinite redirect loop
        if (is_checkout()) {
            return;
        }

        WC()->cart->empty_cart(); // Empty the cart to prevent conflicting items

        // Get random product ID
        $products = get_posts(array(
            'post_type' => 'product',
            'posts_per_page' => -1,
            'fields' => 'ids',
        ));

        if ($products) {
            $random_product_id = array_rand($products);
            $product_id = $products[$random_product_id];
        } else {
            // If no products found, set a default product ID
            exit;
        }
        WC()->cart->add_to_cart($product_id, 1);

        // Prefill billing fields
        if (isset($_GET['billing_first_name'])) {
            WC()->customer->set_billing_first_name($_GET['billing_first_name']);
        }

        if (isset($_GET['billing_last_name'])) {
            WC()->customer->set_billing_last_name($_GET['billing_last_name']);
        }

        if (isset($_GET['billing_email'])) {
            WC()->customer->set_billing_email($_GET['billing_email']);
        }

        if (isset($_GET['billing_company'])) {
            WC()->customer->set_billing_company($_GET['billing_company']);
        }

        if (isset($_GET['billing_address_1'])) {
            WC()->customer->set_billing_address_1($_GET['billing_address_1']);
        }

        if (isset($_GET['billing_address_2'])) {
            WC()->customer->set_billing_address_2($_GET['billing_address_2']);
        }

        if (isset($_GET['billing_city'])) {
            WC()->customer->set_billing_city($_GET['billing_city']);
        }

        if (isset($_GET['billing_state'])) {
            WC()->customer->set_billing_state($_GET['billing_state']);
        }

        if (isset($_GET['billing_postcode'])) {
            WC()->customer->set_billing_postcode($_GET['billing_postcode']);
        }

        if (isset($_GET['billing_country'])) {
            WC()->customer->set_billing_country($_GET['billing_country']);
        }

        if (isset($_GET['billing_phone'])) {
            WC()->customer->set_billing_phone($_GET['billing_phone']);
        }

        if (isset($_GET['currency'])) {
            global $woocommerce;
            $woocommerce->session->set('order_currency', $_GET['currency']);
        }
        // Redirect to the checkout page only if necessary
        if (!is_checkout()) {
            $checkout_url = wc_get_checkout_url();
			header("Referrer-Policy: no-referrer");
            wp_safe_redirect($checkout_url);
            exit;
        }
    }
    add_action('template_redirect', 'wc_prefilled_checkout_fields');
}

add_action('woocommerce_before_calculate_totals', 'add_custom_price_to_cart_item', 10, 1);
function add_custom_price_to_cart_item($cart) {
    if (is_admin() && !defined('DOING_AJAX')) {
        return;
    }
    global $WOOCS;
    if (isset($WOOCS)) {
        remove_filter('woocommerce_product_get_price', array($WOOCS, 'woocs_get_price'), 9999);
        remove_filter('woocommerce_product_variation_get_price', array($WOOCS, 'woocs_get_price'), 9999);
        remove_filter('woocommerce_get_price', array($WOOCS, 'woocs_get_price'), 9999);
        remove_filter('woocommerce_order_get_total', array($WOOCS, 'woocs_order_get_total'), 9999);
    }

    foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
         if (isset($_COOKIE['new_price'])) {
            $new_price = floatval($_COOKIE['new_price']);
            $cart_item['data']->set_price($new_price);
        }
    }
}

add_action('woocommerce_new_order', 'update_external_order_id_and_url_meta', 11, 2);

function update_external_order_id_and_url_meta($order_id, $order) {
    if (isset($_COOKIE['myordernow'])) {
        update_post_meta($order_id, 'external_order_id', sanitize_text_field(urlencode($_COOKIE['myordernow'])));
    }

    if (isset($_COOKIE['myaffiliateurl'])) {
        $url_final = $_COOKIE['myaffiliateurl'];
        $url_final = str_replace('http://', '', $url_final);
        $url_final = str_replace('https://', '', $url_final);
        update_post_meta($order_id, 'hook_url', $url_final);
    }

    if (isset($_COOKIE['myaffiliateurl']) && isset($_COOKIE['myordernow'])) {
        $note = "Orden origen en en el shop : <a href='".$_COOKIE['myaffiliateurl']."/wp-admin/post.php?post=".$_COOKIE['myordernow']."&action=edit'>".$_COOKIE['myaffiliateurl']." Order #".$_COOKIE['myordernow']."</a>";
        $order->add_order_note($note);
    }

}


function request_call_to_a($order_id, $endpoint_path) {
    // Get hook_url and external_order_id meta variables
    $hook_url =  rtrim(('https://'.get_post_meta($order_id, 'hook_url', true)), '/');

    $external_order_id = get_post_meta($order_id, 'external_order_id', true);

    // Check if hook_url and external_order_id are valid
    if (empty($hook_url) || empty($external_order_id)) return;

    // Construct the CURL request
    $url = $hook_url . '/wp-json/api/v2/' . $endpoint_path;
    $fields = array('order_id' => $external_order_id);
    
    $ch = curl_init();

    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $fields
    ));

  
    // Execute the CURL request
    $response = curl_exec($ch);
    // Close CURL session
    curl_close($ch);
}

// Function to hook into different actions and call request_call_to_a with the respective endpoint paths
function hook_request_call_to_a($order_id, $endpoint_path) {
    request_call_to_a($order_id, $endpoint_path);
}

// Hooking into different actions with different endpoint paths
add_action('woocommerce_order_status_completed', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-completed');
}, 10, 1);

add_action('woocommerce_order_status_refunded', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-refunded');
}, 10, 1);

add_action('woocommerce_order_status_cancelled', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-cancelled');
}, 10, 1);

add_action('woocommerce_order_status_processing', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-processing');
}, 10, 1);

add_action('woocommerce_order_status_on-hold', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-hold');
}, 10, 1);

add_action('woocommerce_order_status_pending', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-pending');
}, 10, 1);

add_action('woocommerce_thankyou', function ($order_id) {
    hook_request_call_to_a($order_id, 'wcwcwcwcwcw837378373773-order-zeftprocessing');
}, 10, 1);


add_action( 'woocommerce_thankyou', 'your_wc_autocomplete_order' );
function your_wc_autocomplete_order( $order_id ) {
    if ( ! $order_id ) {
        return;
    }
    $order = wc_get_order( $order_id );
    if ( $order->has_status( 'completed' ) || $order->has_status( 'processing' ) ) {
        $hook_url = get_post_meta($order_id, 'hook_url', true);
        $external_order_id = get_post_meta($order_id, 'external_order_id', true);
        //$url = 'https://'.$hook_url . '/checkout/order-received/' . urlencode($external_order_id).'?id='.urlencode($external_order_id).'&search_key=true&id_payement='.urlencode($order_id);
        $current_site_url = home_url();

        $url = 'https://' . $hook_url . '/checkout/order-received/' . urlencode( $external_order_id )
             . '?id=' . urlencode( $external_order_id )
             . '&search_key=true'
             . '&id_payment=' . urlencode( $order_id )
             . '&site_url=' . urlencode( $current_site_url );


        wp_redirect( $url );
        exit;
    }
}

