<?php 
/*
Plugin Name: WAO ZELLE
Plugin URI: https://rus-dev.com/
Description: PLUGIN de pago para zelle
Version: 1.0.0
Author: Rusland Rojas
Author URI: https://rus-dev.com/
*/

if (!defined('ABSPATH')) exit;

add_action('plugins_loaded', 'init_wao_zelle_rest_api_gateway');

function init_wao_zelle_rest_api_gateway() {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

	class WC_Gateway_WAO_Zelle extends WC_Payment_Gateway {
		public $domain = 'wao_zelle_payment';

		public function __construct() {
			$this->id                 = 'wao_zelle';
			$this->icon               = plugins_url('zelle_35.png', __FILE__) ;
			$this->has_fields         = true;
			$this->method_title       = __('ZELLE (WAO)', $this->domain);
			$this->method_description = __('Pasarela para transferencias/QR con datos definidos por el admin.', $this->domain);

			$this->init_form_fields();
			$this->init_settings();

			$this->title        = $this->get_option('title', __('ZELLE Payment', $this->domain));
			$this->description  = $this->get_option('description', __('Payment Information', $this->domain));
			$this->instructions = $this->get_option('instructions', '');
			$this->order_status = $this->get_option('order_status', 'wc-on-hold');

			$this->display_email       = $this->get_option('display_email', '');
			$this->display_phone       = $this->get_option('display_phone', '');
			$this->display_description = $this->get_option('display_description', '');
			$this->display_image_url   = $this->get_option('display_image_url', '');

			add_action('woocommerce_update_options_payment_gateways_' . $this->id, [$this, 'process_admin_options']);

			add_action('woocommerce_thankyou_' . $this->id, [$this, 'thankyou_page']);

			add_action('woocommerce_email_after_order_table', [$this, 'email_block'], 10, 4);
		}

		public function get_icon() {
            $icon_url = plugins_url('zelle_35.png', __FILE__);
            return '<img src="' . esc_url($icon_url) . '" alt="PayPal" style="height: 24px;" />';
        }

		public function init_form_fields() {
			$this->form_fields = [
				'enabled' => [
					'title'   => __('Enable/Disable', $this->domain),
					'type'    => 'checkbox',
					'label'   => __('Enable ZELLE Payment (WAO)', $this->domain),
					'default' => 'yes'
				],
				'title' => [
					'title'       => __('Title', $this->domain),
					'type'        => 'text',
					'description' => __('Título mostrado al cliente en el checkout.', $this->domain),
					'default'     => __('Transferencia / QR', $this->domain),
					'desc_tip'    => true,
				],
				'order_status' => [
					'title'       => __('Order Status', $this->domain),
					'type'        => 'select',
					'class'       => 'wc-enhanced-select',
					'description' => __('Estado del pedido tras finalizar el checkout.', $this->domain),
					'default'     => 'wc-on-hold',
					'options'     => wc_get_order_statuses(),
				],
				'description' => [
					'title'       => __('Description (subtítulo opcional)', $this->domain),
					'type'        => 'textarea',
					'description' => __('Se muestra bajo el nombre del método en el checkout.', $this->domain),
					'default'     => __('Paga escaneando el código o usando los datos mostrados.', $this->domain),
				],
				'instructions' => [
					'title'       => __('Instructions (gracias/email, opcional)', $this->domain),
					'type'        => 'textarea',
					'description' => __('Se añade a la página de gracias y a los emails.', $this->domain),
					'default'     => '',
				],

				'display_email' => [
					'title'       => __('Email a mostrar', $this->domain),
					'type'        => 'text',
					'description' => __('Email de contacto/cuenta para transferencia.', $this->domain),
					'default'     => '',
				],
				'display_phone' => [
					'title'       => __('Phone a mostrar', $this->domain),
					'type'        => 'text',
					'description' => __('Teléfono/WhatsApp para confirmar o recibir el pago.', $this->domain),
					'default'     => '',
				],
				'display_description' => [
					'title'       => __('Descripción/instrucciones visibles en checkout', $this->domain),
					'type'        => 'textarea',
					'description' => __('Texto que verá el cliente (por ejemplo, “Escanea el QR y envía comprobante...”).', $this->domain),
					'default'     => '',
				],
				'display_image_url' => [
					'title'       => __('URL de Imagen (QR/Logo)', $this->domain),
					'type'        => 'text',
					'description' => __('Pega la URL de tu imagen (ej. un QR subido a Medios).', $this->domain),
					'default'     => '',
				],
			];
		}

		public function payment_fields() {

			$email = $this->display_email;
			$phone = $this->display_phone;
			$desc  = $this->display_description;
			$img   = $this->display_image_url;

			$currency_symbol = get_woocommerce_currency_symbol();
			$decimals        = wc_get_price_decimals();
			$total_number    = ( WC()->cart && isset( WC()->cart->get_totals()['total'] ) ) ? WC()->cart->get_totals()['total'] : 0;
			$total_formatted = wc_price( $total_number ); 

			?>
			<fieldset id="wao-zelle-info" class="wc-payment-form" style="margin-top:.5rem;">
				<div style="margin-bottom:10px;">
					<label>
						<?php 
						if ($this->get_description()) {
							echo str_replace('%total%', $total_formatted, $this->get_description());
						}
						?>
					</label>
				</div>

				<?php if ($email): ?>
					<p class="form-row">
						<label><?php echo esc_html__('Zelle Email', $this->domain); ?></label>
						<span style="display:flex; gap:.5rem; align-items:center;">
							<input type="text" readonly value="<?php echo esc_attr($email); ?>" id="wao_show_email" style="padding: 4px 6px;font-weight: bold;margin: 0;border-radius: 0;" />
							<button type="button" class="button" data-copy="#wao_show_email"><?php echo esc_html__('Copy', $this->domain); ?></button>
						</span>
					</p>
				<?php endif; ?>

				<?php if ($phone): ?>
					<p class="form-row">
						<label><?php echo esc_html__('Zelle Phone', $this->domain); ?></label>
						<span style="display:flex; gap:.5rem; align-items:center;">
							<input type="text" readonly value="<?php echo esc_attr($phone); ?>" id="wao_show_phone" style="padding: 4px 6px;font-weight: bold;margin: 0;border-radius: 0;" />
							<button type="button" class="button" data-copy="#wao_show_phone"><?php echo esc_html__('Copy', $this->domain); ?></button>
						</span>
					</p>
				<?php endif; ?>

				<div class="clear"></div>

				<?php if ($img): ?>
					<div style="margin-top:.5rem;text-align: center;">
						<img src="<?php echo esc_url($img); ?>" alt="imagen" style="border: 1px solid #eee;padding: 4px;border-radius: 6px;float: none;width: 100%;max-width: 230px;height: auto;max-height: inherit;margin: 0 auto;" />
					</div>
				<?php endif; ?>

				<?php if ($desc): ?>
					<p class="form-row form-row-wide text-align: center;">
						<p><?php echo esc_attr($desc); ?></p>
					</p>
				<?php endif; ?>
			</fieldset>

			<script>
			(function(){
				document.querySelectorAll('#wao-zelle-info [data-copy]').forEach(function(btn){
					btn.addEventListener('click', function(){
						const sel = this.getAttribute('data-copy');
						const inp = document.querySelector(sel);
						if(!inp) return;
						inp.select(); inp.setSelectionRange(0,99999);
						try { document.execCommand('copy'); } catch(e){}
						const txt = this.textContent;
						this.textContent = '<?php echo esc_js(__('Copiado', $this->domain)); ?>';
						setTimeout(()=>{ this.textContent = txt; }, 1200);
					});
				});
			})();
			</script>
			<?php
		}

		public function thankyou_page($order_id) {
			if ($this->instructions) {
				echo wpautop(wptexturize($this->instructions));
			}
			$order = wc_get_order($order_id);
			if ($order && $order->get_payment_method() === $this->id) {
				echo $this->render_block_from_meta_or_options($order);
			}
		}

		public function email_block($order, $sent_to_admin, $plain_text, $email) {
			if (! $order instanceof WC_Order) return;

			if ( $order->get_payment_method() !== $this->id ) return;

			// 
			if ( $email->id !== 'customer_on_hold_order' ) return;

			if ( ! $order->has_status( 'on-hold' ) ) return;

			if ($plain_text) {
				$em = get_post_meta($order->get_id(), '_wao_email', true);
				$ph = get_post_meta($order->get_id(), '_wao_phone', true);
				$im = get_post_meta($order->get_id(), '_wao_image_url', true);

				if (!$em && !$ph && !$im) { // fallback a opciones si no hay snapshot
					$em = $this->display_email; $ph = $this->display_phone; $im = $this->display_image_url;
				}
				echo "\n" . __('Payment details - ZELLE:', $this->domain) . "\n";
				if ($em) echo 'Email: ' . $em . "\n";
				if ($ph) echo 'Phone: ' . $ph . "\n";
				if ($im) echo 'Imagen: ' . $im . "\n";
				echo "\n";
			} else {
				echo $this->render_block_from_meta_or_options($order);
			}
		}

		private function render_block_from_meta_or_options(WC_Order $order) : string {
			$em = get_post_meta($order->get_id(), '_wao_email', true) ?: $this->display_email;
			$ph = get_post_meta($order->get_id(), '_wao_phone', true) ?: $this->display_phone;
			//$de = get_post_meta($order->get_id(), '_wao_description', true) ?: $this->display_description;
			$im = get_post_meta($order->get_id(), '_wao_image_url', true) ?: $this->display_image_url;

			ob_start(); ?>
			<section style="margin:12px 0;">
				<h3 style="margin:0 0 6px;"><?php echo esc_html__('Payment details - ZELLE', $this->domain); ?></h3>
				<p><b><?php echo esc_html__('Email', $this->domain); ?></b>: <?php echo esc_html($em); ?><br>
					<b><?php echo esc_html__('Phone', $this->domain); ?></b>: <?php echo esc_html($ph); ?></p>
				<p><img src="<?php echo esc_url($im); ?>" alt="imagen" style="max-width:220px;height:auto;border:1px solid #eee;padding:4px;border-radius:6px;" /></p>
			</section>
			<?php
			return ob_get_clean();
		}

		public function process_payment($order_id) {
			$order = wc_get_order($order_id);

			// Guardar snapshot de los datos visibles en este pedido
			if ($this->display_email)       update_post_meta($order_id, '_wao_email', sanitize_text_field($this->display_email));
			if ($this->display_phone)       update_post_meta($order_id, '_wao_phone', sanitize_text_field($this->display_phone));
			//if ($this->display_description) update_post_meta($order_id, '_wao_description', wp_kses_post($this->display_description));
			//if ($this->display_image_url)   update_post_meta($order_id, '_wao_image_url', esc_url_raw($this->display_image_url));

			// Estado por defecto configurable (wc-on-hold por defecto)
			$status = (strpos($this->order_status, 'wc-') === 0) ? substr($this->order_status, 3) : $this->order_status;
			$order->update_status($status, __('Checkout con ZELLE (WAO).', $this->domain));

			$order->reduce_order_stock();
			WC()->cart->empty_cart();

			return [
				'result'   => 'success',
				'redirect' => $this->get_return_url($order),
			];
		}
	}

	// Registrar el gateway
	add_filter('woocommerce_payment_gateways', function($methods){
		$methods[] = 'WC_Gateway_WAO_Zelle';
		return $methods;
	});
}

// Admin: mostrar en la pantalla del pedido
add_action('woocommerce_admin_order_data_after_billing_address', function($order){
	if (! $order instanceof WC_Order) return;
	if ($order->get_payment_method() !== 'wao_zelle') return;

	$em = get_post_meta($order->get_id(), '_wao_email', true);
	$ph = get_post_meta($order->get_id(), '_wao_phone', true);
	//$de = get_post_meta($order->get_id(), '_wao_description', true);
	//$im = get_post_meta($order->get_id(), '_wao_image_url', true);

	echo '<div class="address"><h3>' . esc_html__('SENT TO ZELLE DATA ', 'wao_zelle_payment') . '</h3>';
	if ($em) echo '<p><strong>Email:</strong> ' . esc_html($em) . '</p>';
	if ($ph) echo '<p><strong>Phone:</strong> ' . esc_html($ph) . '</p>';
	//if ($de) echo '<p><strong>' . esc_html__('Descripción', 'wao_zelle_payment') . ':</strong><br>' . wp_kses_post(nl2br($de)) . '</p>';
	//if ($im) echo '<p><strong>' . esc_html__('Imagen', 'wao_zelle_payment') . ':</strong><br><img src="'.esc_url($im).'" style="max-width:220px;height:auto;border:1px solid #eee;padding:4px;border-radius:6px;" /></p>';
	echo '</div>';
}, 10, 1);


// JS para mantener el total sincronizado cuando cambia el checkout (envío, cupones, etc.)
add_action('wp_footer', function(){
    if ( ! is_checkout() ) return; ?>
    <script>
    (function($){
        function updateWaoTotal(){
            var totalText = $('#order_review .order-total .amount').first().text() || $('#order_review .order-total').text();
            var $inp = $('#wao_order_total_display');
            if ($inp.length && totalText){
                $inp.val(totalText.trim());
            }
        }
        $(document.body).on('updated_checkout', updateWaoTotal);
        $(document).ready(updateWaoTotal);
    })(jQuery);
    </script>
    <?php
}, 99);